package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.duty.DutyTableInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.duty.FieldPermissionsInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.duty.UserJoinFieldInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.DutyTableInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.FieldPermissionsInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.UserJoinFieldInfo;
import com.chenyang.nse.bussiness.service.core.DutyUserService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DutyUserServiceImpl implements DutyUserService {
   @Autowired
   DutyTableInfoDao dutyTableInfoDao;
   @Autowired
   UserJoinFieldInfoDao userJoinFieldInfoDao;
   @Autowired
   FieldPermissionsInfoDao fieldPermissionsInfoDao;

   public void saveDutyTableInfo(DutyTableInfo dutyTableInfo) {
      this.dutyTableInfoDao.save(dutyTableInfo);
   }

   public void saveUserJoinFieldInfo(UserJoinFieldInfo userJoinFieldInfo) {
      this.userJoinFieldInfoDao.save(userJoinFieldInfo);
   }

   public void saveFieldPermissionsInfo(FieldPermissionsInfo fieldPermissionsInfo) {
      this.fieldPermissionsInfoDao.save(fieldPermissionsInfo);
   }

   public void removeUserJoinFieldInfo(String dutytableid) {
      this.userJoinFieldInfoDao.remove(new Criterion[]{Restrictions.eq("dutytableid", dutytableid)});
   }

   public void removefieldPermissionsInfo(String dutytableid, String joinid) {
      this.fieldPermissionsInfoDao.remove(new Criterion[]{Restrictions.eq("dutytableid", dutytableid), Restrictions.eq("userjoinid", joinid)});
   }

   public DutyTableInfo queryDutyTableById(String id) {
      return (DutyTableInfo)this.dutyTableInfoDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
   }

   public void updateDutyTableInfo(DutyTableInfo dutyTableInfo) {
      this.dutyTableInfoDao.update(dutyTableInfo);
   }

   public List<DutyTableInfo> queryExists(String datasystemid, String schemaname, String tablename, String projectid) {
      return this.dutyTableInfoDao.queryAll(new Criterion[]{Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("schemaname", schemaname), Restrictions.eq("tablename", tablename), Restrictions.eq("projectid", projectid)});
   }

   public List<UserJoinFieldInfo> queryUserJoinFieldInfo(String dutytableid, String joinid) {
      return this.userJoinFieldInfoDao.queryAll(new Criterion[]{Restrictions.eq("dutytableid", dutytableid), Restrictions.eq("joinid", joinid)});
   }

   public List<FieldPermissionsInfo> queryFieldPermissionsInfo(String id) {
      return this.fieldPermissionsInfoDao.queryAll(new Criterion[]{Restrictions.eq("userjoinid", id)});
   }

   public void updateFieldInfo(String dutytableid, String column, String businessid, String skillid) {
      this.fieldPermissionsInfoDao.updateFieldInfo(dutytableid, column, businessid, skillid);
   }

   public List<FieldPermissionsInfo> queryFieldAll(String dutytableid, String column) {
      return this.fieldPermissionsInfoDao.queryAll(new Criterion[]{Restrictions.eq("dutytableid", dutytableid), Restrictions.eq("columnname", column)});
   }
}
