package com.chenyang.nse.bussiness.service.info.db;

import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MARIADB extends CommonMethod implements DatabaseTool {
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      targetradio.append("<select name='execution_type' >");

      for(String[] radio : importtype) {
         targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      targetradio.append("</select>");
      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String functionName = "";
      String sql = "show create trigger ";
      String sql_user = "show  triggers";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            functionName = rs.getString("Trigger");
            ps = s_conn.prepareStatement(sql + functionName);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append("CREATE ");
               sb.append(rs.getString("SQL Original Statement").substring(rs.getString("SQL Original Statement").indexOf("TRIGGER")));
               listTriggers.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listFunction = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String functionName = "";
      String sql = "show create function ";
      String sql_user = "show function  status where Db= '" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            functionName = rs.getString("Name");
            ps = s_conn.prepareStatement(sql + functionName);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append("CREATE ");
               sb.append(rs.getString("Create Function").substring(rs.getString("Create Function").indexOf("FUNCTION")));
               listFunction.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listFunction;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String functionName = "";
      String sql = "show create procedure ";
      String sql_user = "show procedure  status where Db= '" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            functionName = rs.getString("Name");
            ps = s_conn.prepareStatement(sql + functionName);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append("CREATE ");
               sb.append(rs.getString("Create Procedure").substring(rs.getString("Create Procedure").indexOf("PROCEDURE")));
               listProcedure.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynConstraintParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      return null;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
