package com.chenyang.nse.bussiness.service.redis.impl;

import com.chenyang.nse.bussiness.dao.redis.RedisDao;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.redis.CacheUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl implements RedisService {
   @Autowired
   private RedisDao redisDao;
   @Autowired
   private RedisTemplate redisTemplate;

   public Object queryValue(String cacheName, String key) {
      Object cacheBean = this.redisDao.getCacheValue(cacheName, key);
      return null != cacheBean ? ((SimpleValueWrapper)cacheBean).get() : null;
   }

   public void delCacheValue(String key, String cacheName) {
      this.redisDao.delCacheValue(key, cacheName);
   }

   public boolean set(final String key, Object value) {
      boolean result = false;

      try {
         CacheUtil.put(key, value);
         result = true;
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public boolean set(final String key, Object value, Long expireTime) {
      boolean result = false;

      try {
         ValueOperations<Serializable, Object> operations = this.redisTemplate.opsForValue();
         operations.set(key, value);
         this.redisTemplate.expire(key, expireTime, TimeUnit.SECONDS);
         result = true;
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public void remove(final String... keys) {
      for(String key : keys) {
         this.remove(key);
      }

   }

   public void removeLikePrefix(String keyLike) {
      Set<String> keys = this.redisTemplate.keys(keyLike + "*");
      this.redisTemplate.delete(keys);
   }

   public void removePattern(final String pattern) {
      Set<Serializable> keys = this.redisTemplate.keys(pattern);
      if (keys.size() > 0) {
         this.redisTemplate.delete(keys);
      }

   }

   public void remove(final String key) {
      if (this.exists(key)) {
         this.redisTemplate.delete(key);
      }

   }

   public boolean exists(final String key) {
      return CacheUtil.getCacheValue(key) != null;
   }

   public Object get(final String key) {
      Object result = CacheUtil.getCacheValue(key);
      return result;
   }

   public void hmSet(String key, Object hashKey, Object value) {
      HashOperations<String, Object, Object> hash = this.redisTemplate.opsForHash();
      hash.put(key, hashKey, value);
   }

   public void hmDel(String key, Object hashKey) {
      HashOperations<String, Object, Object> hash = this.redisTemplate.opsForHash();
      hash.delete(key, new Object[]{hashKey});
   }

   public Object hmGet(String key, Object hashKey) {
      HashOperations<String, Object, Object> hash = this.redisTemplate.opsForHash();
      return hash.get(key, hashKey);
   }

   public Object hkeys(String key) {
      HashOperations<String, Object, Object> hash = this.redisTemplate.opsForHash();
      return hash.keys(key);
   }

   public void lPush(String k, Object v) {
      ListOperations<String, Object> list = this.redisTemplate.opsForList();
      list.rightPush(k, v);
   }

   public List<Object> lRange(String k, long l, long l1) {
      ListOperations<String, Object> list = this.redisTemplate.opsForList();
      return list.range(k, l, l1);
   }

   public void add(String key, Object value) {
      SetOperations<String, Object> set = this.redisTemplate.opsForSet();
      set.add(key, new Object[]{value});
   }

   public Set<Object> setMembers(String key) {
      SetOperations<String, Object> set = this.redisTemplate.opsForSet();
      return set.members(key);
   }

   public void zAdd(String key, Object value, double scoure) {
      ZSetOperations<String, Object> zset = this.redisTemplate.opsForZSet();
      zset.add(key, value, scoure);
   }

   public void zAdd(String key, Object value, double scoure, Long expireTime) {
      ZSetOperations<String, Object> zset = this.redisTemplate.opsForZSet();
      zset.add(key, value, scoure);
      this.redisTemplate.expire(key, expireTime, TimeUnit.SECONDS);
   }

   public Set<Object> rangeByScore(String key, double scoure, double scoure1) {
      ZSetOperations<String, Object> zset = this.redisTemplate.opsForZSet();
      return zset.rangeByScore(key, scoure, scoure1);
   }

   public Set<Object> range(String key, int scoure, int scoure1) {
      ZSetOperations<String, Object> zset = this.redisTemplate.opsForZSet();
      return zset.range(key, (long)scoure, (long)scoure1);
   }

   public void zRem(String key, Object... member) {
      ZSetOperations<String, Object> zset = this.redisTemplate.opsForZSet();
      zset.remove(key, member);
   }

   public Long zCard(String key) {
      return this.redisTemplate.opsForZSet().zCard(key);
   }

   public void pipeline(HashMap<String, Object> map, String key) {
      SessionCallback callback = null;
      this.redisTemplate.executePipelined(callback);
   }
}
