package com.chenyang.nse.bussiness.tools.dataprocess.hive;

import ch.qos.logback.classic.Logger;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.HdfsFileInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.TableInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format.DataBatch;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format.HdfsItemIterator;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.operator.HdfsOperator;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HdfsBase {
   protected boolean isEncryption;
   protected Logger encryptionlogger;
   protected TCoreDatasystem tCoreDatasystem;
   protected List<ColumnInfoVO> columnInfoList;
   protected String COMPLETE;
   protected String RUNNING;
   protected String FAIL;
   protected String dataSystemId;
   protected String projectId;
   protected String tableName;
   protected String schema;
   protected TableInfo table;
   protected TCoreEncryptionService tCoreEncryptionService;
   protected TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao;
   protected List<HdfsFileInfo> files;
   protected HdfsOperator hdfs;
   protected Connection connection;
   protected int totalCount = 0;
   int batchCommitCount = 100000;
   int succedCount = 0;
   int rejectedCount = 0;

   private Map<Integer, ColumnInfoVO> getFiledRules() throws SQLException {
      Map<Integer, ColumnInfoVO> refs = new HashMap();
      ResultSet rs = JdbcTool.getColumns(this.connection, this.schema, this.tableName);
      Throwable var3 = null;

      try {
         for(int i = 0; rs.next(); ++i) {
            String colName = rs.getString("COLUMN_NAME");
            ColumnInfoVO rule = (ColumnInfoVO)this.columnInfoList.stream().filter((x) -> x.getColumnName().equalsIgnoreCase(colName)).findFirst().orElse(null);
            refs.put(i, rule);
         }
      } catch (Throwable var14) {
         var3 = var14;
         throw var14;
      } finally {
         if (rs != null) {
            if (var3 != null) {
               try {
                  rs.close();
               } catch (Throwable var13) {
                  var3.addSuppressed(var13);
               }
            } else {
               rs.close();
            }
         }

      }

      return refs;
   }

   protected void initState() {
      if (this.isEncryption) {
         this.COMPLETE = "5";
         this.RUNNING = "-1";
         this.FAIL = "4";
      } else {
         this.COMPLETE = "7";
         this.RUNNING = "-2";
         this.FAIL = "44";
      }

   }

   protected Map<String, Object> beginExecute() {
      this.encryptionlogger.info(">>>>>>>>>>>>>>>>>>>>> TDH大数据文本文件 readHdfsFileByUrl start>>>>>>>>>>>>>>>>>>>>>");

      for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
         this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), this.RUNNING);
      }

      this.logBegin(this.tCoreJiaMiJieMiJinDuDao);
      Map<String, Object> msg = new HashMap();
      String tableFullName = "`" + this.schema + "`.`" + this.table.tableName + "`";
      String sql = "select count(*) from " + tableFullName;
      int jiamiTasktotalCounts = 0;

      try {
         Statement statement = this.connection.createStatement();
         Throwable var6 = null;

         try {
            ResultSet resultSet = statement.executeQuery(sql);
            Throwable var8 = null;

            try {
               if (resultSet.next()) {
                  String count = resultSet.getObject(1).toString();
                  jiamiTasktotalCounts = Integer.parseInt(count);
               }
            } catch (Throwable var33) {
               var8 = var33;
               throw var33;
            } finally {
               if (resultSet != null) {
                  if (var8 != null) {
                     try {
                        resultSet.close();
                     } catch (Throwable var32) {
                        var8.addSuppressed(var32);
                     }
                  } else {
                     resultSet.close();
                  }
               }

            }
         } catch (Throwable var35) {
            var6 = var35;
            throw var35;
         } finally {
            if (statement != null) {
               if (var6 != null) {
                  try {
                     statement.close();
                  } catch (Throwable var31) {
                     var6.addSuppressed(var31);
                  }
               } else {
                  statement.close();
               }
            }

         }
      } catch (Exception var37) {
         msg.put("error", "获取表" + tableFullName + "条数失败:" + sql);
         return msg;
      }

      this.totalCount = jiamiTasktotalCounts;
      this.logTotalCount(this.tCoreJiaMiJieMiJinDuDao, jiamiTasktotalCounts);
      return msg;
   }

   protected Map<String, Object> execute(String columnName) {
      Map<String, Object> msg = new HashMap();
      if (columnName != null && columnName.length() > 0) {
         columnName = columnName.toLowerCase();
      }

      try {
         String sourceDelimiters = "\t";
         this.encryptionlogger.info("sourceDelimiters is (" + sourceDelimiters + ")");
         if (this.files != null && this.files.size() != 0) {
            Map<Integer, ColumnInfoVO> rules = this.getFiledRules();
            List<Integer> validRules = (List)rules.entrySet().stream().filter((x) -> x.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toList());
            if (validRules.size() == 0) {
               HashMap var47 = new HashMap();
               return var47;
            } else {
               Map<String, ColumnInfoVO> ruleNameMap = (Map)this.columnInfoList.stream().collect(Collectors.toMap((x) -> x.getColumnName().toLowerCase(), (x) -> x));
               String newName = null;

               for(HdfsFileInfo file : this.files) {
                  try {
                     int cnt = 0;
                     newName = file.getFullName() + "_temp";
                     OutputStream output = this.hdfs.createFile(this.schema, this.table.tableName, newName);
                     if (output == null) {
                        throw new Exception("服务器异常，创建临时替换文件" + newName + "失败");
                     }

                     HdfsItemIterator batchDataIter = this.hdfs.loadFileIter(this.schema, this.table.tableName, file.getFullName());
                     List<ColumnInfo> fieldList = this.table.cols;
                     String sourceType = this.table.sourceType;
                     String dataProcessType = this.table.dataProcessType;

                     while(batchDataIter.hasNext()) {
                        DataBatch batchData = batchDataIter.next();

                        try {
                           for(DataBatch.DataRow dataRow : batchData.rows) {
                              ++cnt;
                              StringBuilder row = new StringBuilder();
                              this.dealRowCols(rules, ruleNameMap, validRules, fieldList, sourceType, dataProcessType, sourceDelimiters, dataRow, columnName, row);
                              row.append(this.table.lineDelimiter);
                              byte[] buffer = row.toString().getBytes(StandardCharsets.UTF_8);
                              output.write(buffer);
                              output.flush();
                              if (cnt % this.batchCommitCount == 0) {
                                 cnt = 0;

                                 try {
                                    this.hdfs.saveBatch(this.schema, this.table.tableName, newName, output);
                                    this.succedCount += this.batchCommitCount;
                                    this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, (String)null);
                                 } catch (Exception ex) {
                                    try {
                                       this.hdfs.deleteFile(this.schema, this.tableName, newName);
                                    } catch (Exception e) {
                                       e.printStackTrace();
                                       this.encryptionlogger.error(e.toString());
                                    }

                                    msg.put("error", ex.toString());
                                    this.rejectedCount += this.batchCommitCount;
                                    this.encryptionlogger.error((String)msg.get("error"));
                                    this.encryptionlogger.warn("提交到" + this.succedCount + "行，执行异常!");
                                    this.encryptionlogger.warn("{}行加密数据提交失败!", this.succedCount);
                                    this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, ex.toString());
                                    this.logEncDecFailed(columnName);
                                    return msg;
                                 }
                              }
                           }
                        } catch (Exception ex) {
                           try {
                              this.hdfs.deleteFile(this.schema, this.tableName, newName);
                           } catch (Exception e) {
                              e.printStackTrace();
                           }

                           this.encryptionlogger.info("源[" + this.table.tableName + "]数据处理到第[" + cnt + "]行报错");
                           this.encryptionlogger.error(ex.toString());
                           msg.put("error", ex.toString());
                           this.encryptionlogger.warn("提交到" + this.succedCount + "行，执行异常!");
                           this.encryptionlogger.warn("{}行加密数据提交失败!", this.succedCount);
                           this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, ex.toString());
                           this.logEncDecFailed(columnName);
                           return msg;
                        }
                     }

                     if (cnt > 0) {
                        try {
                           this.hdfs.saveBatch(this.schema, this.table.tableName, newName, output);
                           this.succedCount += cnt;
                           this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, (String)null);
                        } catch (Exception ex) {
                           try {
                              this.hdfs.deleteFile(this.schema, this.tableName, newName);
                           } catch (Exception e) {
                              this.encryptionlogger.error(e.toString());
                              e.printStackTrace();
                           }

                           msg.put("error", ex.toString());
                           this.rejectedCount += cnt;
                           this.encryptionlogger.error((String)msg.get("error"));
                           this.encryptionlogger.warn("提交到" + this.succedCount + "行，执行异常!");
                           this.encryptionlogger.warn("{}行加密数据提交失败!", this.succedCount);
                           this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, this.FAIL);
                           this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, ex.toString());
                           this.logEncDecFailed(columnName);
                           return msg;
                        }
                     }

                     try {
                        this.hdfs.deleteFile(this.schema, this.table.tableName, file.getFullName());
                        this.hdfs.rename(this.schema, this.table.tableName, file.getFullName(), newName);
                     } catch (Exception ex) {
                        msg.put("error", ex.toString());
                        this.encryptionlogger.error((String)msg.get("error"));
                        this.encryptionlogger.warn("提交到" + this.succedCount + "行，执行异常!");
                        this.encryptionlogger.warn("{}行加密数据提交失败!", this.succedCount);
                        this.logBatchCount(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, columnName, ex.toString());
                        this.logEncDecFailed(columnName);
                        return msg;
                     }
                  } catch (Exception ex) {
                     this.logEncDecFailed(columnName);
                     this.encryptionlogger.error(ex.toString());
                     ex.printStackTrace();
                     msg.put("error", ex.toString());
                     return msg;
                  }
               }

               try {
                  this.hdfs.fininshed(this.schema, this.tableName);
               } catch (Exception exception) {
                  this.encryptionlogger.error(exception.toString());
                  this.logEncDecFailed(columnName);
                  msg.put("error", exception.toString());
                  return msg;
               }

               return msg;
            }
         } else {
            this.encryptionlogger.info("没有文件可以进行加密机密。");
            this.logEncDecSuccess();
            HashMap rules = new HashMap();
            return rules;
         }
      } catch (Exception e) {
         this.encryptionlogger.error(e.toString());
         this.encryptionlogger.info("加密错误 ：" + e.toString());
         msg.put("error", "加密失败:" + e.getMessage());
         return msg;
      } finally {
         ;
      }
   }

   protected void endExecute() {
      this.logEnd(this.tCoreJiaMiJieMiJinDuDao, this.succedCount, this.rejectedCount, (String)null);
   }

   private void dealRowCols(Map<Integer, ColumnInfoVO> rules, Map<String, ColumnInfoVO> ruleMap, List<Integer> validRules, List<ColumnInfo> fieldList, String sourceType, String dataProcessType, String sourceDelimiters, DataBatch.DataRow lineArr, String columnName, StringBuilder newRow) throws Exception {
      for(int i = 0; i < fieldList.size(); ++i) {
         String cname = ((ColumnInfo)fieldList.get(i)).getColumnname();
         DataBatch.DataCell cell = (DataBatch.DataCell)lineArr.cells.get(i);
         Object val = cell.value.value;
         if (!validRules.contains(i)) {
            newRow.append(val == null ? "" : val.toString());
         } else if (columnName != null && !cname.equalsIgnoreCase(columnName)) {
            newRow.append(val == null ? "" : val.toString());
         } else {
            ColumnInfoVO columnInfo = (ColumnInfoVO)rules.get(i);
            String encryptionType = columnInfo.getEncryptionType();
            String secretKey = columnInfo.getSecretKey();
            String isLike = columnInfo.getIsLike();
            String keepfirst = columnInfo.getKeepfirst();
            String encdigit = columnInfo.getEncdigit();
            String twoindex = columnInfo.getTwoindex();
            String newValue = val.toString();
            if (this.isEncryption) {
               newValue = this.doEncryptionMethod(encryptionType, secretKey, newValue, isLike, keepfirst, encdigit, twoindex);
            } else {
               newValue = this.doDecryptionMethod(encryptionType, secretKey, newValue, isLike, keepfirst, encdigit, twoindex);
            }

            newRow.append(newValue);
         }

         if (i != fieldList.size() - 1) {
            newRow.append(sourceDelimiters);
         }
      }

   }

   private String escapeCharacterProcessing(String sourceType, String dataProcessType, String lineArrData) {
      if (dataProcessType.startsWith("DB_batchread_FILE") && (EdbType.MYSQL.toString().equalsIgnoreCase(sourceType) || EdbType.RAPIDSDB.toString().equalsIgnoreCase(sourceType)) && lineArrData.contains("\\0")) {
         lineArrData = lineArrData.replace("\\0", "");
      }

      return lineArrData;
   }

   private Object removeQuotation(String str, String quoteCharacter) {
      Object reValue = null;
      if ((null == str || "".equals(str)) && "none".equalsIgnoreCase(quoteCharacter)) {
         return null;
      } else if (("Single".equalsIgnoreCase(quoteCharacter) || "Double".equalsIgnoreCase(quoteCharacter)) && !str.contains("'") && !str.contains("\"")) {
         if (!"".equals(str) && null != str) {
            if (" ".equals(str)) {
               return str;
            } else {
               if (str.contains(".")) {
                  reValue = Double.parseDouble(str.toLowerCase());
               } else {
                  reValue = Long.parseLong(str.toLowerCase());
               }

               return reValue;
            }
         } else {
            return null;
         }
      } else if (("Single".equalsIgnoreCase(quoteCharacter) || "Double".equalsIgnoreCase(quoteCharacter)) && (str.contains("'") || str.contains("\""))) {
         Object var4 = str.substring(1, str.length() - 1);
         if (var4.toString().matches("\".*")) {
            var4 = ",";
         } else if (var4.toString().matches(".*\".*")) {
            var4 = var4.toString().trim();
            var4 = var4.toString().substring(0, var4.toString().indexOf("\""));
         }

         return var4;
      } else {
         return str;
      }
   }

   protected void logBegin(TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao) {
      String flag = this.isEncryption ? "1" : "0";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin1 = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList1 = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp1 = tCoreJiaMiJieMiJinList1.size();
      if (cpp1 > 0) {
         for(int npp1 = 0; npp1 < cpp1; ++npp1) {
            tCoreJiaMiJieMiJin1 = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList1.get(npp1);
         }
      }

      if (null != tCoreJiaMiJieMiJin1) {
         tCoreJiaMiJieMiJinDuDao.remove(tCoreJiaMiJieMiJin1);
      }

      flag = this.isEncryption ? "0" : "1";
      List<TCoreJiaMiJieMiJinDu> tCoreJiaList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpppppp = tCoreJiaList.size();
      if (cpppppp == 0) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("0");
         tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

   }

   protected void logBegin() {
      String flag = this.isEncryption ? "1" : "0";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin1 = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList1 = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp1 = tCoreJiaMiJieMiJinList1.size();
      if (cpp1 > 0) {
         for(int npp1 = 0; npp1 < cpp1; ++npp1) {
            tCoreJiaMiJieMiJin1 = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList1.get(npp1);
         }
      }

      if (null != tCoreJiaMiJieMiJin1) {
         this.tCoreJiaMiJieMiJinDuDao.remove(tCoreJiaMiJieMiJin1);
      }

      flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = null;
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null == tCoreJiaMiJieMiJin) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag(flag);
         this.tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

   }

   protected void logTotalCount(TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao, int jiamiTasktotalCounts) {
      String flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null != tCoreJiaMiJieMiJin) {
         tCoreJiaMiJieMiJin.setTotalcounts(jiamiTasktotalCounts);
         tCoreJiaMiJieMiJin.setStarttime(new Date());
         tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJin);
      }

   }

   protected void logBatchCount(TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao, int succedCount, int rejectCount, String columnName, String exception) {
      String flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = null;
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null != tCoreJiaMiJieMiJin) {
         if (exception != null && exception.length() > 0) {
            tCoreJiaMiJieMiJin.setExceptionstring(exception);
         }

         tCoreJiaMiJieMiJin.setFailcounts(rejectCount);
         tCoreJiaMiJieMiJin.setFinishcounts(succedCount);
         if (exception != null) {
            this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, this.FAIL);
            tCoreJiaMiJieMiJin.setState("-1");
         }

         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
      }

   }

   protected void logEnd(TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao, int succedCount, int rejectCount, String exception) {
      String flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null != tCoreJiaMiJieMiJin) {
         if (exception != null && exception.length() > 0) {
            tCoreJiaMiJieMiJin.setExceptionstring(exception);
         }

         tCoreJiaMiJieMiJin.setEndtime(new Date());
         tCoreJiaMiJieMiJin.setFailcounts(rejectCount);
         tCoreJiaMiJieMiJin.setFinishcounts(succedCount);
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
      }

   }

   protected void logEncDecColumnSuccess(String column) {
      this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, column, this.COMPLETE);
   }

   protected void logEncDecColumnFailed(String column) {
      this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, column, this.FAIL);
   }

   protected void logEncDecSuccess() {
      this.encryptionlogger.info("加密完成！");
      this.encryptionlogger.info("加密完成总行数：" + this.totalCount);
      String flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      tCoreJiaMiJieMiJin.setFinishcounts(this.totalCount);
      tCoreJiaMiJieMiJin.setState("1");
      tCoreJiaMiJieMiJin.setEndtime(new Date());
      this.tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);

      for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
         this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), this.COMPLETE);
      }

   }

   protected void logEncDecFailed(String columnName) {
      this.encryptionlogger.info("加密失败！");
      String flag = this.isEncryption ? "0" : "1";
      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, flag);
      int cpp = tCoreJiaMiJieMiJinList.size();
      if (cpp > 0) {
         for(int npp = 0; npp < cpp; ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      tCoreJiaMiJieMiJin.setFinishcounts(this.totalCount);
      tCoreJiaMiJieMiJin.setState("1");
      tCoreJiaMiJieMiJin.setEndtime(new Date());
      this.tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);

      for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
         if (columnName == null || columnName.length() <= 0 || columnInfoVO.getColumnName().equals(columnName)) {
            this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), this.FAIL);
         }
      }

   }

   private String doEncryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType)) {
         value = EncProvider.encryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }

   private String doDecryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType) && value != null) {
         value = EncProvider.decryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }
}
