package com.chenyang.nse.bussiness.tools.jdbc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileTools {
   public static void clearFileContent(String path) {
      try {
         File f = new File(path);
         if (f.exists() && f.isFile()) {
            FileWriter fw = new FileWriter(f);
            fw.write("");
            fw.close();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   public static String getStringEncoding(String str) {
      String encode = "UTF-8";

      try {
         if (str.equals(new String(str.getBytes(encode), encode))) {
            return encode;
         }
      } catch (Exception exception2) {
         exception2.printStackTrace();
      }

      encode = "GB2312";

      try {
         if (str.equals(new String(str.getBytes(encode), encode))) {
            return encode;
         }
      } catch (Exception exception) {
         exception.printStackTrace();
      }

      encode = "GBK";

      try {
         if (str.equals(new String(str.getBytes(encode), encode))) {
            return encode;
         }
      } catch (Exception exception3) {
         exception3.printStackTrace();
      }

      encode = "ISO-8859-1";

      try {
         if (str.equals(new String(str.getBytes(encode), encode))) {
            return encode;
         }
      } catch (Exception exception1) {
         exception1.printStackTrace();
      }

      return null;
   }

   public static boolean createFile(String path) {
      try {
         File file = new File(path);
         if (file.exists()) {
            return true;
         } else {
            if (!file.getParentFile().exists()) {
               file.getParentFile().mkdirs();
            }

            return file.createNewFile();
         }
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      }
   }

   public static boolean createDirAndFile(String path) {
      try {
         File file = new File(path);
         if (file.exists()) {
            return true;
         } else {
            if (!file.getParentFile().exists()) {
               file.getParentFile().mkdirs();
            }

            return file.createNewFile();
         }
      } catch (IOException e) {
         e.printStackTrace();
         return true;
      }
   }
}
