package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlum;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumCol;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumDeli;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumEscape;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumFormat;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumLoad;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumMode;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumQuote;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumSo;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumSource;
import com.chenyang.nse.bussiness.entity.db.GreenPlum.GreenPlumTable;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ho.yaml.Yaml;

public class GreenplumLoadTableTool {
   public static void executeLoadTable(Map<String, String> map) {
      FileTool.clearFileContent(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".sh");
      FileTool.createFile(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".sh");
      String command = "mysql -u" + (String)map.get("username") + " -p" + (String)map.get("password") + " -h" + (String)map.get("hostname") + " --local_infile=1 -e \"LOAD DATA LOCAL INFILE '" + (String)map.get("filepath") + "' INTO TABLE " + (String)map.get("database") + "." + (String)map.get("tablename") + " FIELDS TERMINATED BY '" + (String)map.get("delimiter") + "' LINES TERMINATED BY  '\\n'\";";
      FileTool.writeContentToFile(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".sh", command);
      CommandTool.command("chmod 777 " + File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".sh");
   }

   public static void executeLoadTable_new(Map<String, String> map) {
      String command = "VERSION: 1.0.0.1";
      GreenPlumSo gps = new GreenPlumSo();
      List<String> lhlist = new ArrayList();
      List<String> filelist = new ArrayList();
      lhlist.add("192.168.2.106");
      gps.setLOCAL_HOSTNAME(lhlist);
      gps.setPORT(8081);
      filelist.add("/data/123.txt");
      gps.setFILE(filelist);
      GreenPlumSource source = new GreenPlumSource();
      source.setSource(gps);
      List<GreenPlumCol> columns = new ArrayList();
      GreenPlumCol gpc = new GreenPlumCol();
      gpc.setName("text");
      gpc.setName1("text");
      columns.add(gpc);
      GreenPlumTable table = new GreenPlumTable();
      GreenPlumMode mode = new GreenPlumMode();
      table.setTable("public.test1");
      mode.setMode("INSERT");
      GreenPlumFormat format = new GreenPlumFormat();
      format.setFormat("text");
      GreenPlumDeli delimiter = new GreenPlumDeli();
      delimiter.setDelimiter(",");
      GreenPlumQuote quote = new GreenPlumQuote();
      quote.setQuote("");
      GreenPlumEscape escape = new GreenPlumEscape();
      escape.setEscape("OFF");
      GreenPlum gp = new GreenPlum();
      gp.setVERSION("1.0.0.1");
      gp.setDATABASE("postgres");
      gp.setUSER("gpadmin");
      gp.setHOST("192.168.2.221");
      gp.setPORT(5432);
      GreenPlumLoad gpload = new GreenPlumLoad();
      gpload.setINPUT(new Object[]{source, format, delimiter, quote, escape});
      gpload.setOUTPUT(new Object[]{table, mode});
      gp.setGPLOAD(gpload);
      Yaml yaml = new Yaml();
      File dumpFile = new File("D:/work/ghca 2.0/testYaml.yaml");

      try {
         Yaml.dump(gp, dumpFile);
      } catch (FileNotFoundException e) {
         e.printStackTrace();
      }

   }

   public static void readYamlFile(Map<String, String> greenplumloadparam) {
      List<String> menu = new ArrayList();
      menu.add("!VERSION");
      menu.add("!DATABASE");
      menu.add("!USER");
      menu.add("!HOST");
      menu.add("!TARGETPORT");
      menu.add("!LOCAL_HOSTNAME");
      menu.add("!SOURCEPORT");
      menu.add("!FILE");
      menu.add("!DELIMITER");
      menu.add("!TABLE");
      menu.add("!QUOTE");
      String path = (new FileTool()).getClassRoot() + File.separator + "fastsql_tl" + File.separator + "greemplumload.yml";
      System.out.println("greenplum脚本：执行" + path);

      try {
         BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(path))));
         StringBuffer strBuffer = new StringBuffer();
         String empty = "";
         String tihuan = "";

         String temp;
         for(temp = null; (temp = bufReader.readLine()) != null; temp = null) {
            for(int i = 0; i < menu.size(); ++i) {
               if (temp.indexOf((String)menu.get(i)) != -1) {
                  temp = temp.replace((CharSequence)menu.get(i), (CharSequence)greenplumloadparam.get(menu.get(i)));
               }
            }

            strBuffer.append(temp);
            strBuffer.append(System.getProperty("line.separator"));
         }

         bufReader.close();
         PrintWriter printWriter = new PrintWriter((String)greenplumloadparam.get("path") + (String)greenplumloadparam.get("tablename") + ".yml");
         printWriter.write(strBuffer.toString().toCharArray());
         printWriter.flush();
         printWriter.close();
         executeExportFileTable(greenplumloadparam);
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   public static void executeExportFileTable(Map<String, String> map) {
      FileTool.clearFileContent((String)map.get("path") + (String)map.get("tablename") + ".sh");
      FileTool.createFile((String)map.get("path") + (String)map.get("tablename") + ".sh");
      String command = "gpload -f " + (String)map.get("path") + (String)map.get("tablename") + ".yml";
      FileTool.writeContentToFile((String)map.get("path") + (String)map.get("tablename") + ".sh", command);
      CommandTool.command("chmod 777 " + (String)map.get("path") + (String)map.get("tablename") + ".sh");
   }

   public static void main(String[] args) throws IOException {
   }
}
