package com.chenyang.nse.bussiness.tools.msg;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PropertiesClassLoader {
   private Logger logger = LoggerFactory.getLogger(PropertiesClassLoader.class);
   private Map<String, Object> msgProperties = new HashMap(16);

   private void init(String name) {
      try {
         Properties properties = new Properties();
         InputStream in = PropertiesClassLoader.class.getClassLoader().getResourceAsStream(name + ".properties");
         properties.load(in);
         this.logger.info("加载{}.properties参数", name);

         for(String keyName : properties.stringPropertyNames()) {
            String value = new String(properties.getProperty(keyName).getBytes("ISO8859-1"), "UTF-8");
            if ("msg_cn".equals(name)) {
               this.msgProperties.put(keyName, value);
            }

            this.logger.info("{}.properties---------key:{},value:{}", new Object[]{name, keyName, value});
         }

         this.logger.info("{}.properties参数加载完毕", name);
      } catch (IOException var7) {
      }

   }

   @Bean(
      name = {"msg_cn"}
   )
   public Map<String, Object> commonMap() {
      this.init("msg_cn");
      return this.msgProperties;
   }

   @Bean(
      name = {"config"}
   )
   public Map<String, Object> commonConfigMap() {
      this.init("config");
      return this.msgProperties;
   }
}
