package com.chenyang.nse.bussiness.webtools.tools.jdbc;

import com.chenyang.nse.bussiness.webtools.entity.vo.ResultVO;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class KafkaTool {
   public static ResultVO conntest(String host, int port) {
      boolean result = false;
      ResultVO resultvo = new ResultVO();
      Socket sClient = null;

      try {
         SocketAddress saAdd = new InetSocketAddress(host.trim(), port);
         sClient = new Socket();
         sClient.connect(saAdd, 3000);
         result = true;
         System.out.println("KAFKA系统IP及端口号连接正常！");
      } catch (Exception e) {
         e.printStackTrace();
         resultvo.setMessage(JdbcTool.getExceptionSrintStackTrace(e));
      } finally {
         resultvo.setResult(result);

         try {
            if (sClient != null) {
               sClient.close();
            }
         } catch (Exception e) {
            e.printStackTrace();
            resultvo.setMessage(JdbcTool.getExceptionSrintStackTrace(e));
            resultvo.setResult(false);
         }

         return resultvo;
      }
   }

   public static void main(String[] args) {
      com.chenyang.nse.bussiness.tools.jdbc.KafkaTool.conntest("192.168.2.211", 9092);
   }
}
