/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableArchivePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDeleteByCondition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableMergePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTablePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTablePartitionSetProperties;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRecoverPartitions;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReplaceColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLocation;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetOption;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSubpartitionAvailablePartitionNum;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableUnarchivePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.hive.ast.HiveGrantPrinciple;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveAlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class HiveAlterStatementParser
extends SQLStatementParser {
    HiveAlterStatementParser(String sql) {
        super(new HiveExprParser(sql));
        this.dbType = DbType.hive;
    }

    public HiveAlterStatementParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.hive;
    }

    public HiveAlterStatementParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
        this.dbType = DbType.hive;
    }

    @Override
    public SQLStatement parseAlter() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        if (this.lexer.token() != Token.TABLE) {
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.nextToken();
                SQLName viewName = this.exprParser.name();
                if (this.lexer.identifierEquals("RENAME")) {
                    this.lexer.nextToken();
                    this.accept(Token.TO);
                    SQLAlterViewRenameStatement stmt = new SQLAlterViewRenameStatement();
                    stmt.setName(viewName);
                    SQLName newName = this.exprParser.name();
                    stmt.setTo(newName);
                    return stmt;
                }
                throw new ParserException("TODO " + this.lexer.info());
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.reset(mark);
                return this.parseAlterIndex();
            }
            if (this.lexer.token() == Token.DATABASE) {
                this.lexer.reset(mark);
                return this.parseAlterDatabase();
            }
            if (this.lexer.token() == Token.SCHEMA) {
                this.lexer.reset(mark);
                return this.parseAlterSchema();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
                this.lexer.reset(mark);
                return this.parseAlterResourceGroup();
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        this.lexer.nextToken();
        SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        block0: while (true) {
            SQLConstraint constraint;
            SQLAlterTableAddConstraint item;
            SQLObjectImpl item2;
            if (this.lexer.token() == Token.DROP) {
                this.parseAlterDrop(stmt);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
                if (this.lexer.token() != Token.DISABLE) {
                    if (this.lexer.token() != Token.ENABLE) {
                        if (this.lexer.token() != Token.ALTER) {
                            if (this.lexer.token() != Token.DELETE) {
                                if (!this.lexer.identifierEquals(FnvHash.Constants.CHANGE)) {
                                    if (!this.lexer.identifierEquals(FnvHash.Constants.EXCHANGE)) {
                                        if (this.lexer.token() != Token.WITH) {
                                            if (!this.lexer.identifierEquals("RENAME")) {
                                                if (this.lexer.token() != Token.SET) {
                                                    if (this.lexer.token() != Token.PARTITION) {
                                                        if (!this.lexer.identifierEquals("TOUCH")) {
                                                            if (!this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                                                                if (!this.lexer.identifierEquals(FnvHash.Constants.UNARCHIVE)) {
                                                                    if (!this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION_AVAILABLE_PARTITION_NUM)) {
                                                                        if (DbType.odps != this.dbType || !this.lexer.identifierEquals("MERGE")) {
                                                                            if (DbType.odps != this.dbType || !this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                                                                                if (DbType.odps != this.dbType || !this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
                                                                                    if (stmt.getClusteredBy().size() <= 0 && stmt.getSortedBy().size() <= 0 || this.lexer.token() != Token.INTO) {
                                                                                        if (this.lexer.token() != Token.REPLACE) {
                                                                                            if (DbType.hive != this.dbType || !this.lexer.identifierEquals(FnvHash.Constants.RECOVER)) {
                                                                                                return stmt;
                                                                                            }
                                                                                            this.lexer.nextToken();
                                                                                            this.acceptIdentifier("PARTITIONS");
                                                                                            stmt.addItem(new SQLAlterTableRecoverPartitions());
                                                                                            continue;
                                                                                        }
                                                                                        SQLAlterTableReplaceColumn item3 = this.parseAlterTableReplaceColumn();
                                                                                        stmt.addItem(item3);
                                                                                        continue;
                                                                                    }
                                                                                    this.lexer.nextToken();
                                                                                    if (this.lexer.token() != Token.LITERAL_INT) {
                                                                                        throw new ParserException("into buckets must be integer. " + this.lexer.info());
                                                                                    }
                                                                                    int num = this.lexer.integerValue().intValue();
                                                                                    this.lexer.nextToken();
                                                                                    if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                                                                                        stmt.setBuckets(num);
                                                                                        this.lexer.nextToken();
                                                                                        continue;
                                                                                    }
                                                                                    this.acceptIdentifier("SHARDS");
                                                                                    stmt.setShards(num);
                                                                                    continue;
                                                                                }
                                                                                this.lexer.nextToken();
                                                                                this.accept(Token.BY);
                                                                                this.accept(Token.LPAREN);
                                                                                while (true) {
                                                                                    SQLSelectOrderByItem item4 = this.exprParser.parseSelectOrderByItem();
                                                                                    stmt.addSortedByItem(item4);
                                                                                    if (this.lexer.token() != Token.COMMA) {
                                                                                        this.accept(Token.RPAREN);
                                                                                        continue block0;
                                                                                    }
                                                                                    this.lexer.nextToken();
                                                                                }
                                                                            }
                                                                            this.lexer.nextToken();
                                                                            this.accept(Token.BY);
                                                                            this.accept(Token.LPAREN);
                                                                            while (true) {
                                                                                SQLSelectOrderByItem item5 = this.exprParser.parseSelectOrderByItem();
                                                                                stmt.addClusteredByItem(item5);
                                                                                if (this.lexer.token() != Token.COMMA) {
                                                                                    this.accept(Token.RPAREN);
                                                                                    continue block0;
                                                                                }
                                                                                this.lexer.nextToken();
                                                                            }
                                                                        }
                                                                        this.lexer.nextToken();
                                                                        boolean ifExists = false;
                                                                        if (this.lexer.token() == Token.IF) {
                                                                            this.lexer.nextToken();
                                                                            this.accept(Token.EXISTS);
                                                                            ifExists = true;
                                                                        }
                                                                        if (this.lexer.token() != Token.PARTITION) {
                                                                            this.acceptIdentifier("SMALLFILES");
                                                                            stmt.setMergeSmallFiles(true);
                                                                            continue;
                                                                        }
                                                                        item2 = new SQLAlterTableMergePartition();
                                                                        while (true) {
                                                                            ((SQLAlterTableMergePartition)item2).addPartition(this.getExprParser().parsePartitionSpec());
                                                                            if (this.lexer.token() != Token.COMMA) {
                                                                                this.accept(Token.OVERWRITE);
                                                                                ((SQLAlterTableMergePartition)item2).setOverwritePartition(this.getExprParser().parsePartitionSpec());
                                                                                if (ifExists) {
                                                                                    ((SQLAlterTableMergePartition)item2).setIfExists(true);
                                                                                }
                                                                                stmt.addItem((SQLAlterTableItem)((Object)item2));
                                                                                continue block0;
                                                                            }
                                                                            this.lexer.nextToken();
                                                                        }
                                                                    }
                                                                    this.lexer.nextToken();
                                                                    this.accept(Token.EQ);
                                                                    SQLIntegerExpr num = this.exprParser.integerExpr();
                                                                    item2 = new SQLAlterTableSubpartitionAvailablePartitionNum();
                                                                    ((SQLAlterTableSubpartitionAvailablePartitionNum)item2).setNumber(num);
                                                                    stmt.addItem((SQLAlterTableItem)((Object)item2));
                                                                    continue;
                                                                }
                                                                this.lexer.nextToken();
                                                                this.accept(Token.PARTITION);
                                                                SQLAlterTableUnarchivePartition item6 = new SQLAlterTableUnarchivePartition();
                                                                this.accept(Token.LPAREN);
                                                                this.parseAssignItems(item6.getPartitions(), item6, false);
                                                                this.accept(Token.RPAREN);
                                                                stmt.addItem(item6);
                                                                continue;
                                                            }
                                                            this.lexer.nextToken();
                                                            this.accept(Token.PARTITION);
                                                            SQLAlterTableArchivePartition item7 = new SQLAlterTableArchivePartition();
                                                            this.accept(Token.LPAREN);
                                                            this.parseAssignItems(item7.getPartitions(), item7, false);
                                                            this.accept(Token.RPAREN);
                                                            stmt.addItem(item7);
                                                            continue;
                                                        }
                                                        this.lexer.nextToken();
                                                        SQLAlterTableTouch item8 = new SQLAlterTableTouch();
                                                        if (this.lexer.token() == Token.PARTITION) {
                                                            this.lexer.nextToken();
                                                            this.accept(Token.LPAREN);
                                                            this.parseAssignItems(item8.getPartition(), item8);
                                                            this.accept(Token.RPAREN);
                                                        }
                                                        stmt.addItem(item8);
                                                        continue;
                                                    }
                                                    this.lexer.nextToken();
                                                    SQLAlterTableRenamePartition renamePartition = new SQLAlterTableRenamePartition();
                                                    this.accept(Token.LPAREN);
                                                    this.parseAssignItems(renamePartition.getPartition(), renamePartition);
                                                    this.accept(Token.RPAREN);
                                                    if (this.lexer.token() == Token.ENABLE) {
                                                        this.lexer.nextToken();
                                                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                                                            this.lexer.nextToken();
                                                        }
                                                        SQLAlterTableEnableLifecycle enableLifeCycle = new SQLAlterTableEnableLifecycle();
                                                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                                                            enableLifeCycle.getPartition().add(condition);
                                                            condition.setParent(enableLifeCycle);
                                                        }
                                                        stmt.addItem(enableLifeCycle);
                                                        continue;
                                                    }
                                                    if (this.lexer.token() == Token.DISABLE) {
                                                        this.lexer.nextToken();
                                                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                                                            this.lexer.nextToken();
                                                        }
                                                        SQLAlterTableDisableLifecycle disableLifeCycle = new SQLAlterTableDisableLifecycle();
                                                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                                                            disableLifeCycle.getPartition().add(condition);
                                                            condition.setParent(disableLifeCycle);
                                                        }
                                                        stmt.addItem(disableLifeCycle);
                                                        continue;
                                                    }
                                                    if (DbType.odps == this.dbType) {
                                                        SQLObjectImpl alterTablePartition;
                                                        if (this.lexer.identifierEquals("MERGE")) {
                                                            alterTablePartition = new SQLAlterTablePartition();
                                                            for (SQLAssignItem condition : renamePartition.getPartition()) {
                                                                ((SQLAlterTablePartition)alterTablePartition).getPartition().add(condition);
                                                                condition.setParent(alterTablePartition);
                                                            }
                                                            stmt.addItem((SQLAlterTableItem)((Object)alterTablePartition));
                                                            continue;
                                                        }
                                                        if (this.lexer.token() == Token.SET) {
                                                            alterTablePartition = new SQLAlterTablePartitionSetProperties();
                                                            for (SQLAssignItem condition : renamePartition.getPartition()) {
                                                                ((SQLAlterTablePartitionSetProperties)alterTablePartition).getPartition().add(condition);
                                                                condition.setParent(alterTablePartition);
                                                            }
                                                            this.lexer.nextToken();
                                                            this.acceptIdentifier("PARTITIONPROPERTIES");
                                                            this.accept(Token.LPAREN);
                                                            this.parseAssignItems(((SQLAlterTablePartitionSetProperties)alterTablePartition).getPartitionProperties(), alterTablePartition);
                                                            this.accept(Token.RPAREN);
                                                            stmt.addItem((SQLAlterTableItem)((Object)alterTablePartition));
                                                            continue;
                                                        }
                                                    }
                                                    this.acceptIdentifier("RENAME");
                                                    this.accept(Token.TO);
                                                    this.accept(Token.PARTITION);
                                                    this.accept(Token.LPAREN);
                                                    this.parseAssignItems(renamePartition.getTo(), renamePartition);
                                                    this.accept(Token.RPAREN);
                                                    stmt.addItem(renamePartition);
                                                    continue;
                                                }
                                                this.lexer.nextToken();
                                                if (this.lexer.token() == Token.COMMENT) {
                                                    this.lexer.nextToken();
                                                    SQLAlterTableSetComment setComment = new SQLAlterTableSetComment();
                                                    setComment.setComment(this.exprParser.primary());
                                                    stmt.addItem(setComment);
                                                    continue;
                                                }
                                                if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                                                    this.lexer.nextToken();
                                                    SQLAlterTableSetLifecycle setLifecycle = new SQLAlterTableSetLifecycle();
                                                    setLifecycle.setLifecycle(this.exprParser.primary());
                                                    stmt.addItem(setLifecycle);
                                                    continue;
                                                }
                                                if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                                                    this.lexer.nextToken();
                                                    SQLAlterTableSetLocation setLocation = new SQLAlterTableSetLocation();
                                                    setLocation.setLocation(this.exprParser.primary());
                                                    stmt.addItem(setLocation);
                                                    continue;
                                                }
                                                if (!this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                                                    throw new ParserException("TODO " + this.lexer.info());
                                                }
                                                this.lexer.nextToken();
                                                SQLAlterTableSetOption setOption = new SQLAlterTableSetOption();
                                                this.accept(Token.LPAREN);
                                                while (true) {
                                                    item2 = this.exprParser.parseAssignItem();
                                                    setOption.addOption((SQLAssignItem)item2);
                                                    if (this.lexer.token() != Token.COMMA) {
                                                        this.accept(Token.RPAREN);
                                                        stmt.addItem(setOption);
                                                        continue block0;
                                                    }
                                                    this.lexer.nextToken();
                                                }
                                            }
                                            stmt.addItem(this.parseAlterTableRename());
                                            continue;
                                        }
                                        this.lexer.nextToken();
                                        this.acceptIdentifier("NOCHECK");
                                        this.acceptIdentifier("ADD");
                                        SQLConstraint check = this.exprParser.parseConstaint();
                                        SQLAlterTableAddConstraint addCheck = new SQLAlterTableAddConstraint();
                                        addCheck.setWithNoCheck(true);
                                        addCheck.setConstraint(check);
                                        stmt.addItem(addCheck);
                                        continue;
                                    }
                                    this.lexer.nextToken();
                                    this.accept(Token.PARTITION);
                                    SQLAlterTableExchangePartition item9 = new SQLAlterTableExchangePartition();
                                    this.accept(Token.LPAREN);
                                    while (true) {
                                        SQLExpr partition = this.exprParser.name();
                                        if (this.lexer.token() == Token.EQ) {
                                            this.lexer.nextToken();
                                            SQLExpr value = this.exprParser.primary();
                                            partition = new SQLAssignItem(partition, value);
                                        }
                                        item9.addPartition(partition);
                                        if (this.lexer.token() != Token.COMMA) {
                                            this.accept(Token.RPAREN);
                                            this.accept(Token.WITH);
                                            this.accept(Token.TABLE);
                                            SQLName table = this.exprParser.name();
                                            item9.setTable(table);
                                            if (this.lexer.token() == Token.WITH) {
                                                this.lexer.nextToken();
                                                this.acceptIdentifier("VALIDATION");
                                                item9.setValidation(true);
                                            } else if (this.lexer.identifierEquals(FnvHash.Constants.WITHOUT)) {
                                                this.lexer.nextToken();
                                                this.acceptIdentifier("VALIDATION");
                                                item9.setValidation(false);
                                            }
                                            stmt.addItem(item9);
                                            continue block0;
                                        }
                                        this.lexer.nextToken();
                                    }
                                }
                                this.lexer.nextToken();
                                if (this.lexer.token() == Token.COLUMN) {
                                    this.lexer.nextToken();
                                }
                                SQLName columnName = this.exprParser.name();
                                if (this.lexer.identifierEquals("RENAME")) {
                                    this.lexer.nextToken();
                                    this.accept(Token.TO);
                                    SQLName toName = this.exprParser.name();
                                    SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
                                    renameColumn.setColumn(columnName);
                                    renameColumn.setTo(toName);
                                    stmt.addItem(renameColumn);
                                    continue;
                                }
                                if (this.lexer.token() == Token.COMMENT) {
                                    SQLExpr comment;
                                    this.lexer.nextToken();
                                    if (this.lexer.token() == Token.LITERAL_ALIAS) {
                                        String alias = this.lexer.stringVal();
                                        if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                            alias = alias.substring(1, alias.length() - 1);
                                        }
                                        comment = new SQLCharExpr(alias);
                                        this.lexer.nextToken();
                                    } else {
                                        comment = this.exprParser.primary();
                                    }
                                    SQLColumnDefinition column = new SQLColumnDefinition();
                                    column.setDbType(this.dbType);
                                    column.setName(columnName);
                                    column.setComment(comment);
                                    SQLAlterTableAlterColumn changeColumn = new SQLAlterTableAlterColumn();
                                    changeColumn.setColumn(column);
                                    stmt.addItem(changeColumn);
                                    continue;
                                }
                                SQLColumnDefinition column = this.exprParser.parseColumn();
                                SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
                                alterColumn.setColumn(column);
                                alterColumn.setOriginColumn(columnName);
                                if (this.lexer.identifierEquals(FnvHash.Constants.AFTER)) {
                                    this.lexer.nextToken();
                                    SQLName after = this.exprParser.name();
                                    alterColumn.setAfter(after);
                                }
                                stmt.addItem(alterColumn);
                                continue;
                            }
                            this.lexer.nextToken();
                            if (this.lexer.token() != Token.WHERE) {
                                throw new ParserException("TODO " + this.lexer.info());
                            }
                            this.lexer.nextToken();
                            SQLAlterTableDeleteByCondition alterColumn = new SQLAlterTableDeleteByCondition();
                            alterColumn.setWhere(this.exprParser.expr());
                            stmt.addItem(alterColumn);
                            continue;
                        }
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.COLUMN) {
                            SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                            stmt.addItem(alterColumn);
                            if (this.dbType != DbType.postgresql || this.lexer.token() != Token.COMMA) continue;
                            this.lexer.nextToken();
                            continue;
                        }
                        if (this.lexer.token() != Token.LITERAL_ALIAS) {
                            throw new ParserException("TODO " + this.lexer.info());
                        }
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableConstraint item10 = new SQLAlterTableEnableConstraint();
                        item10.setConstraintName(this.exprParser.name());
                        stmt.addItem(item10);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableLifecycle item11 = new SQLAlterTableEnableLifecycle();
                        stmt.addItem(item11);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableEnableKeys item12 = new SQLAlterTableEnableKeys();
                    stmt.addItem(item12);
                    continue;
                }
                this.lexer.nextToken();
                if (this.lexer.token() == Token.CONSTRAINT) {
                    this.lexer.nextToken();
                    SQLAlterTableDisableConstraint item13 = new SQLAlterTableDisableConstraint();
                    item13.setConstraintName(this.exprParser.name());
                    stmt.addItem(item13);
                    continue;
                }
                if (this.lexer.identifierEquals("LIFECYCLE")) {
                    this.lexer.nextToken();
                    SQLAlterTableDisableLifecycle item14 = new SQLAlterTableDisableLifecycle();
                    stmt.addItem(item14);
                    continue;
                }
                this.acceptIdentifier("KEYS");
                SQLAlterTableDisableKeys item15 = new SQLAlterTableDisableKeys();
                stmt.addItem(item15);
                continue;
            }
            this.lexer.nextToken();
            boolean ifNotExists = false;
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.NOT);
                this.accept(Token.EXISTS);
                ifNotExists = true;
            }
            if (this.lexer.token() == Token.PRIMARY) {
                SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                item = new SQLAlterTableAddConstraint(primaryKey);
                stmt.addItem(item);
                continue;
            }
            if (this.lexer.token() == Token.UNIQUE) {
                SQLUnique unique = this.exprParser.parseUnique();
                item = new SQLAlterTableAddConstraint(unique);
                stmt.addItem(item);
                continue;
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                item2 = this.parseAlterTableAddColumn();
                stmt.addItem((SQLAlterTableItem)((Object)item2));
                continue;
            }
            if (this.lexer.token() == Token.LPAREN) {
                if (this.dbType != DbType.h2) continue;
                this.lexer.nextToken();
                item2 = this.parseAlterTableAddColumn();
                stmt.addItem((SQLAlterTableItem)((Object)item2));
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.COLUMN) {
                this.lexer.nextToken();
                item2 = this.parseAlterTableAddColumn();
                stmt.addItem((SQLAlterTableItem)((Object)item2));
                continue;
            }
            if (this.lexer.token() == Token.CHECK) {
                SQLCheck check = this.exprParser.parseCheck();
                item = new SQLAlterTableAddConstraint(check);
                stmt.addItem(item);
                continue;
            }
            if (this.lexer.token() == Token.CONSTRAINT) {
                constraint = this.exprParser.parseConstaint();
                item = new SQLAlterTableAddConstraint(constraint);
                stmt.addItem(item);
                continue;
            }
            if (this.lexer.token() == Token.FOREIGN) {
                constraint = this.exprParser.parseForeignKey();
                item = new SQLAlterTableAddConstraint(constraint);
                stmt.addItem(item);
                continue;
            }
            if (this.lexer.token() == Token.PARTITION) {
                while (true) {
                    this.lexer.nextToken();
                    SQLAlterTableAddPartition addPartition = new SQLAlterTableAddPartition();
                    addPartition.setIfNotExists(ifNotExists);
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(addPartition.getPartitions(), addPartition, false);
                    this.accept(Token.RPAREN);
                    if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                        this.lexer.nextToken();
                        SQLExpr location = this.exprParser.primary();
                        addPartition.setLocation(location);
                    }
                    stmt.addItem(addPartition);
                    if (this.lexer.token() == Token.PARTITION) continue;
                    if (this.lexer.token() != Token.COMMA) continue block0;
                    this.lexer.nextToken();
                    if (!this.lexer.identifierEquals("ADD") && this.lexer.token() != Token.PARTITION) break;
                }
                continue;
            }
            if (this.lexer.token() != Token.DEFAULT) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            constraint = this.exprParser.parseConstaint();
            item = new SQLAlterTableAddConstraint(constraint);
            stmt.addItem(item);
        }
    }

    @Override
    protected SQLStatement parseAlterDatabase() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        HiveAlterDatabaseStatement stmt = new HiveAlterDatabaseStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPROPERTIES)) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getProperties(), stmt);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
                SQLExpr user;
                this.lexer.nextToken();
                this.exprParser.getDbType();
                stmt.user = user = this.parseUserPrinciple();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                this.lexer.nextToken();
                stmt.location = this.exprParser.name();
            } else {
                if (!this.lexer.identifierEquals(FnvHash.Constants.MANAGEDLOCATION)) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                this.lexer.nextToken();
                stmt.managedlocation = this.exprParser.name();
            }
        }
        return stmt;
    }

    protected SQLExpr parseUserPrinciple() {
        HiveGrantPrinciple owner = new HiveGrantPrinciple();
        if (this.lexer.token() != Token.USER && !this.lexer.identifierEquals("USER")) {
            if (this.lexer.identifierEquals("ROLE")) {
                owner.setRole(true);
                this.lexer.nextToken();
            } else {
                owner.setRole(true);
            }
        } else {
            owner.setUser(true);
            this.lexer.nextToken();
        }
        SQLExpr expr = this.exprParser.expr();
        owner.setExpr(expr);
        return owner;
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        return this.parseAlterDatabase();
    }
}

