/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.kingbase.ast.expression;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.dialect.kingbase.KingbaseExpr;
import com.alibaba.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class KingbaseCharExpr
extends SQLCharExpr
implements KingbaseExpr {
    private String charset;
    private String collate;
    private String type;

    public KingbaseCharExpr() {
    }

    public KingbaseCharExpr(String text) {
        super(text);
    }

    public KingbaseCharExpr(String text, String charset) {
        super(text);
        this.charset = charset;
    }

    public KingbaseCharExpr(String text, String charset, String collate) {
        super(text);
        this.charset = charset;
        this.collate = collate;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void output(Appendable buf) {
        try {
            if (this.charset != null) {
                buf.append(this.charset);
                buf.append(' ');
            }
            if (this.type != null) {
                buf.append(this.type);
            }
            if (this.text != null) {
                super.output(buf);
            }
            if (this.collate != null) {
                buf.append(" COLLATE ");
                buf.append(this.collate);
            }
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof KingbaseASTVisitor) {
            this.accept0((KingbaseASTVisitor)visitor);
        } else {
            visitor.visit(this);
            visitor.endVisit(this);
        }
    }

    @Override
    public void accept0(KingbaseASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.output(buf);
        return buf.toString();
    }

    @Override
    public KingbaseCharExpr clone() {
        KingbaseCharExpr x = new KingbaseCharExpr(this.text);
        x.collate = this.collate;
        x.charset = this.charset;
        x.type = this.type;
        return x;
    }
}

