/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.parser.DB2SQLStatementParser;
import com.alibaba.druid.sql.dialect.dm.parser.DmStatementParser;
import com.alibaba.druid.sql.dialect.gauss.parser.GaussSQLStatementParser;
import com.alibaba.druid.sql.dialect.greenplum.parser.GPLexer;
import com.alibaba.druid.sql.dialect.greenplum.parser.GPSQLStatementParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.druid.sql.dialect.kingbase.parser.KingbaseStatementParser;
import com.alibaba.druid.sql.dialect.mariadb.ast.statement.MariadbSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mariadb.parser.MariadbExprParser;
import com.alibaba.druid.sql.dialect.mariadb.parser.MariadbLexer;
import com.alibaba.druid.sql.dialect.mariadb.parser.MariadbStatementParser;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.SQLType;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import com.alibaba.druid.util.StringUtils;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType) {
        SQLParserFeature[] features = DbType.odps != dbType && DbType.mysql != dbType && DbType.mariadb != dbType ? new SQLParserFeature[]{} : new SQLParserFeature[]{SQLParserFeature.KeepComments};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, boolean keepComments) {
        SQLParserFeature[] features = keepComments ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, SQLParserFeature ... features) {
        return SQLParserUtils.createSQLStatementParser(sql, dbType == null ? null : DbType.valueOf(dbType), features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: 
            case oceanbase_oracle: {
                return new OracleStatementParser(sql, features);
            }
            case mysql: 
            case drds: {
                return new MySqlStatementParser(sql, features);
            }
            case mariadb: {
                return new MariadbStatementParser(sql, features);
            }
            case elastic_search: {
                MySqlStatementParser parser = new MySqlStatementParser(sql, features);
                parser.dbType = dbType;
                parser.exprParser.dbType = dbType;
                return parser;
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerStatementParser(sql);
            }
            case greenplum: {
                return new GPSQLStatementParser(sql, features);
            }
            case dm: {
                return new DmStatementParser(sql);
            }
            case db2: {
                return new DB2SQLStatementParser(sql, features);
            }
            case kingbase: {
                return new KingbaseStatementParser(sql, SQLParserFeature.KeepNameQuotes);
            }
            case postgresql: {
                return new PGSQLStatementParser(sql, features);
            }
            case gauss: {
                return new GaussSQLStatementParser(sql, features);
            }
            case hive: {
                return new HiveStatementParser(sql, features);
            }
        }
        return new SQLStatementParser(sql, dbType);
    }

    public static SQLExprParser createExprParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleExprParser(sql, features);
            }
            default: {
                return new SQLExprParser(sql, dbType, features);
            }
            case mysql: {
                return new MySqlExprParser(sql, features);
            }
            case mariadb: {
                return new MariadbExprParser(sql, features);
            }
            case elastic_search: {
                MySqlExprParser parser = new MySqlExprParser(sql, features);
                parser.dbType = dbType;
                return parser;
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerExprParser(sql, features);
            }
            case phoenix: {
                return new PhoenixExprParser(sql, features);
            }
            case presto: 
        }
        return new PrestoExprParser(sql, features);
    }

    public static Lexer createLexer(String sql, DbType dbType) {
        return SQLParserUtils.createLexer(sql, dbType);
    }

    public static Lexer createLexer(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleLexer(sql);
            }
            default: {
                return new Lexer(sql, null, dbType);
            }
            case mysql: {
                return new MySqlLexer(sql);
            }
            case mariadb: {
                return new MariadbLexer(sql);
            }
            case elastic_search: {
                MySqlLexer lexer = new MySqlLexer(sql);
                lexer.dbType = dbType;
                return lexer;
            }
            case greenplum: {
                return new GPLexer(sql, new SQLParserFeature[0]);
            }
            case postgresql: 
        }
        return new PGLexer(sql, new SQLParserFeature[0]);
    }

    public static SQLSelectQueryBlock createSelectQueryBlock(DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleSelectQueryBlock();
            }
            default: {
                return new SQLSelectQueryBlock(dbType);
            }
            case mysql: {
                return new MySqlSelectQueryBlock();
            }
            case mariadb: {
                return new MariadbSelectQueryBlock();
            }
            case sqlserver: 
        }
        return new SQLServerSelectQueryBlock();
    }

    public static SQLType getSQLType(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLType();
    }

    public static SQLType getSQLTypeV2(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLTypeV2();
    }

    public static boolean startsWithHint(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        return lexer.token() == Token.HINT;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2, Token token3) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2 && tok != token3);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token ... tokens) {
        if (tokens == null) {
            return false;
        }
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        block3: while (true) {
            lexer.nextToken();
            Token tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
            int i = 0;
            while (true) {
                if (i >= tokens.length) continue block3;
                if (tokens[i] == tok) {
                    return true;
                }
                ++i;
            }
            break;
        }
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType) {
        return SQLParserUtils.getSimpleSelectValue(sql, dbType, null);
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType, SimpleValueEvalHandler handler) {
        Object value;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        if (lexer.token != Token.SELECT && lexer.token != Token.VALUES) {
            return null;
        }
        lexer.nextTokenValue();
        SQLExpr expr = null;
        switch (lexer.token) {
            case LITERAL_INT: {
                value = lexer.integerValue();
                break;
            }
            case LITERAL_CHARS: 
            case LITERAL_NCHARS: {
                value = lexer.stringVal();
                break;
            }
            case LITERAL_FLOAT: {
                value = lexer.decimalValue();
                break;
            }
            default: {
                if (handler == null) {
                    return null;
                }
                expr = new SQLExprParser(lexer).expr();
                try {
                    value = handler.eval(expr);
                    break;
                }
                catch (Exception var7) {
                    value = null;
                }
            }
        }
        lexer.nextToken();
        if (lexer.token == Token.FROM) {
            lexer.nextToken();
            if (lexer.token != Token.DUAL) {
                return null;
            }
            lexer.nextToken();
        }
        return lexer.token != Token.EOF ? null : value;
    }

    public static String replaceBackQuote(String sql, DbType dbType) {
        int i = sql.indexOf(96);
        if (i == -1) {
            return sql;
        }
        char[] chars = sql.toCharArray();
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        int len = chars.length;
        int off = 0;
        block4: while (true) {
            lexer.nextToken();
            switch (lexer.token) {
                case EOF: 
                case ERROR: {
                    return new String(chars, 0, len);
                }
                case IDENTIFIER: {
                    int p0 = lexer.startPos + off;
                    int p1 = lexer.pos - 1 + off;
                    char c0 = chars[p0];
                    char c1 = chars[p1];
                    if (c0 != '`' || c1 != '`') continue block4;
                    if (p1 - p0 > 2 && chars[p0 + 1] == '\'' && chars[p1 - 1] == '\'') {
                        System.arraycopy(chars, p0 + 1, chars, p0, p1 - p0 - 1);
                        System.arraycopy(chars, p1 + 1, chars, p1 - 1, chars.length - p1 - 1);
                        len -= 2;
                        off -= 2;
                        break;
                    }
                    chars[p0] = 34;
                    chars[p1] = 34;
                }
            }
        }
    }

    public static String addBackQuote(String sql, DbType dbType) {
        if (StringUtils.isEmpty(sql)) {
            return sql;
        }
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        StringBuffer buf = new StringBuffer(sql.length() + 20);
        SQLASTOutputVisitor out = SQLUtils.createOutputVisitor(buf, DbType.mysql);
        out.config(VisitorFeature.OutputNameQuote, true);
        SQLType sqlType = SQLParserUtils.getSQLType(sql, dbType);
        if (sqlType == SQLType.INSERT) {
            parser.config(SQLParserFeature.InsertReader, true);
            SQLInsertStatement stmt = (SQLInsertStatement)parser.parseStatement();
            int startPos = parser.getLexer().startPos;
            stmt.accept(out);
            if (stmt.getQuery() == null) {
                buf.append(' ');
                buf.append(sql, startPos, sql.length());
            }
        } else {
            SQLStatement stmt = parser.parseStatement();
            stmt.accept(out);
        }
        return buf.toString();
    }

    public static interface SimpleValueEvalHandler {
        public Object eval(SQLExpr var1);
    }
}

