/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.spy;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JNDIDriver
implements Driver {
    public static Driver INSTANCE = new JNDIDriver();
    private static final String URL_PATTERN_REGEX = "^java:comp/env/.*$";
    private static final String URL_NOT_MATCH_PATTERN_REGEX = "^java:comp/env/masking:.*$";
    private static final Pattern URL_PATTERN = Pattern.compile("^java:comp/env/.*$", 2);
    private static final Pattern URL_NOT_MATCH_PATTERN = Pattern.compile("^java:comp/env/masking:.*$", 2);
    private static final String URL_MERN_REGEX_JBOSS = "^java:jboss/.*$";
    private static final String URL_NOT_MATCH_PATTERN_REGEX_JBOSS = "^java:jboss/masking/.*$";
    private static final Pattern URL_PATTERN_JBOSS = Pattern.compile("^java:jboss/.*$", 2);
    private static final Pattern URL_NOT_MATCH_PATTERN_JBOSS = Pattern.compile("^java:jboss/masking/.*$", 2);
    private static InitialContext CONTEXT = null;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            url = url.indexOf("java:jboss/") != -1 ? url.replace("java:jboss/", "java:jboss/masking/") : url.replace("java:comp/env/", "java:comp/env/masking:");
            DataSource ds = (DataSource)CONTEXT.lookup(url);
            Connection conn = ds.getConnection();
            return conn;
        }
        catch (NamingException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url != null && url.length() != 0) {
            if (url.indexOf("java:jboss/") != -1) {
                return URL_PATTERN_JBOSS.matcher(url).matches() && !URL_NOT_MATCH_PATTERN_JBOSS.matcher(url).matches();
            }
            return URL_PATTERN.matcher(url).matches() && !URL_NOT_MATCH_PATTERN.matcher(url).matches();
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return INSTANCE.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            CONTEXT = new InitialContext();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

