/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.spy;

import com.palacesun.engine.spy.MaskingDriver;
import com.palacesun.engine.spy.MaskingPool;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class MaskingDriverPoolDataSource
implements DataSource,
Serializable,
Referenceable,
ConnectionPoolDataSource {
    protected String url;
    protected String user;
    protected String password;

    public MaskingDriverPoolDataSource() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MaskingDriverPoolDataSource(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        String var1 = null;
        String var2 = null;
        MaskingDriverPoolDataSource maskingDriverPoolDataSource = this;
        synchronized (maskingDriverPoolDataSource) {
            var1 = this.user;
            var2 = this.password;
        }
        return this.getConnection(var1, var2);
    }

    @Override
    public Connection getConnection(String var1, String var2) throws SQLException {
        MaskingDriver maskingDriver = new MaskingDriver();
        Properties properties = new Properties();
        properties.setProperty("user", var1);
        properties.setProperty("password", var2);
        return maskingDriver.connect(this.url, properties);
    }

    public Connection getConnection(String var1, String var2, String var3) throws SQLException {
        MaskingDriver maskingDriver = new MaskingDriver();
        Properties properties = new Properties();
        properties.setProperty("user", var2);
        properties.setProperty("password", var3);
        return maskingDriver.connect(var1, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String var1 = null;
        String var2 = null;
        MaskingDriverPoolDataSource maskingDriverPoolDataSource = this;
        synchronized (maskingDriverPoolDataSource) {
            var1 = this.user;
            var2 = this.password;
        }
        return this.getPooledConnection(var1, var2);
    }

    @Override
    public PooledConnection getPooledConnection(String var1, String var2) throws SQLException {
        Connection var3 = this.getConnection(var1, var2);
        MaskingPool var4 = new MaskingPool(var3);
        if (var2 == null) {
            var2 = this.password;
        }
        return var4;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int i) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    @Override
    public Reference getReference() throws NamingException {
        return null;
    }
}

