/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.spy;

import com.palacesun.engine.spy.MaskingDriverPoolDataSource;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class MaskingPool
implements PooledConnection,
Serializable {
    static final long serialVersionUID = -203725628718322873L;
    private Hashtable eventListeners = null;
    private SQLException sqlException = null;
    protected boolean autoCommit = true;
    private ConnectionEventListener iccEventListener = null;
    public Properties cachedConnectionAttributes = null;
    public Properties unMatchedCachedConnAttr = null;
    public int closeOption = 0;
    private long lastAccessedTime = 0L;
    protected String dataSourceInstanceNameKey = null;
    protected String dataSourceHostNameKey = null;
    protected String dataSourceDbUniqNameKey = null;
    protected boolean connectionMarkedDown = false;
    protected boolean needToAbort = false;
    boolean localTxnCommitOnClose = false;
    private Connection connection;

    public MaskingPool() {
        this(null);
    }

    public MaskingPool(String var1, String var2) throws SQLException {
        RuleLoadUtil.writeLog("@@\u63d2\u4ef6@@---MaskingPool---var1:" + var1 + "--var2:" + var2);
        Connection connection = new MaskingDriverPoolDataSource().getConnection(var1, var2);
        if (connection != null) {
            this.initialize(connection);
        }
    }

    public MaskingPool(String var1, String var2, String var3) throws SQLException {
        Properties var4 = new Properties();
        var4.put("user", var2);
        var4.put("password", var3);
        Connection connection = new MaskingDriverPoolDataSource().getConnection(var1, var2, var3);
        if (connection != null) {
            this.initialize(connection);
        }
    }

    public MaskingPool(Connection var1) {
        this.initialize(var1);
    }

    public MaskingPool(Connection var1, boolean var2) {
        this(var1);
        this.autoCommit = var2;
    }

    private void initialize(Connection var1) {
        this.connection = var1;
        this.eventListeners = new Hashtable(10);
        this.lastAccessedTime = 0L;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener var1) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.put(var1, var1);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.connection = null;
        this.lastAccessedTime = 0L;
        this.iccEventListener = null;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.connection;
    }

    public Connection getLogicalHandle() throws SQLException {
        return this.connection;
    }

    public Connection getPhysicalHandle() throws SQLException {
        return this.connection;
    }

    public synchronized void setLastAccessedTime(long var1) throws SQLException {
        this.lastAccessedTime = var1;
    }

    public long getLastAccessedTime() throws SQLException {
        return this.lastAccessedTime;
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener var1) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.remove(var1);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }

    public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener var1) {
        if (this.iccEventListener != null) {
            this.sqlException = new SQLException("Implicit cache listeneralready registered");
        } else {
            this.iccEventListener = var1;
        }
    }

    public void logicalCloseForImplicitConnectionCache() {
        if (this.closeOption == 4096) {
            this.callImplicitCacheListener(102);
        } else {
            this.callImplicitCacheListener(101);
        }
    }

    public void logicalClose() {
        if (this.cachedConnectionAttributes != null) {
            this.logicalCloseForImplicitConnectionCache();
        } else {
            this.callListener(101);
        }
    }

    private void callListener(int var1) {
        if (this.eventListeners != null) {
            Enumeration var2 = this.eventListeners.keys();
            ConnectionEvent var3 = new ConnectionEvent(this, this.sqlException);
            while (var2.hasMoreElements()) {
                ConnectionEventListener var4 = (ConnectionEventListener)var2.nextElement();
                ConnectionEventListener var5 = (ConnectionEventListener)this.eventListeners.get(var4);
                if (var1 == 101) {
                    var5.connectionClosed(var3);
                    continue;
                }
                if (var1 != 102) continue;
                var5.connectionErrorOccurred(var3);
            }
        }
    }

    private void callImplicitCacheListener(int var1) {
        if (this.iccEventListener != null) {
            ConnectionEvent var2 = new ConnectionEvent(this, this.sqlException);
            switch (var1) {
                case 101: {
                    this.iccEventListener.connectionClosed(var2);
                    break;
                }
                case 102: {
                    this.iccEventListener.connectionErrorOccurred(var2);
                }
            }
        }
    }
}

