/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.wrapper;

import bean.Column;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLType;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSON;
import com.palacesun.engine.common.PreparedStatementInformation;
import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.GatewayContext;
import com.palacesun.engine.test.DbCache;
import com.palacesun.engine.test.TestJdbcEventListener;
import com.palacesun.engine.wrapper.ConnectionWrapper;
import com.palacesun.engine.wrapper.ResultSetWrapper;
import com.palacesun.engine.wrapper.StatementWrapper;
import com.palacesun.masking.log.access.AccessContext;
import com.palacesun.masking.tools.EngineUtil;
import com.palacesun.masking.tools.InsertSqlVaulesUtil;
import com.palacesun.masking.tools.JdbcUtil;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import com.palacesun.masking.tools.thkms.util.gmhelper.SM3Utils;
import com.palacesun.masking.vo.Columninfo;
import com.palacesun.masking.vo.JsonRootBean;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import util.SqlUtil;
import util.sqlparse.visitor.common.scope.ReplaceInfo;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private final PreparedStatement delegate;
    private final PreparedStatementInformation statementInformation;
    protected static Logger logger = Logger.getLogger(PreparedStatementWrapper.class.getName());
    public static Map<String, Columninfo> sqlIndexKeyMap = new HashMap<String, Columninfo>();
    private static final String ENCRYPT_LIKE_OPEN = EncryptionGatewayManager.getParameterValue("encryption.like.open");
    private static final String ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");

    public static PreparedStatement wrap(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        if (delegate == null) {
            return null;
        }
        return new PreparedStatementWrapper(delegate, preparedStatementInformation, eventListener);
    }

    protected PreparedStatementWrapper(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        super(delegate, preparedStatementInformation, eventListener);
        this.delegate = delegate;
        this.statementInformation = preparedStatementInformation;
        if (this.statementInformation.context == null) {
            this.statementInformation.context = new AccessContext(this.statementInformation);
        }
        this.sqlBuffer = this.statementInformation.context.getBuffer();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statementInformation);
            ResultSet resultSet = ResultSetWrapper.wrap(this.delegate.executeQuery(), new ResultSetInformation(this.statementInformation), this.eventListener);
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation);
            int n = rowCount = this.delegate.executeUpdate();
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, rowCount, e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValueSqlType(0, parameterIndex, sqlType);
            this.delegate.setNull(parameterIndex, sqlType);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(1, parameterIndex, x);
            this.delegate.setBoolean(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(2, parameterIndex, x);
            this.delegate.setByte(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(7, parameterIndex, x);
            this.delegate.setShort(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(4, parameterIndex, x);
            this.delegate.setInt(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(3, parameterIndex, x);
            this.delegate.setLong(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(5, parameterIndex, Float.valueOf(x));
            this.delegate.setFloat(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Float.valueOf(x), e);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(6, parameterIndex, x);
            this.delegate.setDouble(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(8, parameterIndex, x);
            this.delegate.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    private int getParameterIndex(int parameterIndex) {
        int whereLocation = 100000000;
        boolean where = false;
        Map<String, Integer> digestMap = this.statementInformation.getDigestMap();
        if (!digestMap.isEmpty()) {
            for (String key : digestMap.keySet()) {
                Integer value = digestMap.get(key);
                if (value >= whereLocation) continue;
                whereLocation = value;
            }
            if (parameterIndex >= whereLocation) {
                where = true;
            }
        }
        if (where) {
            parameterIndex += digestMap.size();
        }
        return parameterIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int parameterIndex, String x1) throws SQLException {
        SQLException e = null;
        String x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, this.statementInformation);
            RuleLoadUtil.writeLog("@@" + sql);
            RuleLoadUtil.writeLog("@@" + needSqlParse);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(9, parameterIndex, x1, (Object)x1);
                this.delegate.setString(parameterIndex, x1);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                map = this.encData(this.statementInformation, parameterIndex, x1);
                x = map.get("x");
                tableAndColumnName = map.get("tableAndColumnName");
                mathKey = map.get("mathKey");
            } else if (columninfo.getSecretkey() != null) {
                x = (String)EngineUtil.exeEngine(columninfo, null, false, x1, true);
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(9, parameterIndex, x, (Object)x1);
            this.delegate.setString(parameterIndex, x);
            if (EngineUtil.digestMap.isEmpty()) {
                return;
            }
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value >= whereLocation) continue;
                    whereLocation = value;
                }
                if (parameterIndex >= whereLocation) {
                    where = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sqlBuffer.setValue(9, parameterIndex, x, (Object)x1);
            this.delegate.setString(parameterIndex, x);
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = this.abstractData(mathKey, x);
                this.sqlBuffer.setValue(9, (int)((Integer)digestMap.get(tableAndColumnName)), digestValue, null);
                this.delegate.setString((Integer)digestMap.get(tableAndColumnName), digestValue);
            }
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(10, parameterIndex, x);
            this.delegate.setBytes(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(11, parameterIndex, x);
            this.delegate.setDate(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(12, parameterIndex, x);
            this.delegate.setTime(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = this.getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(13, parameterIndex, x);
            this.delegate.setTimestamp(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, (long)length, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, (long)length, "byte[ascii]");
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, (long)length, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.delegate.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setObject(int parameterIndex, Object x1, int targetSqlType) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = this.encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, false, x1, true);
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1, targetSqlType);
            this.delegate.setObject(parameterIndex, x, targetSqlType);
            if (EngineUtil.digestMap.isEmpty()) {
                this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
                return;
            }
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value >= whereLocation) continue;
                    whereLocation = value;
                }
                if (parameterIndex >= whereLocation) {
                    where = true;
                }
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = this.abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, (int)digestMap.get(tableAndColumnName), digestValue, null);
                this.delegate.setString(digestMap.get(tableAndColumnName), digestValue);
            }
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
            return;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x1) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, this.statementInformation);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(-1, parameterIndex, x1, x1);
                this.delegate.setObject(parameterIndex, x1);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = this.encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, false, x1, true);
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1);
            this.delegate.setObject(parameterIndex, x);
            if (EngineUtil.digestMap.isEmpty()) {
                this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
                return;
            }
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value >= whereLocation) continue;
                    whereLocation = value;
                }
                if (parameterIndex >= whereLocation) {
                    where = true;
                }
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = this.abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, (int)digestMap.get(tableAndColumnName), digestValue, null);
                this.delegate.setString(digestMap.get(tableAndColumnName), digestValue);
            }
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation);
            boolean bl = this.delegate.execute();
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statementInformation);
            this.delegate.addBatch();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, (Object)reader, (Object)length);
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(16, parameterIndex, x);
            this.delegate.setRef(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(18, parameterIndex, x);
            this.delegate.setBlob(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x2) throws SQLException {
        SQLException e = null;
        String x = null;
        String x1 = null;
        try {
            x1 = this.clobToString(x2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        try {
            map = this.encData(this.statementInformation, parameterIndex, x1);
            x = map.get("x");
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value >= whereLocation) continue;
                    whereLocation = value;
                }
                if (parameterIndex >= whereLocation) {
                    where = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sqlBuffer.setValue(9, parameterIndex, x, (Object)x1);
            this.delegate.setString(parameterIndex, x);
            RuleLoadUtil.writeLog("@@" + digestMap);
            RuleLoadUtil.writeLog("@@" + where);
            if (digestMap != null && !digestMap.isEmpty() && !where && map != null && map.get("tableAndColumnName") != null && digestMap.get(map.get("tableAndColumnName")) != null) {
                try {
                    String digestValue = this.abstractData(map.get("mathKey"), x);
                    this.sqlBuffer.setValue(9, (int)digestMap.get(map.get("tableAndColumnName")), digestValue, null);
                    this.delegate.setString(digestMap.get(map.get("tableAndColumnName")), digestValue);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clobToString(Clob clob) throws Exception {
        StringWriter writer = new StringWriter();
        try (Reader reader = null;){
            int bytesRead;
            reader = clob.getCharacterStream();
            char[] buffer = new char[1024];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
        }
        return writer.toString();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(20, parameterIndex, x);
            this.delegate.setArray(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(11, parameterIndex, x, cal);
            this.delegate.setDate(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(12, parameterIndex, x, cal);
            this.delegate.setTime(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(13, parameterIndex, x, cal);
            this.delegate.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(0, parameterIndex, sqlType, typeName);
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(21, parameterIndex, x);
            this.delegate.setURL(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(17, parameterIndex, x);
            this.delegate.setRowId(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(9, parameterIndex, value);
            this.delegate.setNString(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, value, length, "string");
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(22, parameterIndex, value);
            this.delegate.setNClob(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(19, parameterIndex, reader, length, "string");
            this.delegate.setClob(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, inputStream, length, "byte[]");
            this.delegate.setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, length, "string");
            this.delegate.setNClob(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(23, parameterIndex, xmlObject);
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, xmlObject, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setObject(int parameterIndex, Object x1, int targetSqlType, int scaleOrLength) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, this.statementInformation);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(-1, parameterIndex, x1, x1, targetSqlType, scaleOrLength);
                this.delegate.setObject(parameterIndex, x1, targetSqlType, scaleOrLength);
                this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = this.encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, false, x1, true);
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1, targetSqlType, scaleOrLength);
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            if (EngineUtil.digestMap.isEmpty()) {
                this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
                return;
            }
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value >= whereLocation) continue;
                    whereLocation = value;
                }
                if (parameterIndex >= whereLocation) {
                    where = true;
                }
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = this.abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, (int)digestMap.get(tableAndColumnName), digestValue, null);
                this.delegate.setString(digestMap.get(tableAndColumnName), digestValue);
            }
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
            return;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, length, "byte[string]");
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, value, "byte[string]");
            this.delegate.setNCharacterStream(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setClob(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, inputStream, "byte[]");
            this.delegate.setBlob(parameterIndex, inputStream);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setNClob(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    public Map<String, String> encData(PreparedStatementInformation statementInformation, int parameterIndex, String x) throws Exception {
        Map<String, String> encDataMap = new HashMap<String, String>();
        encDataMap.put("x", x);
        if (!GatewayContext.isPluginEnabled()) {
            return encDataMap;
        }
        String dbType = "";
        String urlDbType = statementInformation.getConnectionInformation().getUrl();
        String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
        dbType = ConnectionWrapper.getDbType(driverName, urlDbType, dbType);
        ArrayList<Object> insertValueList = new ArrayList<Object>();
        try {
            int idx;
            String address;
            int end;
            String url;
            Connection connection = statementInformation.getConnectionInformation().getConnection();
            String urlTemp = connection.getMetaData().getURL();
            String ip = TestJdbcEventListener.getIpAndPort(urlTemp).get("ip");
            String port = TestJdbcEventListener.getIpAndPort(urlTemp).get("port");
            String schema = "";
            String tableName = "";
            if ("oracle".equals(dbType)) {
                schema = connection.getMetaData().getUserName();
            } else if ("postgresql".equals(dbType) || "greenplum".equals(dbType) || "gauss".equals(dbType) || "gaussdb".equalsIgnoreCase(dbType)) {
                url = connection.getMetaData().getURL();
                schema = url.indexOf("searchpath") > 0 ? url.substring(url.indexOf("searchpath") + 11) : (url.indexOf("currentSchema") > 0 ? url.substring(url.indexOf("currentSchema") + 14) : (url.toLowerCase().indexOf("schema=") > 0 ? url.substring(url.indexOf("schema=") + 7) : "public"));
            } else if ("sql server".equals(dbType)) {
                url = connection.getMetaData().getURL();
                if (url.indexOf("applicationName") > 0) {
                    schema = url.substring(url.indexOf("applicationName") + "applicationName".length() + 1);
                    if (schema.indexOf(";") != -1) {
                        schema = schema.substring(0, schema.indexOf(";"));
                    }
                } else {
                    schema = "dbo";
                }
            } else if ("dm".equals(dbType)) {
                url = connection.getMetaData().getURL();
                if (url.toLowerCase().contains("schema=")) {
                    schema = url.substring(url.toLowerCase().indexOf("schema=") + 7);
                } else {
                    int from = url.indexOf("://");
                    end = url.indexOf("?");
                    address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                    idx = address.lastIndexOf("/");
                    schema = address.substring(idx + 1);
                }
            } else if ("db2".equals(dbType)) {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1");
                schema = rs.next() ? rs.getString(1).trim() : connection.getMetaData().getUserName();
                rs.close();
                stmt.close();
            } else if ("kingbase".equals(dbType)) {
                url = connection.getMetaData().getURL();
                schema = url.indexOf("searchpath") > 0 ? url.substring(url.indexOf("searchpath") + 11) : (url.indexOf("currentSchema") > 0 ? url.substring(url.indexOf("currentSchema") + 14) : "public");
            } else if ("mysql".equals(dbType)) {
                url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                end = url.indexOf("?");
                address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                idx = address.lastIndexOf("/");
                schema = address.substring(idx + 1);
            } else if ("mariadb".equals(dbType)) {
                url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                end = url.indexOf("?");
                address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                idx = address.lastIndexOf("/");
                schema = address.substring(idx + 1);
            } else if ("hive".equals(dbType)) {
                url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                end = url.indexOf("?");
                address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                schema = address.substring((idx = address.lastIndexOf("/")) + 1);
                if (schema.indexOf(";") > 0) {
                    schema = schema.substring(0, schema.indexOf(";"));
                }
            } else {
                schema = connection.getCatalog();
            }
            String sql1 = statementInformation.getSql();
            String sqlAll = sql1.indexOf("-- appUsername=") > 0 ? sql1.substring(0, sql1.indexOf("-- appUsername=")).trim() : sql1;
            int indexColumnAll = 0;
            int lastIndexColumn = 0;
            String[] split = sqlAll.split(";\r\n");
            for (int i = 0; i < split.length; ++i) {
                Map stringObjectMap;
                String sql = split[i];
                SQLType sqlType = SQLParserUtils.getSQLType(sql, DbType.of(dbType));
                int sqlParamNum = sql.concat("t").split("\\?").length - 1;
                lastIndexColumn = (indexColumnAll += sqlParamNum) - sqlParamNum;
                if (parameterIndex <= lastIndexColumn || parameterIndex > indexColumnAll) continue;
                ArrayList columnList = new ArrayList();
                List<Map<String, Object>> whereList = new ArrayList();
                List<Map<String, Object>> stringObjectMapList = ConnectionWrapper.sqlParseMap.get(sqlAll);
                if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
                    stringObjectMapList = statementInformation.sqlParse;
                }
                if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
                    stringObjectMapList = this.getColumns(statementInformation, sql, dbType, schema);
                }
                if ((columnList = (ArrayList)(stringObjectMap = (Map)stringObjectMapList.get(0)).get("columnList")) == null || columnList.isEmpty()) {
                    RuleLoadUtil.writeLog("@@");
                }
                if ((whereList = (List)stringObjectMap.get("whereList")) == null || whereList.isEmpty()) {
                    RuleLoadUtil.writeLog("@@");
                }
                Object value = null;
                Boolean encFlag = false;
                encDataMap = this.encryption(sql1, insertValueList, sqlType, ip, port, schema, tableName, columnList, value, encFlag, whereList, parameterIndex -= lastIndexColumn, x, statementInformation.getReplaceInfo());
                break;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        return encDataMap;
    }

    public String abstractData(String mathKey, String x) throws Exception {
        String hashStr = "";
        try {
            boolean isDigest = EngineUtil.digestMapBak.containsKey(mathKey);
            if (isDigest) {
                Columninfo map = (Columninfo)EngineUtil.digestMapBak.get(mathKey);
                hashStr = SM3Utils.encrypt(x, map.getSecretkey());
            } else {
                hashStr = x;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        return hashStr;
    }

    private ArrayList<Column> sortColumns(ArrayList<Column> columnList, Collection<TableStat.Column> insertFields) {
        ArrayList<Column> sortColumnList = new ArrayList<Column>();
        if (insertFields instanceof ArrayList) {
            ArrayList insertList = (ArrayList)insertFields;
            block0: for (int i = 0; i < insertList.size(); ++i) {
                for (Column column : columnList) {
                    if (!column.getColumnName().equalsIgnoreCase(((TableStat.Column)insertList.get(i)).getName())) continue;
                    sortColumnList.add(column);
                    continue block0;
                }
            }
            return sortColumnList;
        }
        return columnList;
    }

    private void getUpdateSetFields(PreparedStatementInformation statementInformation, String dbType, String schema, String tableName, ArrayList<Column> updateList) throws SQLException {
        List<Column> columnList = null;
        ArrayList columnL = new ArrayList();
        if ("mysql".equals(dbType) || "mariadb".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfMysql(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("oracle".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfOracle(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("postgresql".equals(dbType) || "greenplum".equals(dbType) || "gauss".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfPostgresql(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("hive".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfHive(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("dm".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfDm(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("db2".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfDb2(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("sql server".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfSqlserver(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("kingbase".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfKingbase(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("gbase".equals(dbType)) {
            // empty if block
        }
        ArrayList<Column> finalUpdateList = updateList;
        for (Column col : columnList) {
            Column tm = new Column(col.getColumnName(), col.getSchema(), col.getTable(), col.getDataType());
            finalUpdateList.add(tm);
        }
    }

    private List<Map<String, Object>> getColumns(PreparedStatementInformation statementInformation, String sql, String dbType, String schema) throws SQLException {
        Map<String, Object> stringObjectMap;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        params.put("dbType", dbType);
        params.put("schema", schema);
        params.put("encryption", "1");
        String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
        params.put("url", url);
        SqlUtil sqlUtil = new SqlUtil();
        List<Map<String, Object>> maps = sqlUtil.parseSqlStructureEnc(params);
        if (maps != null && !maps.isEmpty() && !(stringObjectMap = maps.get(0)).isEmpty()) {
            String trim = sql.toLowerCase().trim();
            if ((trim.startsWith("insert") || trim.startsWith("update")) && trim.contains("?")) {
                ConnectionWrapper.sqlParseMap.put(sql, maps);
            } else if (trim.startsWith("select")) {
                ConnectionWrapper.sqlParseMap.put(sql, maps);
            }
            statementInformation.sqlParse = maps;
        }
        return maps;
    }

    private String getDbType(PreparedStatementInformation statementInformation, String dbType) throws Exception {
        try {
            String hiveurl = statementInformation.getConnectionInformation().getUrl();
            if (hiveurl.toLowerCase().contains("hive")) {
                return "hive";
            }
            String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("mysql")) {
                dbType = "mysql";
            } else if (driverName.toLowerCase().contains("oracle")) {
                dbType = "oracle";
            } else if (driverName.toLowerCase().contains("postgresql")) {
                String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
                if (url.contains("gauss")) {
                    dbType = "gauss";
                    return dbType;
                }
                if (url.contains("greenplum")) {
                    dbType = "greenplum";
                    return dbType;
                }
                dbType = "postgresql";
            } else if (driverName.toLowerCase().contains("hive")) {
                dbType = "hive";
            } else if (driverName.toLowerCase().contains("dm")) {
                dbType = "dm";
            } else if (driverName.toLowerCase().contains("ibm")) {
                dbType = "db2";
            } else if (driverName.toLowerCase().contains("sql server")) {
                dbType = "sql server";
            } else if (driverName.toLowerCase().contains("kingbase")) {
                dbType = "kingbase";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return dbType;
    }

    public Boolean find(String empNumber, Collection<TableStat.Column> list) {
        for (TableStat.Column column : list) {
            if (!column.getName().equalsIgnoreCase(empNumber)) continue;
            return true;
        }
        return false;
    }

    private List<Object> getInsertSqlValueList(String sql, List<Object> valueList) {
        String[] split;
        if (sql.indexOf("-- appUsername=") > 0) {
            sql = sql.substring(0, sql.indexOf("-- appUsername=")).trim();
        }
        String lowerSql = sql.toLowerCase();
        for (String s : split = lowerSql.split(";\r\n")) {
            String tempsql;
            if (s.contains("values")) {
                tempsql = s.substring(s.indexOf("values") + 6);
                tempsql = tempsql.replaceFirst("\\(", "");
                if ((tempsql = tempsql.replaceFirst("[\\\\)]+$", "")).trim().endsWith(";")) {
                    tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
                }
                valueList.addAll(InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes(tempsql.split(",")));
                continue;
            }
            if (!s.contains("value")) continue;
            tempsql = s.substring(s.indexOf("value") + 5);
            tempsql = tempsql.replaceFirst("\\(", "");
            if ((tempsql = tempsql.replaceFirst("[\\\\)]+$", "")).trim().endsWith(";")) {
                tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
            }
            valueList = InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes(tempsql.split(","));
        }
        return valueList;
    }

    private Map<String, String> encryption(String sql, List<Object> insertValueList, SQLType sqlType, String ip, String port, String schema, String tableName, ArrayList<Column> columnList, Object value, Boolean encFlag, List<Map<String, Object>> whereList, int parameterIndex, String x, ReplaceInfo replaceInfo) throws SQLException {
        String replaceColumn;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean ismaksing = false;
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        int m = 1;
        Column column = null;
        if (sqlType == SQLType.INSERT) {
            // empty if block
        }
        if (sqlType == SQLType.UPDATE) {
            for (int k = 0; k < columnList.size(); ++k) {
                String v = columnList.get(k).getValue();
                if (v == null || !String.valueOf(columnList.get(k).getValue()).trim().equals("?")) continue;
                ids.put(m, k);
                ++m;
            }
        }
        if (null != ids && ids.containsKey(parameterIndex)) {
            if (sqlType == SQLType.INSERT) {
                parameterIndex = parameterIndex % ids.size() == 0 ? ids.size() : parameterIndex % ids.size();
            }
            column = columnList.get((Integer)ids.get(parameterIndex) % columnList.size());
        }
        if (null != column) {
            String str1 = column.getColumnName().contains(".") ? column.getColumnName().split("\\.")[1] : column.getColumnName();
            String str2 = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + str1).toLowerCase().replace("`", "").replace("\"", "");
            RuleLoadUtil.writeLog("@@" + str2);
            if (EngineUtil.encryptionMap.isEmpty()) {
                EngineUtil.keyCacheFromFile();
            }
            if (ismaksing = EngineUtil.encryptionMap.containsKey(str2)) {
                Boolean flag = false;
                try {
                    Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(str2);
                    if (sqlType == SQLType.INSERT) {
                        value = x;
                        RuleLoadUtil.writeLog("@@" + x);
                        value = EngineUtil.exeEngine(map, null, flag, value, true);
                        x = (String)value;
                        RuleLoadUtil.writeLog("@@" + x);
                    } else if (sqlType == SQLType.UPDATE) {
                        value = x;
                        value = EngineUtil.exeEngine(map, null, flag, value, true);
                        x = (String)value;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new SQLException(e1);
                }
                finally {
                    hashMap.put("x", x);
                }
            }
            return hashMap;
        }
        int computeParameterIndex = parameterIndex - 1;
        if (sqlType == SQLType.UPDATE) {
            for (int i = 0; i < columnList.size(); ++i) {
                Column column1 = columnList.get(i);
                if (column1.getValue() == null || !column1.getValue().equals("?")) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("column", schema + "." + column1.getColumnName());
                map.put("columnValue", "?");
                map.put("type", "Equality");
                whereList.add(i, map);
            }
            computeParameterIndex = parameterIndex - 1 - ids.size();
        }
        if (whereList == null || whereList.isEmpty()) {
            hashMap.put("tableAndColumnName", "");
            hashMap.put("x", x);
            hashMap.put("mathKey", "");
            return hashMap;
        }
        Iterator<Map<String, Object>> iterator = whereList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> y = iterator.next();
            if (y.get("columnValue") instanceof String && y.get("columnValue").equals("?") || y.get("columnValue") instanceof SQLVariantRefExpr && ((SQLVariantRefExpr)y.get("columnValue")).getName().equals("?")) continue;
            iterator.remove();
        }
        if (whereList == null || whereList.isEmpty()) {
            hashMap.put("tableAndColumnName", "");
            hashMap.put("x", x);
            hashMap.put("mathKey", "");
            return hashMap;
        }
        Map<String, Object> whereMap = computeParameterIndex >= whereList.size() ? whereList.get(whereList.size() - 1) : whereList.get(computeParameterIndex);
        String key = (String)whereMap.get("column");
        String columnName = key.contains(".") ? key.split("\\.")[2].replace("\"", "") : key.replace("\"", "");
        tableName = key.contains(".") ? key.split("\\.")[1] : tableName;
        schema = key.contains(".") ? key.split("\\.")[0] : schema;
        String mathKey = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + columnName).toLowerCase().replace("`", "").replace("\"", "");
        if (EngineUtil.encryptionMap.isEmpty()) {
            EngineUtil.keyCacheFromFile();
        }
        if ("1".equals(EncryptionGatewayManager.getParameterValue("replaceSql")) && replaceInfo != null && mathKey.equals(replaceColumn = ip + "_" + port + "_" + replaceInfo.getPrefix() + "_" + replaceInfo.getColumnName())) {
            hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
            hashMap.put("x", x);
            hashMap.put("mathKey", mathKey);
            return hashMap;
        }
        RuleLoadUtil.writeLog("@@" + mathKey);
        ismaksing = EngineUtil.encryptionMap.containsKey(mathKey);
        if (ismaksing) {
            Boolean flag = false;
            Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(mathKey);
            map.setColumnname((tableName + "@@" + columnName).toLowerCase());
            map.setId(mathKey);
            String type = (String)whereMap.get("type");
            if (!type.toUpperCase().equals("LIKE")) {
                sqlIndexKeyMap.put(sql + "_" + parameterIndex, map);
            }
            if (x != null && !"".equals(x)) {
                try {
                    Object likeValue;
                    value = x;
                    if (type.toUpperCase().equals("LIKE")) {
                        likeValue = ((String)value).trim();
                        boolean beforeLike = false;
                        boolean afterLike = false;
                        if (!((String)likeValue).equals("%%")) {
                            if (((String)likeValue).startsWith("%")) {
                                likeValue = ((String)likeValue).substring(1);
                                beforeLike = true;
                            }
                            if (((String)likeValue).endsWith("%")) {
                                likeValue = ((String)likeValue).substring(0, ((String)likeValue).length() - 1);
                                afterLike = true;
                            }
                            value = likeValue;
                            value = EngineUtil.exeEngine(map, null, flag, value, true);
                            if (afterLike) {
                                value = value.toString().replace(ENCRYPT_SEPARATOR, "");
                            }
                            if (ENCRYPT_LIKE_OPEN.equals(map.getIsLike())) {
                                if (beforeLike) {
                                    value = "%" + value;
                                }
                                if (afterLike) {
                                    value = value + "%";
                                }
                            }
                        }
                    } else {
                        RuleLoadUtil.writeLog("@@" + value);
                        value = EngineUtil.exeEngine(map, null, flag, value, true);
                        RuleLoadUtil.writeLog("@@" + value);
                    }
                    x = (String)value;
                    likeValue = hashMap;
                    return likeValue;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new SQLException(e1);
                }
                finally {
                    Object exception = null;
                    hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
                    hashMap.put("x", x);
                    hashMap.put("mathKey", mathKey);
                }
            }
        } else {
            Columninfo columninfo = new Columninfo();
            columninfo.setColumnname((tableName + "@@" + columnName).toLowerCase());
            columninfo.setId(mathKey);
            sqlIndexKeyMap.put(sql + "_" + parameterIndex, columninfo);
        }
        hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
        hashMap.put("x", x);
        hashMap.put("mathKey", mathKey);
        return hashMap;
    }

    public static void main(String[] args) {
        String key = "\t{\n\t\t\"datasystemid\": \"ff808081920fb5af0192101fe06c0005\",\n\t\t\"dbip\": \"10.130.136.63\",\n\t\t\"dbport\": \"1521\",\n\t\t\"dbservername\": \"orcl\",\n\t\t\"schema\": \"VENUS\",\n\t\t\"tableInfo\": [\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIPTION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feca3a0030\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"EMAIL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feca7c0031\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IMGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecb090033\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecb560034\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IS5G\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecba10035\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ISSHARE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecbe80036\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"LOGIN_AUTH_MODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecc2e0037\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecc7b0038\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feccbb0039\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feccfa003a\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecd33003b\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFV_TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecd76003c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"OPERSTEL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecdc5003d\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PARAMETER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece02003e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PHYLOCA\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece47003f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece840040\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PROTOCOL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecec20041\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESMODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecefc0042\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SUPPORTTYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecf410043\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SYNSTATUS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecf870044\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecfc20045\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"URL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed0000046\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"URL_IPV6\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed0440047\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed07e0048\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_APP_RES\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"USERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295877a2003e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"USERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a9019229590dd60040\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ORGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a9019229596a630043\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"LOGINIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922959be370045\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MAC\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295a23450047\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"OPERATIONOBJ\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295a9ce8004a\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESOURCENAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295b05f2004c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SERVERIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295b8ff1004f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_LOG_RESOURCE_LOGIN\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_ROLE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432be97000b\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DEPARTMENT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bede000c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIBE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bf22000d\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"EXPIRYTIME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bf6e000e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MODIFYBY\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bfae000f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bfea0010\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFVROLEID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0380011\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFVSYNSTATUS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c07e0012\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PWD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0ba0013\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE1\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0f70014\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE2\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1360015\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE3\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1770016\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE4\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1bc0017\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"WORKNUMBER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c2150018\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_ACC_SLAVE\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"CHECKRESULT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0b4e00ba\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"CLASSIFICATIONRES\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0b9d00bb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_CONAS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0be100bc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_LOCALSID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0c2400bd\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0c6b00be\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0caf00bf\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PROFILE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0cf000c0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_SERVERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0d3f00c1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_SID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0d7e00c2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0dbd00c3\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_USER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0dfe00c4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0e3d00c5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIPTION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0e7b00c6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"FORTIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f0000c8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTPASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f4500c9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f8d00ca\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTSHORTNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0fd900cb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTUSER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d101a00cc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IMGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d105a00cd\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d109500ce\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IPV6\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d10e300cf\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IS5G\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d113100d0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ISSHARE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d117f00d1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d11bf00d2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d123900d4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MIDDLESERVICEIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d128500d5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MODEL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d12d200d6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d130d00d7\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NOTSUPSYSLOGDESC\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d135800d8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d13aa00d9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PHYLOCA\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d13e700da\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d142500db\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PRIPWDESCROW\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d147300dc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RANDOM\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d14f600de\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RANGEIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d152f00df\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESMODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d156a00e0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d15a600e1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_ANAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d15ea00e2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_APASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d162d00e3\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_BNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d167200e4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_BPASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d16b800e5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_GROUP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d16fd00e6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_SYSTYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d174200e7\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_SYSVERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d178400e8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_UID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d17cd00e9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d184b00eb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_SYS_RES\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"STATE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192242ea7130003\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"WORKNUMBER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192242ea7830004\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_MASTERAUTH\"\n\t\t\t}\n\t\t]\n\t}\n";
        JsonRootBean jsonRootBean = JSON.parseObject(key.toString(), JsonRootBean.class);
        System.out.println(jsonRootBean.toString());
    }
}

