/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2SchemaStatVisitor;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.kingbase.visitor.KingbaseSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.JdbcConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SqlParseTool {
    public static Collection<TableStat.Column> getColumns(String sql) {
        Collection<TableStat.Column> tablefieldList = SqlParseTool.execute(JdbcConstants.MYSQL.toString(), sql);
        return tablefieldList;
    }

    public static Collection<TableStat.Column> execute(String dbType, String sql) {
        ArrayList<TableStat.Column> ret = new ArrayList<TableStat.Column>();
        SQLUtils.format(sql, dbType);
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        for (int i = 0; i < stmtList.size(); ++i) {
            SQLStatement stmt = stmtList.get(i);
            OracleSchemaStatVisitor visitor = new OracleSchemaStatVisitor();
            stmt.accept(visitor);
            for (TableStat.Column column : visitor.getGroupByColumns()) {
            }
            Map<TableStat.Name, TableStat> tabmap = visitor.getTables();
            for (TableStat.Name name : tabmap.keySet()) {
            }
            ret.addAll(visitor.getColumns());
        }
        return ret;
    }

    public static String getTableName(String dbType, String sql) {
        String ret = "";
        try {
            List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
            for (int i = 0; i < stmtList.size(); ++i) {
                SQLStatement stmt = stmtList.get(i);
                SchemaStatVisitor visitor = null;
                if ("oracle".equals(dbType)) {
                    visitor = new OracleSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("sql server".equals(dbType)) {
                    visitor = new SQLServerSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("greenplum".equals(dbType)) {
                    visitor = new GPSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("dm".equals(dbType)) {
                    visitor = new PGSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("db2".equals(dbType)) {
                    visitor = new DB2SchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("kingbase".equals(dbType)) {
                    visitor = new KingbaseSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("mysql".equals(dbType)) {
                    visitor = new MySqlSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("postrgresql".equals(dbType)) {
                    visitor = new PGSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("gauss".equals(dbType)) {
                    visitor = new GaussSchemaStatVisitor();
                    stmt.accept(visitor);
                } else if ("mariadb".equals(dbType)) {
                    visitor = new MariadbSchemaStatVisitor();
                    stmt.accept(visitor);
                }
                Map<TableStat.Name, TableStat> tabmap = visitor.getTables();
                Iterator<TableStat.Name> iterator = tabmap.keySet().iterator();
                if (!iterator.hasNext()) continue;
                TableStat.Name name = iterator.next();
                return name.toString();
            }
            return ret;
        }
        catch (Exception var10) {
            return "";
        }
    }

    public static void main(String[] args) {
        String sql = "select this_.tid as tid1_38_0_, this_.flag as flag2_38_0_, this_.note as note3_38_0_, this_.chpwdflg as chpwdflg4_38_0_, this_.createtime as createti5_38_0_, this_.editPasswordTime as editPass6_38_0_, this_.ipaddress as ipaddres7_38_0_, this_.isenable as isenable8_38_0_, this_.limitnum as limitnum9_38_0_, this_.password as passwor10_38_0_, this_.truename as truenam11_38_0_, this_.username as usernam12_38_0_ from T_BASE_USER this_ where this_.username='admin'";
        String dbType = JdbcConstants.MYSQL.toString();
        SqlParseTool.execute(dbType, sql);
    }
}

