/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.ruleload;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.palacesun.engine.common.ClientUtil;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.util.GatewaySocketLogUtil;
import com.palacesun.masking.adapter.StringUtils;
import com.palacesun.masking.tools.EngineUtil;
import com.palacesun.masking.tools.ruleload.RuleLoadException;
import com.palacesun.masking.tools.ruleload.RuleProps;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class RuleLoadUtil {
    protected static Logger logger = Logger.getLogger(RuleLoadUtil.class.getName());
    protected static CloseableHttpClient httpClient = null;
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static String encryptionRuleStr;
    public static String digestRuleStr;

    public static boolean isEncryptionRuleFromGateway() {
        return "gateway".equalsIgnoreCase(RuleProps.getInstance().getEncryptionRuleOrigin());
    }

    public static boolean isMaskingRuleFromGateway() {
        return "gateway".equalsIgnoreCase(RuleProps.getInstance().getMaskingRuleOrigin());
    }

    private static void initHttpClient() {
        httpClient = ClientUtil.getWrapClient();
    }

    private static void closeHttpClient() {
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.warning(String.format("[%s][%s]", e.getClass().getName(), e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<JSONArray> loadEncryptionRuleFromGateway() {
        Object var0;
        try {
            encryptionRuleStr = RuleLoadUtil.fetchEncryptionRuleFromteway();
            if (!StringUtils.isEmpty(encryptionRuleStr)) {
                ArrayList<JSONArray> var2;
                if (encryptionRuleStr.contains("OOW_01")) {
                    GatewaySocketLogUtil.writeLog("\u5f53\u524d\u5ba2\u6237\u7aef\u4e0d\u5728\u767d\u540d\u5355\u8303\u56f4\u5185\uff0c\u62c9\u53d6\u52a0\u5bc6\u89c4\u5219\u5931\u8d25\uff01");
                    EngineUtil.encryptionMap.clear();
                    Object var02 = null;
                    ArrayList arrayList = var02;
                    return arrayList;
                }
                JSONArray array = JSONObject.parseArray(encryptionRuleStr);
                ArrayList<JSONArray> list = new ArrayList<JSONArray>();
                list.add(array);
                logger.info("loadencryptionrule.success");
                ArrayList<JSONArray> arrayList = var2 = list;
                return arrayList;
            }
            var0 = null;
        }
        finally {
            RuleLoadUtil.closeHttpClient();
        }
        return var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<JSONArray> loadDigestRuleFromGateway() {
        Object var0;
        try {
            digestRuleStr = RuleLoadUtil.fetchDigestRuleFromteway();
            if (!StringUtils.isEmpty(digestRuleStr)) {
                ArrayList<JSONArray> var2;
                if (digestRuleStr.contains("OOW_01")) {
                    GatewaySocketLogUtil.writeLog("\u5f53\u524d\u5ba2\u6237\u7aef\u4e0d\u5728\u767d\u540d\u5355\u8303\u56f4\u5185\uff0c\u62c9\u53d6\u5b8c\u6574\u6027\u6821\u9a8c\u89c4\u5219\u5931\u8d25\uff01");
                    EngineUtil.digestMap.clear();
                    Object var02 = null;
                    ArrayList arrayList = var02;
                    return arrayList;
                }
                JSONArray array = JSONObject.parseArray(digestRuleStr);
                ArrayList<JSONArray> list = new ArrayList<JSONArray>();
                list.add(array);
                logger.info("loaddigestrule.success");
                ArrayList<JSONArray> arrayList = var2 = list;
                return arrayList;
            }
            var0 = null;
        }
        finally {
            RuleLoadUtil.closeHttpClient();
        }
        return var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchEncryptionRuleFromteway() {
        String body;
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f00\u59cb\uff01");
        String projectid = EncryptionGatewayManager.getParameterValue("projectid");
        String uri = "/core/encryptionrule";
        uri = uri + "?projectId=" + projectid;
        uri = uri + "&remotePort=" + EncryptionGatewayManager.ROOT_PORT;
        try {
            String var4;
            String gatewayHost = EncryptionGatewayManager.getParameterValue("gatewayurl");
            String body2 = ClientUtil.doPost(gatewayHost + uri, "{}");
            GatewaySocketLogUtil.writeLog(uri + "\u63a5\u53e3\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + body2);
            String string = var4 = body2;
            return string;
        }
        catch (RuleLoadException var9) {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            body = null;
        }
        catch (Exception var10) {
            String body3;
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            String string = body3 = null;
            return string;
        }
        finally {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u7ed3\u675f\uff01");
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchDigestRuleFromteway() {
        String body;
        GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f00\u59cb\uff01");
        String projectid = EncryptionGatewayManager.getParameterValue("projectid");
        String uri = "/core/digestrule";
        uri = uri + "?projectId=" + projectid;
        uri = uri + "&remotePort=" + EncryptionGatewayManager.ROOT_PORT;
        try {
            String var4;
            String gatewayHost = EncryptionGatewayManager.getParameterValue("gatewayurl");
            String body2 = ClientUtil.doPost(gatewayHost + uri, "{}");
            logger.info(body2);
            GatewaySocketLogUtil.writeLog(uri + "\u63a5\u53e3\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\uff1a" + body2);
            String string = var4 = body2;
            return string;
        }
        catch (RuleLoadException var9) {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            body = null;
        }
        catch (Exception var10) {
            String body3;
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u5f02\u5e38\uff01");
            String string = body3 = null;
            return string;
        }
        finally {
            GatewaySocketLogUtil.writeLog("\u6267\u884c" + new Exception().getStackTrace()[0].getMethodName() + "\u65b9\u6cd5\u7ed3\u675f\uff01");
        }
        return body;
    }

    private static String copyToString(InputStream is) throws IOException {
        return new String(RuleLoadUtil.copyToByteArray(is), "utf-8");
    }

    private static byte[] copyToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int num = is.read(buffer);
        while (num != -1) {
            baos.write(buffer, 0, num);
            num = is.read(buffer);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<JSONArray> loadMaskingRuleFromGateway() {
        ArrayList<JSONArray> var3;
        try {
            RuleLoadUtil.initHttpClient();
            String encryptionRuleStr = RuleLoadUtil.fetchMaskingRuleFromteway();
            JSONArray array = JSONObject.parseArray(encryptionRuleStr);
            ArrayList<JSONArray> list = new ArrayList<JSONArray>();
            list.add(array);
            logger.info("loadmaskingrule.success");
            var3 = list;
        }
        finally {
            RuleLoadUtil.closeHttpClient();
        }
        return var3;
    }

    private static String fetchMaskingRuleFromteway() {
        String resinfo;
        HttpPost httpPost = new HttpPost("/core/maskrule");
        try {
            String rescode;
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            String projectid = EncryptionGatewayManager.getParameterValue("projectid");
            if (projectid != null && !projectid.equals("")) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("projectid", projectid));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List<? extends NameValuePair>)nvps);
                entity.setContentEncoding("UTF-8");
                httpPost.setEntity(entity);
            }
            String gatewayHost = EncryptionGatewayManager.getParameterValue("gatewayurl");
            String[] split = gatewayHost.split(":");
            String protocol = split[0];
            String ip = split[1].split("//")[1];
            Integer port = Integer.parseInt(split[2]);
            HttpHost httpHost = new HttpHost(ip, (int)port, protocol);
            CloseableHttpResponse res = httpClient.execute(httpHost, httpPost);
            int code = res.getStatusLine().getStatusCode();
            logger.info(String.format("code=[%d]", code));
            Header rescodeHeader = res.getFirstHeader("rescode");
            String string = rescode = rescodeHeader != null ? rescodeHeader.getValue() : "0";
            if (!"0".equals(rescode)) {
                Header resinfoHeader = res.getFirstHeader("resinfo");
                String resinfo2 = resinfoHeader != null ? resinfoHeader.getValue() : "";
                throw new RuleLoadException(String.format("[%s][%s]", rescode, resinfo2));
            }
            String body = RuleLoadUtil.copyToString(res.getEntity().getContent());
            logger.info(body);
            resinfo = body;
        }
        catch (RuleLoadException rle) {
            throw rle;
        }
        catch (Exception e) {
            throw new RuleLoadException(e.getMessage(), e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return resinfo;
    }

    public static void writeLog(String content) {
        if (EncryptionGatewayManager.checkParameterFlag("encryption.log")) {
            OutputStreamWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                fileWriter = new FileWriter(System.getProperty("user.home") + "/encryption-proxy-plugin.log", true);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(RuleLoadUtil.content(content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (null != bufferedWriter) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    if (null != fileWriter) {
                        fileWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String content(String content) {
        StringBuffer result = new StringBuffer("");
        result.append(sdf.format(new Date()) + " --> ");
        result.append(content);
        result.append("\r\n");
        return result.toString();
    }
}

