/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.ruleload;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import java.util.logging.Logger;

class RuleProps {
    protected static Logger logger = Logger.getLogger(RuleProps.class.getName());
    private String projectId;
    private String encryptionRuleOrigin;
    private String maskingRuleOrigin;
    private Long ruleLoadPeriod;
    private String gatewayProtocol;
    private String gatewayHost;
    private Integer gatewayPort;
    private static volatile boolean initFlag = false;
    private static volatile RuleProps instance = null;

    private RuleProps(String projectId, String encryptionRuleOrigin, String maskingRuleOrigin, Long ruleLoadPeriod, String gatewayProtocol, String gatewayHost, Integer gatewayPort) {
        this.projectId = projectId;
        this.encryptionRuleOrigin = encryptionRuleOrigin;
        this.maskingRuleOrigin = maskingRuleOrigin;
        this.ruleLoadPeriod = ruleLoadPeriod;
        this.gatewayProtocol = gatewayProtocol;
        this.gatewayHost = gatewayHost;
        this.gatewayPort = gatewayPort;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getEncryptionRuleOrigin() {
        return this.encryptionRuleOrigin;
    }

    public String getMaskingRuleOrigin() {
        return this.maskingRuleOrigin;
    }

    public Long getRuleLoadPeriod() {
        return this.ruleLoadPeriod;
    }

    public String getGatewayProtocol() {
        return this.gatewayProtocol;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public Integer getGatewayPort() {
        return this.gatewayPort;
    }

    private static synchronized void init() {
        if (!initFlag) {
            String projectId = EncryptionGatewayManager.getParameterValue("projectId");
            String encryptionRuleOrigin = EncryptionGatewayManager.getParameterValue("encryption.rule-origin");
            String maskingRuleOrigin = EncryptionGatewayManager.getParameterValue("masking.rule-origin");
            Long ruleLoadPeriod = Long.valueOf(EncryptionGatewayManager.getParameterValue("rule.load-period"));
            String gwProtocol = EncryptionGatewayManager.getParameterValue("gateway.protocol");
            String gwHost = EncryptionGatewayManager.getParameterValue("gateway.host");
            Integer gwPort = Integer.valueOf(EncryptionGatewayManager.getParameterValue("gateway.port"));
            instance = new RuleProps(projectId, encryptionRuleOrigin, maskingRuleOrigin, ruleLoadPeriod, gwProtocol, gwHost, gwPort);
            initFlag = true;
        }
    }

    public static RuleProps getInstance() {
        if (!initFlag) {
            RuleProps.init();
        }
        return instance;
    }
}

