/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonReader;
import util.StringJoin;

public class BsonTest {
    public static void main(String[] args) throws Exception {
        BsonTest.bsonDecode();
    }

    public static void main2() {
        MongoClient client = new MongoClient("127.0.0.1", 27017);
        MongoDatabase database = client.getDatabase("test");
        MongoCollection collection = database.getCollection("te");
        System.out.println(collection.find().first());
        try {
            BsonDocument command = new BsonDocument("dbStats", (BsonValue)new BsonInt64(1L));
            Document commandResult = database.runCommand((Bson)command);
            System.out.println("dbStats: " + commandResult.toJson());
            String hex = "5c0000000266696e6400030000007465000366696c7465720010000000017800000000000000244000036c736964001e00000005696400100000000472de6e27d4424fedacc3c3fc48bab9e500022464620005000000746573740000";
            byte[] bytes = BsonTest.hexStringToBytes(hex);
            BsonDocument test2 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
            test2.remove((Object)"$db");
            commandResult = database.runCommand((Bson)test2);
            System.out.println("result: " + commandResult.toJson());
            BasicOutputBuffer output = new BasicOutputBuffer();
            new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter((BsonOutput)output), test2, EncoderContext.builder().build());
            List ob = output.getByteBuffers();
            byte[] bytes3 = output.toByteArray();
            System.out.println(BsonTest.byteToHex(bytes3));
            BsonDocument test3 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes3).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
            System.out.println(test3);
        }
        catch (MongoException me) {
            System.err.println("An error occurred: " + (Object)((Object)me));
        }
        catch (Exception me) {
            System.err.println("An error occurred: " + me);
        }
    }

    private static void bsonDecode() {
        String hex = "5c0000000266696e6400030000007465000366696c7465720010000000017800000000000000244000036c736964001e00000005696400100000000472de6e27d4424fedacc3c3fc48bab9e500022464620005000000746573740000";
        byte[] bytes = BsonTest.hexStringToBytes(hex);
        BSONObject decode = BSON.decode((byte[])bytes);
        System.out.println(decode.toString());
        Bson bson = Filters.gt((String)"a", (Object)10);
        BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, MongoClient.getDefaultCodecRegistry());
        System.out.println(bsonDocument.toString());
        byte[] array = new BigInteger("130000001069734d6173746572000100000000", 16).toByteArray();
        BasicBSONDecoder decoder = new BasicBSONDecoder();
        BSONObject bsonObject = decoder.readObject(array);
        System.out.println(bsonObject.toString());
        JSONObject json = new JSONObject(decode.toMap());
        System.out.println(json);
        BsonDocument test2 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
        System.out.println(test2.toString());
        BsonDocument test22 = new BsonDocumentCodec().decode((BsonReader)new JsonReader(test2.toString()), DecoderContext.builder().build());
        System.out.println(test22.toString());
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (StringJoin.isEmpty(hexString)) {
            return null;
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() >> 1];
        int index = 0;
        for (int i = 0; i < hexString.length(); ++i) {
            if (index > hexString.length() - 1) {
                return byteArray;
            }
            byte highDit = (byte)(Character.digit(hexString.charAt(index), 16) & 0xFF);
            byte lowDit = (byte)(Character.digit(hexString.charAt(index + 1), 16) & 0xFF);
            byteArray[i] = (byte)(highDit << 4 | lowDit);
            index += 2;
        }
        return byteArray;
    }

    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }
}

