/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SparkTool {
    private Connection connection;
    private Statement statement;
    private boolean releaseConnection;
    private boolean releaseStatement;

    public SparkTool(DataBase database) {
        try {
            this.connection = DriverManager.getConnection(database.getUrl(), database.getUsername(), database.getPassword());
            this.releaseConnection = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public SparkTool(Connection connection) {
        this.connection = connection;
    }

    public SparkTool(Statement statement) {
        this.statement = statement;
    }

    public SparkTool(Connection connection, Statement statement) {
        this.connection = connection;
        this.statement = statement;
    }

    public List<Schema> getMetaInfo() throws SQLException {
        return this.loadDatabase(null);
    }

    public List<Schema> getPlainDbSchemas() throws SQLException {
        ArrayList schema = this.getSchemas();
        return schema == null ? new ArrayList() : schema;
    }

    public List<Table> getPlainDbTables() throws SQLException {
        ArrayList<Table> allTables = new ArrayList<Table>();
        for (Schema schema : this.getSchemas()) {
            List<Table> tables = this.getTables(schema.getName());
            if (tables == null) continue;
            allTables.addAll(tables);
        }
        return allTables;
    }

    public List<Table> getPlainSchemaTables(String schema, String tableNamePattern) throws SQLException {
        this.statement = this.getStatement();
        ArrayList tables = this.getTables(schema, tableNamePattern);
        return tables == null ? new ArrayList() : tables;
    }

    public List<View> getPlainSchemaViews(String schema) throws SQLException {
        ArrayList views = this.getViews(schema);
        return views == null ? new ArrayList() : views;
    }

    public List<Column> getPlainTableColumns(String schema, String tableName) throws SQLException {
        this.statement = this.getStatement();
        ArrayList columns = this.getColumns(schema, tableName);
        return columns == null ? new ArrayList() : columns;
    }

    private List<Schema> getSchemas() throws SQLException {
        this.statement = this.getStatement();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        String sql = "show schemas";
        ResultSet resultSet = this.statement.executeQuery(sql);
        while (resultSet.next()) {
            Schema schema = new Schema(resultSet.getString("NAMESPACE"));
            schema.setRealName(resultSet.getString("NAMESPACE"));
            schemas.add(schema);
        }
        return schemas;
    }

    private List<Table> getTables(String schema) throws SQLException {
        return this.getTables(schema, null, true);
    }

    private List<Table> getTables(String schema, String pattern) throws SQLException {
        return this.getTables(schema, pattern, true);
    }

    private List<Table> getTables(String schema, String pattern, boolean refresh) throws SQLException {
        this.statement = this.getStatement();
        ArrayList<Table> tables = new ArrayList<Table>();
        if (refresh) {
            this.refreshContext(schema);
        }
        String sql = "show tables";
        if (pattern != null && pattern.length() > 0) {
            sql = sql + " like %" + pattern + "%";
        }
        ResultSet resultSet = this.statement.executeQuery(sql);
        while (resultSet.next()) {
            Table table = new Table(resultSet.getString("TABLENAME"), schema);
            table.setRealName(resultSet.getString("TABLENAME"));
            tables.add(table);
        }
        return tables;
    }

    private List<Column> getColumns(String schema, String table) throws SQLException {
        return this.getColumns(schema, table, true);
    }

    private List<Column> getColumns(String schema, String table, boolean refresh) throws SQLException {
        this.statement = this.getStatement();
        ArrayList<Column> columns = new ArrayList<Column>();
        if (refresh) {
            this.refreshContext(schema);
        }
        String sql = "desc table " + table;
        ResultSet resultSet = this.statement.executeQuery(sql);
        while (resultSet.next()) {
            Column column = new Column(resultSet.getString("COL_NAME"), schema, table, resultSet.getString("DATA_TYPE"));
            column.setColumnType(column.getDataType());
            column.setRemark(resultSet.getString("COMMENT"));
            columns.add(column);
        }
        resultSet.close();
        return columns;
    }

    private List<View> getViews(String schema) throws SQLException {
        return this.getViews(schema, true);
    }

    private List<View> getViews(String schema, boolean refresh) throws SQLException {
        this.statement = this.getStatement();
        ArrayList<View> views = new ArrayList<View>();
        if (refresh) {
            this.refreshContext(schema);
        }
        String sql = "show views";
        ResultSet resultSet = this.statement.executeQuery(sql);
        while (resultSet.next()) {
            String tableName = resultSet.getString("VIEWNAME");
            views.add(new View(tableName, null));
        }
        for (View view : views) {
            ResultSet viewResultSet = this.statement.executeQuery("show create table " + view.getName());
            String viewDDL = null;
            boolean next = viewResultSet.next();
            if (!next) continue;
            try {
                viewDDL = viewResultSet.getString(1);
                view.setCreate_sql(viewDDL);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return views;
    }

    private void refreshContext(String schema) throws SQLException {
        this.statement = this.getStatement();
        this.statement.execute("use " + schema);
    }

    public List<Schema> loadDatabase(DataBase dataBase) throws SQLException {
        List<Schema> schemaList = this.getSchemas();
        for (Schema schema : schemaList) {
            this.statement.execute("use " + schema.getName());
            String schemaName = schema.getRealName();
            if (dataBase != null && dataBase.getExcludeSchema().contains(schemaName)) continue;
            List<Table> tableList = this.getTables(schemaName, null, false);
            schema.setTableList(tableList);
            for (Table table : tableList) {
                List<Column> columnList = this.getColumns(schemaName, table.getRealName(), false);
                table.setColumnList(columnList);
            }
            List<View> viewList = this.getViews(schemaName, false);
            schema.setViewList(viewList);
            schema.setSynonymList(new ArrayList<Synonym>());
        }
        return schemaList;
    }

    public void close() {
        if (this.statement != null && this.releaseStatement) {
            try {
                this.statement.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            this.statement = null;
        }
        if (this.connection != null && this.releaseConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        this.connection = null;
    }

    private Statement getStatement() throws SQLException {
        if (this.statement == null && this.connection == null) {
            throw new SQLException("\u6c92\u6709\u6709\u6548\u7684\u94fe\u63a5\u4f20\u5165\uff0cconnection\u6216\u8005statement\u81f3\u5c11\u6709\u4e2a\u5df2\u4f20\u5165\u3002");
        }
        if (this.statement == null) {
            this.statement = this.connection.createStatement();
            this.releaseStatement = true;
        }
        return this.statement;
    }

    public static void main(String[] args) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:hive2://192.168.245.30:10000", "", "");
        SparkTool tool = new SparkTool(connection);
        System.out.println("-----------schemas--------------");
        for (Schema schema : tool.getPlainDbSchemas()) {
            System.out.println(schema.getName());
        }
        System.out.println("-----------db tables--------------");
        for (Table table : tool.getPlainDbTables()) {
            System.out.println(table.getName());
        }
        System.out.println("-----------schema tables--------------");
        for (Table table : tool.getPlainSchemaTables("ry", null)) {
            System.out.println(table.getName());
        }
        System.out.println("-----------schema views--------------");
        for (View view : tool.getPlainSchemaViews("ry")) {
            System.out.println(view.getName());
        }
        System.out.println("-----------table columns--------------");
        for (Column column : tool.getPlainTableColumns("ry", "person")) {
            System.out.println(column.getColumnName());
        }
    }
}

