/*
 * Decompiled with CFR 0.152.
 */
package util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import util.log.LogHandler;
import util.log.LogInfo;
import util.log.LogMsg;
import util.log.LogTask;

public class LogContext {
    ReadWriteLock lock = new ReentrantReadWriteLock(true);
    Map<String, LogHandler> handlers = new HashMap<String, LogHandler>();
    private final LinkedBlockingQueue<LogMsg> queue = new LinkedBlockingQueue();

    public static LogContext instance() {
        return LogContextHolder.INSTANCE;
    }

    private LogContext() {
        LogTask task = new LogTask(this.queue);
        task.start();
    }

    public void log(LogInfo log) {
        LogHandler handler = this.getHandler();
        handler.write(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogHandler getHandler() {
        LogHandler handler;
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String name = sdf.format(now);
        try {
            this.lock.readLock().lock();
            if (this.handlers.containsKey(name)) {
                LogHandler var4;
                LogHandler logHandler = var4 = this.handlers.get(name);
                return logHandler;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.lock.writeLock().lock();
            if (!this.handlers.containsKey(name)) {
                LogHandler var18;
                LogHandler handler2 = new LogHandler(name, this.queue);
                for (String other : this.handlers.keySet()) {
                    if (name.equals(other)) continue;
                    LogHandler timeOutHandler = this.handlers.get(other);
                    timeOutHandler.close();
                    this.handlers.remove(other);
                }
                this.handlers.put(name, handler2);
                LogHandler logHandler = var18 = handler2;
                return logHandler;
            }
            handler = this.handlers.get(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return handler;
    }

    static class LogContextHolder {
        static final LogContext INSTANCE = new LogContext();

        LogContextHolder() {
        }
    }
}

