/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.druid.sql.dialect.es.ast.EsParserContextBase;
import com.alibaba.druid.sql.dialect.es.visitor.ESOutputVisitor;
import com.alibaba.druid.sql.dialect.es.visitor.Printer;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import util.JdbcUtil;
import util.sqlparse.visitor.es.ApiParser;
import util.sqlparse.visitor.es.dense.Desensitizor;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FieldMemo;
import util.sqlparse.visitor.es.memo.IndexMemo;
import util.sqlparse.visitor.es.memo.MappingMemo;

public class ElasticSearchParse {
    public static final String VERSION = "v7.16";
    private List<Column> columnList = new ArrayList<Column>();
    private Map<String, String> tableMap = new HashMap<String, String>();
    private Map<String, String> schemaMap = new HashMap<String, String>();
    private Map<String, String> whereMap = new HashMap<String, String>();
    private List whereList = new ArrayList();
    public Map<String, String> params;

    public ElasticSearchParse() {
    }

    public ElasticSearchParse(Map<String, String> params) {
        this.params = params;
    }

    public String parseSql() {
        return null;
    }

    public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
        System.out.println("\u4f20\u5165\u7684\u53c2\u6570\uff1a=========================================>" + this.params);
        String request = this.params.get("sql");
        DataBase dataBase = this.getDataBase();
        ApiParser parser = new ApiParser();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        HashMap schemaMap1 = new HashMap();
        try {
            List<FieldMemo> list;
            List<MappingMemo> tables;
            ApiResult result = parser.parse(request, dataBase);
            paramMap.put("sql", result.getStatement().toString());
            paramMap.put("stmtType", (Object)result.stmtType);
            paramMap.put("apiType", (Object)result.apiType);
            paramMap.put("parseTree", (Object)result.getStatement());
            paramMap.put("type", result.apiType.toString().toUpperCase());
            List<IndexMemo> indices = result.getSchemas();
            if (indices != null && indices.size() > 0) {
                for (IndexMemo indexMemo : indices) {
                    this.schemaMap.put(indexMemo.name, indexMemo.name);
                    schemaMap1.put(indexMemo.name, new HashMap());
                }
            }
            if ((tables = result.getTables()) != null && tables.size() > 0) {
                for (MappingMemo mappingMemo : tables) {
                    this.tableMap.put(mappingMemo.name, mappingMemo.name);
                    HashMap schema111 = (HashMap)schemaMap1.get(mappingMemo.index.name);
                    schema111.put(mappingMemo.name, new HashMap());
                }
            }
            if ((list = result.getFields()) != null) {
                for (FieldMemo field : list) {
                    Column column = new Column();
                    column.setColumnName(field.name);
                    column.setDataType(field.dataType);
                    if (field.index != null) {
                        column.setTable(field.mapping.name);
                        column.setSchema(field.index.name);
                    }
                    this.columnList.add(column);
                    if (schemaMap1.get(field.index.name) == null) {
                        schemaMap1.put(field.index.name, new HashMap());
                        continue;
                    }
                    HashMap mappingmap1 = (HashMap)schemaMap1.get(field.index.name);
                    if (mappingmap1.get(field.mapping.name) == null) {
                        mappingmap1.put(field.mapping.name, new HashMap());
                        continue;
                    }
                    HashMap fieldSet = (HashMap)mappingmap1.get(field.mapping.name);
                    fieldSet.put(field.name, field.dataType);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        for (String key : schemaMap1.keySet()) {
            Schema schema = new Schema(key);
            HashMap hashMap = (HashMap)schemaMap1.get(key);
            ArrayList<Table> arrayList = new ArrayList<Table>();
            for (String key1 : hashMap.keySet()) {
                Table table = new Table(key1, key);
                HashMap fieldM = (HashMap)hashMap.get(key1);
                ArrayList<Column> columnList = new ArrayList<Column>();
                for (String f : fieldM.keySet()) {
                    Column column = new Column(f, key, key1, (String)fieldM.get(f));
                    columnList.add(column);
                }
                table.setColumnList(columnList);
                arrayList.add(table);
            }
            schema.setTableList(arrayList);
            schemas.add(schema);
        }
        paramMap.put("schemaList", schemas);
        paramMap.put("schemaMap", this.schemaMap);
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("whereList", this.whereList);
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
    }

    public String parseSql_table() {
        String request = this.params.get("sql");
        ApiParser parser = new ApiParser();
        try {
            DataBase database = this.getDataBase();
            ApiResult result = parser.parse(request, database);
            EsParserContextBase statement = result.getStatement();
            result.database = database;
            HashMap<String, String> map = new HashMap<String, String>(this.params);
            map.put("apiResult", (String)((Object)result));
            this.denseTable(map);
            Object isMatched = map.get("isMatched");
            if (isMatched != null) {
                this.params.put("isMatched", isMatched.toString());
            }
            ESOutputVisitor visitor = new ESOutputVisitor();
            Printer printer = visitor.visit((ParseTree)statement);
            return printer.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String parseSql_column() {
        String request = this.params.get("sql");
        ApiParser parser = new ApiParser();
        try {
            DataBase database = this.getDataBase();
            ApiResult result = parser.parse(request, database);
            EsParserContextBase statement = result.getStatement();
            result.database = database;
            HashMap<String, String> map = new HashMap<String, String>(this.params);
            map.put("apiResult", (String)((Object)result));
            this.denseColumn(map);
            String data = (String)map.get("esResponseBytes");
            return data;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String parseSql_data() {
        String request = this.params.get("sql");
        ApiParser parser = new ApiParser();
        try {
            DataBase database = this.getDataBase();
            ApiResult result = parser.parse(request, database);
            EsParserContextBase statement = result.getStatement();
            result.database = database;
            HashMap<String, String> map = new HashMap<String, String>(this.params);
            map.put("apiResult", (String)((Object)result));
            this.denseData(map);
            String data = (String)map.get("esResponseBytes");
            return data;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String rowVisitControl(Map<String, Object> param) throws SQLException {
        String request = (String)param.get("sql");
        ApiParser parser = new ApiParser();
        try {
            DataBase database = this.getDataBase(param);
            ApiResult result = parser.parse(request, database);
            EsParserContextBase statement = result.getStatement();
            result.database = database;
            HashMap<String, Object> map = new HashMap<String, Object>(param);
            map.put("apiResult", result);
            this.denseRow(map);
            Object isMatched = map.get("isMatched");
            if (isMatched != null) {
                param.put("isMatched", isMatched);
            }
            ESOutputVisitor visitor = new ESOutputVisitor();
            Printer printer = visitor.visit((ParseTree)statement);
            return printer.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void denseTable(Map map) {
        Desensitizor.tableDense(map);
    }

    private void denseColumn(Map map) {
        Desensitizor.columnDense(map);
    }

    private void denseData(Map map) {
        Desensitizor.dataDense(map);
    }

    private void denseRow(Map map) {
        Desensitizor.rowDense(map);
    }

    private DataBase getDataBase() {
        String url = this.params.get("url");
        DataBase dataBase = null;
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!url.equalsIgnoreCase(db.getUrl())) continue;
            dataBase = db;
            break;
        }
        return dataBase;
    }

    private DataBase getDataBase(Map param) {
        String url = (String)param.get("url");
        DataBase dataBase = null;
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!url.equalsIgnoreCase(db.getUrl())) continue;
            dataBase = db;
            break;
        }
        return dataBase;
    }

    public List<String> parseWheres(String request) {
        ApiParser parser = new ApiParser();
        return parser.where(request);
    }
}

