/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.common.memo;

import com.alibaba.druid.sql.ast.SQLObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.StringJoin;
import util.sqlparse.visitor.common.ID;
import util.sqlparse.visitor.common.memo.AliasField;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class FieldMemo
extends ID {
    public String name;
    public String alias;
    private String qualifiedName;
    public List<FieldMemo> children = new ArrayList<FieldMemo>();
    public boolean isSelectItem;
    public TableMemo table;
    public List<TableMemo> tables = new ArrayList<TableMemo>();
    public SQLObject ref;
    public List<SQLObject> exprs = new ArrayList<SQLObject>();
    public List<AliasField> aliasFields = new ArrayList<AliasField>();
    public FieldMemo typeField;
    public Scope scope;
    public boolean complex;
    public boolean atom;
    public boolean isConstant;
    public FieldMemo refField;
    public boolean outside;
    private Set<Integer> fieldIds = new HashSet<Integer>();

    public String getQualifiedName() {
        Iterator<TableMemo> iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            TableMemo next = iterator.next();
            if (next != null) continue;
            iterator.remove();
        }
        if (this.qualifiedName == null) {
            if (this.table != null) {
                this.qualifiedName = this.table.getQualifiedName() + "." + this.alias;
            } else {
                if (this.tables.size() <= 0) {
                    return this.alias;
                }
                ArrayList<String> nameList = new ArrayList<String>();
                for (TableMemo tableMemo : this.tables) {
                    nameList.add(tableMemo.getQualifiedName());
                }
                this.qualifiedName = "[" + StringJoin.join(nameList, ",") + "]." + this.alias;
            }
        }
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getFullName() {
        return this.ref.toString();
    }

    public String getAtomName() {
        return this.table == null ? this.name : this.table.getAtomName() + "." + this.name;
    }

    public List<FieldMemo> getChildren() {
        return this.children;
    }

    public String getUniqueName() {
        return this.scope.id + ":" + this.getQualifiedName();
    }

    public Set<String> tableNames() {
        HashSet<String> atomNameSet = new HashSet<String>();
        for (TableMemo x : this.tables) {
            if (x.isSub || x.refTable != null) continue;
            atomNameSet.add(x.getAtomName());
        }
        return atomNameSet;
    }

    public Set<String> childNames() {
        HashSet<String> atomNameSet = new HashSet<String>();
        for (FieldMemo child : this.children) {
            atomNameSet.add(child.getAtomName());
        }
        return atomNameSet;
    }

    public FieldMemo copy() {
        FieldMemo field = new FieldMemo();
        field.name = this.name;
        field.alias = this.name;
        field.isSelectItem = this.isSelectItem;
        field.qualifiedName = null;
        field.ref = null;
        field.scope = null;
        if (this.attributes != null) {
            field.attributes = new HashMap(this.attributes);
        }
        return field;
    }

    public Set<Integer> getFieldIds() {
        return this.fieldIds;
    }

    public void setFieldIds(Set<Integer> fieldIds) {
        this.fieldIds = fieldIds;
    }
}

