/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.dm.visitor;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmInsertStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmSelectQueryBlock;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmSelectTableReference;
import com.alibaba.druid.sql.dialect.dm.visitor.DefaultDmASTVisitor;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor
extends DefaultDmASTVisitor {
    private boolean debug = false;
    protected Scope scope;

    public ParseVisitor(Scope scope) {
        this.scope = scope;
    }

    public void perform(List<SQLStatement> statements) {
        if (statements != null && statements.size() != 0) {
            for (SQLStatement statement : statements) {
                statement.accept(this);
            }
            this.scope.reset();
        }
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.debug) {
            System.out.println("enter SQLSelectStatement" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        if (this.debug) {
            System.out.println("exit SQLSelectStatement" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(DmInsertStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(DmInsertStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLDeleteStatement x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(DmSelectQueryBlock x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(DmSelectQueryBlock x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("exit SQLWithSubqueryClause" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLLateralViewTableSource x) {
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLLateralViewTableSource x) {
        this.scope.exitScope();
    }

    @Override
    public boolean visit(DmSelectSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter DmSelectSubqueryTableSource" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(DmSelectSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("exit DmSelectSubqueryTableSource" + x.toString());
        }
        for (Scope s : this.scope.getCurrent().getChildren()) {
            s.isolated = false;
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource" + x.toString());
        }
        this.scope.enterScope(x);
        return true;
    }

    @Override
    public void endVisit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("exit SQLSubqueryTableSource" + x.toString());
        }
        for (Scope s : this.scope.getCurrent().getChildren()) {
            s.isolated = false;
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        this.scope.getCurrent().join = true;
        return true;
    }

    @Override
    public void endVisit(SQLJoinTableSource x) {
    }

    @Override
    public void endVisit(SQLUnionQueryTableSource x) {
        if (this.debug) {
            System.out.println("exit SQLUnionQueryTableSource" + x.toString());
        }
        for (Scope s1 : this.scope.getChildren()) {
            s1.isolated = false;
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        return true;
    }

    @Override
    public void endVisit(SQLExprTableSource x) {
    }

    @Override
    public boolean visit(DmSelectTableReference x) {
        return true;
    }

    @Override
    public void endVisit(DmSelectTableReference x) {
    }

    protected void visitChild(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void visitChild(List<? extends SQLObject> x) {
        if (x != null && x.size() != 0) {
            for (SQLObject sQLObject : x) {
                this.visitChild(sQLObject);
            }
        }
    }

    protected boolean isEqual(String name1, String name2) {
        return this.scope.dialector.isEqual(name1, name2);
    }
}

