/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.es;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import com.alibaba.druid.sql.dialect.es.ast.EsParserContextBase;
import com.alibaba.druid.sql.dialect.es.ast.EsStatementType;
import com.alibaba.druid.sql.dialect.es.visitor.EsUtils;
import com.alibaba.druid.stat.TableStat;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.names.NameWrapper;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FieldMemo;
import util.sqlparse.visitor.es.memo.IndexMemo;
import util.sqlparse.visitor.es.memo.MappingMemo;
import util.sqlparse.visitor.es.memo.Reference;
import util.sqlparse.visitor.es.visitor.Scope;
import util.sqlparse.visitor.es.visitor.ScopeVisitor;
import util.sqlparse.visitor.es.visitor.WhereVisitor;

public class ApiParser {
    public ApiResult parse(String uri, String method, String body, DataBase dataBase) throws MalformedURLException {
        StringBuilder header = new StringBuilder();
        header.append(method);
        header.append(" ");
        header.append(uri);
        header.append("\n");
        header.append(body == null ? "" : body);
        return this.parse(header.toString(), dataBase);
    }

    public ApiResult parse(String request, DataBase dataBase) throws MalformedURLException {
        EsParser.StatementContext statement = EsUtils.parse(request);
        ApiResult result = new ApiResult();
        result.setStatement(statement);
        int apiType = (Integer)statement.getAttribute("apiType");
        for (TableStat.Mode value : TableStat.Mode.values()) {
            if (value.mark != apiType) continue;
            result.apiType = value;
            break;
        }
        switch (result.apiType) {
            case Alter: 
            case Other: {
                return result;
            }
        }
        int stmtType = (Integer)statement.getAttribute("stmtType");
        for (EsStatementType value : EsStatementType.values()) {
            if (value.getCode() != stmtType) continue;
            result.stmtType = value;
            break;
        }
        switch (result.stmtType) {
            case unknown: 
            case other: {
                return result;
            }
        }
        Context context = new Context();
        context.initialize(dataBase, "", "es");
        Scope scope = new Scope(null);
        ScopeVisitor visitor = new ScopeVisitor(scope);
        visitor.visit((ParseTree)statement);
        List<EsParserContextBase> indices = visitor.indices;
        List<EsParserContextBase> values = visitor.values;
        List<EsParserContextBase> fields = visitor.fields;
        List<EsParserContextBase> mappings = visitor.mappings;
        new ArrayList();
        ArrayList<Item> regindexitems = new ArrayList<Item>();
        if (indices != null && indices.size() != 0) {
            for (Object i : indices) {
                String index = i.getTextValue();
                if (index.contains(",")) {
                    for (String s : Arrays.asList(index.split(","))) {
                        Item item = new Item();
                        item.ref = i;
                        item.regex = s = s.replace("[", "\\[").replace("{", "\\{").replace("(", "\\(").replace(")", "\\)").replace("]", "\\]").replace("}", "\\}").replace("*", ".*");
                        regindexitems.add(item);
                    }
                    continue;
                }
                Item item = new Item();
                item.ref = i;
                item.regex = index = index.replace("[", "\\[").replace("{", "\\{").replace("(", "\\(").replace(")", "\\)").replace("]", "\\]").replace("}", "\\}").replace("*", ".*");
                regindexitems.add(item);
            }
        }
        if (regindexitems.size() == 0) {
            Item item = new Item();
            item.regex = ".*";
            regindexitems.add(item);
        }
        new ArrayList();
        ArrayList<Item> regtablesitems = new ArrayList<Item>();
        if (mappings != null && mappings.size() != 0) {
            for (Object i : mappings) {
                String index = i.getTextValue();
                index = index != null && index.equalsIgnoreCase("_doc") ? ".*" : index.replace("*", ".*");
                Item item = new Item();
                item.ref = i;
                item.regex = index;
                regtablesitems.add(item);
            }
        }
        if (regtablesitems.size() == 0) {
            Item item = new Item();
            item.regex = ".*";
            regtablesitems.add(item);
        }
        new ArrayList();
        ArrayList<Item> regfieldsitems = new ArrayList<Item>();
        if (fields != null && fields.size() != 0) {
            for (EsParserContextBase i : fields) {
                String index = i.getTextValue().replace("*", ".*");
                List complexFields = (List)i.getAttribute("complexFields");
                if (complexFields != null && complexFields.size() > 1) {
                    StringBuilder s = new StringBuilder();
                    for (EsParser.StringContext c : complexFields) {
                        s.append(c.getTextValue()).append(".");
                    }
                    s.deleteCharAt(s.length() - 1);
                    index = s.toString().replace("*", ".*");
                }
                Item item = new Item();
                item.ref = i;
                item.regex = index;
                regfieldsitems.add(item);
            }
        }
        if (regfieldsitems.size() == 0) {
            Item item = new Item();
            item.regex = ".*";
            regfieldsitems.add(item);
        }
        List<String> star = Arrays.asList("*");
        List<RegexInfo> descartesList = ApiParser.descartes(regindexitems, regtablesitems, regfieldsitems);
        ArrayList<String> imf = new ArrayList<String>();
        ArrayList<String> dataTypes = new ArrayList<String>();
        for (Schema schema : dataBase == null ? new ArrayList() : dataBase.getSchemaList()) {
            List<Table> tables = schema.getTableList();
            for (Table table : tables) {
                List<Column> columns = table.getColumnList();
                for (Column column : columns) {
                    imf.add(schema.getName() + "<" + table.getName() + "<" + column.getColumnName());
                    dataTypes.add(column.getDataType());
                }
                if (columns != null && columns.size() != 0) continue;
                imf.add(schema.getName() + "<" + table.getName() + "<");
                dataTypes.add(null);
            }
            if (tables != null && tables.size() != 0) continue;
            imf.add(schema.getName() + "<<");
            dataTypes.add(null);
        }
        this.checkRegex(result, descartesList, imf, dataTypes, dataBase);
        return result;
    }

    public void checkRegex(ApiResult result, List<RegexInfo> regexPatterns, List<String> lookupTables, List<String> dataTypes, DataBase dataBase) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (RegexInfo regexPattern : regexPatterns) {
            patterns.add(Pattern.compile(regexPattern.regex));
        }
        RefSet<IndexMemo> indexMemoHashSet = new RefSet<IndexMemo>();
        RefSet<MappingMemo> mappingMemoHashSet = new RefSet<MappingMemo>();
        RefSet<FieldMemo> fieldMemoHashSet = new RefSet<FieldMemo>();
        if (!dataBase.isRedis()) {
            int k = 0;
            for (String item : lookupTables) {
                for (int i = 0; i < patterns.size(); ++i) {
                    Pattern p = (Pattern)patterns.get(i);
                    Matcher m = p.matcher(item);
                    if (!m.matches()) continue;
                    RegexInfo info = regexPatterns.get(i);
                    this.normalizeColumn(dataTypes.get(k), indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, item, info);
                }
                ++k;
            }
        } else {
            for (RegexInfo regexPattern : regexPatterns) {
                String[] split = regexPattern.regex.split("<");
                if (split.length < 3) continue;
                NameWrapper nameWrapper = NameWrapper.create(DbType.of(dataBase.getDbType()), dataBase.simpleCache);
                if (".*".equals(split[0])) {
                    for (String schemaName : dataBase.getSchemaNamelistKey()) {
                        this.checkRegexForSchemaRedis(dataBase, indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, regexPattern, split, nameWrapper, schemaName);
                    }
                    continue;
                }
                this.checkRegexForSchemaRedis(dataBase, indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, regexPattern, split, nameWrapper, split[0]);
            }
        }
        for (IndexMemo i : indexMemoHashSet) {
            result.getSchemas().add(i);
        }
        for (MappingMemo m : mappingMemoHashSet) {
            result.getTables().add(m);
        }
        for (FieldMemo f : fieldMemoHashSet) {
            result.getFields().add(f);
        }
    }

    private void checkRegexForSchemaRedis(DataBase dataBase, Set<IndexMemo> indexMemoHashSet, Set<MappingMemo> mappingMemoHashSet, Set<FieldMemo> fieldMemoHashSet, RegexInfo regexPattern, String[] split, NameWrapper nameWrapper, String schemaName) {
        Schema schemaFromRedis = nameWrapper.getSchemaFromRedis(schemaName, dataBase.isCaseSensitive());
        if (".*".equals(split[1])) {
            for (String name : dataBase.getTableNamelistKey(schemaName)) {
                this.checkRegexForTableRedis(nameWrapper, schemaFromRedis, dataBase, indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, regexPattern, split, name);
            }
        } else {
            this.checkRegexForTableRedis(nameWrapper, schemaFromRedis, dataBase, indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, regexPattern, split, split[1]);
        }
    }

    private void checkRegexForTableRedis(NameWrapper nameWrapper, Schema schemaFromRedis, DataBase dataBase, Set<IndexMemo> indexMemoHashSet, Set<MappingMemo> mappingMemoHashSet, Set<FieldMemo> fieldMemoHashSet, RegexInfo regexPattern, String[] split, String tableName) {
        Table table = nameWrapper.getTableFromRedis(schemaFromRedis, tableName, dataBase.isCaseSensitive());
        for (Column column : table.getColumnList()) {
            String item = schemaFromRedis.getName() + "<" + tableName + "<" + column.getColumnName();
            if (".*".equals(split[2])) {
                this.normalizeColumn(column.getDataType(), indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, item, regexPattern);
                continue;
            }
            if (!column.getColumnName().equals(split[2])) continue;
            this.normalizeColumn(column.getDataType(), indexMemoHashSet, mappingMemoHashSet, fieldMemoHashSet, item, regexPattern);
        }
    }

    private void normalizeColumn(String dataType, Set<IndexMemo> indexMemoHashSet, Set<MappingMemo> mappingMemoHashSet, Set<FieldMemo> fieldMemoHashSet, String item, RegexInfo info) {
        String[] array = item.split("<");
        IndexMemo indexMemo = new IndexMemo();
        indexMemo.name = array[0];
        indexMemoHashSet.add(indexMemo);
        indexMemo.ref = info.indexRef;
        if (array.length > 1) {
            MappingMemo mappingMemo = new MappingMemo();
            mappingMemo.name = array[1];
            mappingMemo.ref = info.mappingRef;
            mappingMemo.index = indexMemo;
            mappingMemoHashSet.add(mappingMemo);
            if (array.length > 2) {
                FieldMemo fieldMemo = new FieldMemo();
                fieldMemo.ref = info.fieldRef;
                fieldMemo.name = item.split("<")[2];
                fieldMemo.index = indexMemo;
                fieldMemo.mapping = mappingMemo;
                fieldMemo.dataType = dataType;
                fieldMemoHashSet.add(fieldMemo);
            }
        }
    }

    public static List<RegexInfo> descartes(List<Item> regindexs, List<Item> regtables, List<Item> regfields) {
        ArrayList<RegexInfo> tempList = new ArrayList<RegexInfo>();
        Item item = new Item();
        item.regex = "*";
        if (regindexs.size() == 0) {
            regindexs.add(item);
        }
        for (Item regindex : regindexs) {
            for (Item regtable : regtables) {
                for (Item regfield : regfields) {
                    RegexInfo regexInfo = new RegexInfo();
                    regexInfo.indexRef = regindex.ref;
                    regexInfo.mappingRef = regtable.ref;
                    regexInfo.fieldRef = regfield.ref;
                    regexInfo.regex = regindex.regex;
                    regexInfo.regex = regindex.regex + "<" + regtable.regex + "<" + regfield.regex;
                    tempList.add(regexInfo);
                }
            }
        }
        return tempList;
    }

    public List<String> where(String request) {
        try {
            EsParser.StatementContext statement = EsUtils.parse(request);
            WhereVisitor visitor = new WhereVisitor();
            visitor.visit((ParseTree)statement);
            return visitor.getWheres();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    static class RefSet<T extends Reference>
    implements Set<T> {
        static final Object EMPTY = new Object();
        Map<T, T> map = new HashMap<T, T>();

        RefSet() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.map.keySet().toArray();
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.map.keySet().toArray(a);
        }

        @Override
        public boolean add(T t) {
            if (t == null) {
                return false;
            }
            Reference t1 = (Reference)this.map.get(t);
            if (t1 != null) {
                if (!t1.refs.contains(((Reference)t).ref)) {
                    t1.refs.add(((Reference)t).ref);
                }
                return true;
            }
            this.map.put(t, t);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.map.containsKey(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            for (Reference t : c) {
                this.add((T)t);
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    static class Item {
        EsParserContextBase ref;
        String regex;

        Item() {
        }
    }

    static class RegexInfo {
        EsParserContextBase indexRef;
        EsParserContextBase mappingRef;
        EsParserContextBase fieldRef;
        String regex;

        RegexInfo() {
        }
    }
}

