/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.hive.parser;

import bean.DataBase;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.hive.SQLParser;
import util.sqlparse.visitor.hive.parser.CompoundSQLStatementParser;
import util.sqlparse.visitor.hive.parser.SimpleSQLStatementParser;

public abstract class SQLStatementParser {
    public abstract SQLResult parseStatement(SQLStatement var1, DataBase var2, String var3);

    public static SQLResult parse(String sql, DataBase dataBase, String schema) {
        if (sql != null && sql.length() != 0) {
            List<SQLStatement> statements = SQLUtils.parseStatements(sql, "hive");
            return statements != null && statements.size() != 0 ? SQLStatementParser.parse(statements.get(0), dataBase, schema) : null;
        }
        throw new IllegalArgumentException("sql");
    }

    public static SQLResult parse(SQLStatement statement, DataBase dataBase, String schema) {
        SQLStatementParser parser;
        if (statement == null) {
            throw new IllegalArgumentException("statement");
        }
        StatementType type = SQLParser.getStatementType(statement);
        if (type == StatementType.other) {
            SQLResult result = new SQLResult();
            result.fields = new ArrayList<FieldInfo>();
            result.tables = new ArrayList<TableInfo>();
            result.tableMemos = new ArrayList<TableMemo>();
            result.outputMemos = new ArrayList<FieldMemo>();
            result.values = new ArrayList<ValueInfo>();
            result.outputs = new ArrayList<FieldInfo>();
            result.fieldMemos = new ArrayList<FieldMemo>();
            result.statement = statement;
            result.sqlType = TableStat.Mode.Other;
            result.statementType = type;
            return result;
        }
        switch (type) {
            case createProc: 
            case createFunction: 
            case createEvent: 
            case alterEvent: 
            case createTrigger: {
                parser = new CompoundSQLStatementParser();
                break;
            }
            default: {
                parser = new SimpleSQLStatementParser();
            }
        }
        return parser.parseStatement(statement, dataBase, schema);
    }
}

