/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.hivetdh;

import bean.Column;
import com.alibaba.druid.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import util.JdbcUtil;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.hivetdh.ExlActor;

public class Desensitization {
    private SQLResult result;
    private Map params;
    private Map paramMapParse;
    private String replaceSchema;
    private String replaceTable;
    private String replaceColumn;
    private String expression;

    public Desensitization(Map paramMap, Map params) {
        this.paramMapParse = paramMap;
        this.params = params;
        this.replaceSchema = this.getReplaceBackquote((String)params.get("replaceSchema"));
        this.replaceTable = this.getReplaceBackquote((String)params.get("replaceTable"));
        this.replaceColumn = this.getReplaceBackquote((String)params.get("replaceColumn"));
        this.expression = (String)params.get("expression");
    }

    public void downflowParseColumn() {
        this.downflowParseData();
    }

    public void downflowParseData() {
        TCLIService.FetchResults_result result = (TCLIService.FetchResults_result)this.params.get("FetchResults_result");
        TCLIService.GetResultSetMetadata_result metaData = (TCLIService.GetResultSetMetadata_result)this.params.get("GetResultSetMetadata_result");
        int position = -1;
        if (this.expression != null && !"".equals(this.expression)) {
            String schema = (String)this.paramMapParse.get("schema");
            List columnList = (List)this.paramMapParse.get("columnList");
            Map tableMap = (Map)this.paramMapParse.get("tableMap");
            Map schemaMap = (Map)this.paramMapParse.get("schemaMap");
            Set set = (Set)this.params.get("maskFieldIds");
            for (int i = 0; i < columnList.size(); ++i) {
                String schema_real;
                Column column = (Column)columnList.get(i);
                String columnObj = column.getColumnName();
                String[] cols = columnObj.split("\\.");
                if (cols.length < 2) continue;
                String alias = cols[0];
                if (alias != null && alias.length() > 0) {
                    alias = alias.replaceAll("[\"`]", "");
                }
                String name = cols[1];
                String tableName = "";
                if (tableMap.containsKey(alias)) {
                    tableName = ((String)tableMap.get(alias)).replaceAll("[\"`]", "").trim();
                } else if (tableMap.containsKey(alias.toUpperCase())) {
                    tableName = ((String)tableMap.get(alias.toUpperCase())).replaceAll("[\"`]", "").trim();
                }
                String schema_temp = (String)schemaMap.get(tableName);
                String string = schema_real = schema_temp == null ? schema : schema_temp;
                if (schema_real != null) {
                    schema_real = schema_real.replaceAll("[\"`]", "").trim();
                }
                if (!JdbcUtil.followRules(name, this.replaceColumn) || !JdbcUtil.followRules(tableName, this.replaceTable) || !JdbcUtil.followRules(schema_real, this.replaceSchema)) continue;
                this.params.put("isMatched", "true");
                for (Integer fieldId : column.getFieldIds()) {
                    if (set != null && set.contains(fieldId)) continue;
                    if (set != null) {
                        set.add(fieldId);
                    }
                    position = fieldId + 1;
                    this.executionExpression(result, position);
                }
            }
        }
    }

    private void executionExpression(TCLIService.FetchResults_result result, int position) {
        block5: {
            TColumn column;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            if (result.getSuccess().getResults().getColumns().size() < position) break block5;
                            column = (TColumn)result.getSuccess().getResults().getColumns().get(position - 1);
                            if (column.getSetField() != TColumn._Fields.STRING_VAL) break block6;
                            TStringColumn stringVal = column.getStringVal();
                            List values = stringVal.getValues();
                            for (int i = 0; i < values.size(); ++i) {
                                Object newVal = ExlActor.replace(this.expression, values.get(i));
                                if (newVal == null) continue;
                                values.set(i, (String)newVal);
                            }
                            break block5;
                        }
                        if (column.getSetField() != TColumn._Fields.DOUBLE_VAL) break block7;
                        TDoubleColumn doubleVal = column.getDoubleVal();
                        List values = doubleVal.getValues();
                        for (int i = 0; i < values.size(); ++i) {
                            Object newVal = ExlActor.replace(this.expression, values.get(i));
                            if (newVal == null) continue;
                            values.set(i, (Double)newVal);
                        }
                        break block5;
                    }
                    if (column.getSetField() != TColumn._Fields.I16_VAL) break block8;
                    TI16Column column1 = column.getI16Val();
                    List values = column1.getValues();
                    for (int i = 0; i < values.size(); ++i) {
                        Object newVal = ExlActor.replace(this.expression, values.get(i));
                        if (newVal == null) continue;
                        values.set(i, (Short)newVal);
                    }
                    break block5;
                }
                if (column.getSetField() != TColumn._Fields.I32_VAL) break block9;
                TI32Column column1 = column.getI32Val();
                List values = column1.getValues();
                for (int i = 0; i < values.size(); ++i) {
                    Object newVal = ExlActor.replace(this.expression, values.get(i));
                    if (newVal == null) continue;
                    values.set(i, (Integer)newVal);
                }
                break block5;
            }
            if (column.getSetField() != TColumn._Fields.I64_VAL) break block5;
            TI64Column column1 = column.getI64Val();
            List values = column1.getValues();
            for (int i = 0; i < values.size(); ++i) {
                Object newVal = ExlActor.replace(this.expression, values.get(i));
                if (newVal == null) continue;
                values.set(i, (Long)newVal);
            }
        }
    }

    private String getReplaceBackquote(String str) {
        return StringUtils.isEmpty(str) ? str : str.replaceAll("`", "").trim();
    }
}

