/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mysql.visitor;

import bean.DataBase;
import java.util.List;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class MySQLScopeDialector
extends ScopeDialector {
    public MySQLScopeDialector() {
    }

    public MySQLScopeDialector(Scope scope) {
        super(scope);
    }

    @Override
    public String wrap(String text) {
        if (text == null) {
            return null;
        }
        if (text.contains("`")) {
            return text;
        }
        return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : text;
    }

    @Override
    public String wrapAlias(String text) {
        if (text == null) {
            return null;
        }
        if (text.contains("`")) {
            return text;
        }
        return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : "`" + text + "`";
    }

    @Override
    public boolean expandAllColumns(TableMemo table, boolean isSub, List<FieldMemo> fields) {
        return true;
    }

    @Override
    public ScopeDialector clone(Scope scope) {
        return new MySQLScopeDialector(scope);
    }

    @Override
    public boolean isEqual(String name1, String name2) {
        DataBase dataBase;
        if (name1 == null && name2 != null) {
            return false;
        }
        if (name1 != null && name2 == null) {
            return false;
        }
        if (name1 == null && name2 == null) {
            return true;
        }
        String placeholder = "`";
        if (!name1.startsWith(placeholder)) {
            name1 = placeholder + name1 + placeholder;
        }
        if (!name2.startsWith(placeholder)) {
            name2 = placeholder + name2 + placeholder;
        }
        return (dataBase = this.scope.context.getDataBase()).isCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    @Override
    public boolean isColumnEqual(String name1, String name2) {
        if (name1 == null && name2 != null) {
            return false;
        }
        if (name1 != null && name2 == null) {
            return false;
        }
        return name1 == null && name2 == null ? true : name1.equalsIgnoreCase(name2);
    }
}

