/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.sqlserver;

import bean.DataBase;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropEventStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoadIndexIntoCacheStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.ParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.memo.ValueMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.sqlserver.visitor.FieldVisitor;
import util.sqlparse.visitor.sqlserver.visitor.FormatVisitor;
import util.sqlparse.visitor.sqlserver.visitor.SQLServerScopeDialector;
import util.sqlparse.visitor.sqlserver.visitor.ScopeVisitor;
import util.sqlparse.visitor.sqlserver.visitor.ValueReplacer;
import util.sqlparse.visitor.sqlserver.visitor.WhereVisitor;

public class SQLParser {
    public static final int RECURSION_TIMES = 100;

    public SQLResult parse(String sql, DataBase dataBase, String schema) {
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, "sqlserver");
        Context context = new Context();
        context.initialize(dataBase, schema, "sqlserver");
        Scope scope = new Scope();
        scope.dialector = new SQLServerScopeDialector(scope);
        scope.context = context;
        scope.isCheckIsolated = true;
        ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
        scopeVisitor.perform(statements);
        FieldVisitor fieldVisitor = new FieldVisitor(scope);
        fieldVisitor.perform(statements);
        SQLResult result = new SQLResult();
        result.sqlType = context.sqlType;
        result.root = scope;
        result.context = context;
        result.tables = context.getTables();
        HashMap<String, TableMemo> tables = new HashMap<String, TableMemo>(6);
        this.getAllTables(scope, tables);
        ArrayList<TableMemo> tableMemoList = new ArrayList<TableMemo>();
        for (TableMemo value : tables.values()) {
            if (value.topTable) continue;
            tableMemoList.add(value);
        }
        result.tableMemos = tableMemoList;
        tables.clear();
        HashMap<String, FieldMemo> fields = new HashMap<String, FieldMemo>();
        HashMap<String, FieldInfo> fieldInfos = new HashMap<String, FieldInfo>();
        this.getAllFields(scope, fields, fieldInfos);
        result.fieldMemos = new ArrayList(fields.values());
        result.fields = new ArrayList(fieldInfos.values());
        fields.clear();
        ArrayList<FieldInfo> outputFields = new ArrayList<FieldInfo>();
        this.getSelectFields(scope, fieldInfos, fields, context.getTableMap(), outputFields);
        result.outputMemos = new ArrayList(fields.values());
        result.outputs = outputFields;
        fields.clear();
        ArrayList<ValueInfo> values = new ArrayList<ValueInfo>();
        this.getValues(scope, fieldInfos, values);
        result.values = values;
        result.statement = statements.get(0);
        result.statementType = SQLParser.getStatementType(result.statement);
        result.isCaseSensitive = scope.isCaseSensitive();
        return result;
    }

    private void getAllTables(Scope scope, Map<String, TableMemo> tableMap) {
        for (Scope child : scope.getChildren()) {
            for (Map.Entry entry : child.getTableMap().entrySet()) {
                tableMap.put(((TableMemo)entry.getValue()).getUniqueName(), (TableMemo)entry.getValue());
            }
            this.getAllTables(child, tableMap);
        }
    }

    public void getAllFields(Scope scope, Map<String, FieldMemo> fieldMap, Map<String, FieldInfo> fields) {
        Map<String, TableInfo> tables = scope.context.getTableMap();
        for (Scope child : scope.getChildren()) {
            for (Map.Entry entry : child.getFieldMap().entrySet()) {
                fieldMap.put(((FieldMemo)entry.getValue()).getUniqueName(), (FieldMemo)entry.getValue());
                FieldMemo fieldMemo = (FieldMemo)entry.getValue();
                HashMap<String, TableInfo> tableMap = new HashMap<String, TableInfo>();
                boolean isValid = true;
                if ((fieldMemo.children.size() == 0 && !fieldMemo.complex || fieldMemo.atom) && !fieldMemo.isConstant) {
                    ArrayList<TableMemo> tableMemos = new ArrayList<TableMemo>(fieldMemo.tables);
                    if (fieldMemo.table != null) {
                        tableMemos.add(fieldMemo.table);
                    }
                    for (TableMemo table : tableMemos) {
                        TableInfo tableInfo = tables.get(table.getAtomName());
                        if (tableInfo == null) {
                            isValid = false;
                            break;
                        }
                        tableMap.put(table.getAtomName(), tableInfo);
                    }
                }
                if (tableMap.size() <= 0 || !isValid) continue;
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setName(fieldMemo.name);
                fieldInfo.setMemo(fieldMemo);
                fieldInfo.setAlias(fieldMemo.alias);
                fieldInfo.setFullName(fieldMemo.getAtomName());
                FieldInfo fieldInfoTmp = fields.get(fieldMemo.getAtomName());
                if (fieldInfoTmp != null) continue;
                fields.put(fieldMemo.getAtomName(), fieldInfo);
                fieldInfo.setTables(tableMap);
            }
            this.getAllFields(child, fieldMap, fields);
        }
    }

    public void getSelectFields(Scope scope, Map<String, FieldInfo> fields, Map<String, FieldMemo> fieldMap, Map<String, TableInfo> tables, List<FieldInfo> outputFields) {
        for (Scope child : scope.getChildren()) {
            if (child.top) continue;
            if (child.fromField) {
                return;
            }
            if (!child.top && child.getFieldMap().size() > 0) {
                for (Map.Entry entry : child.getFieldMap().entrySet()) {
                    FieldMemo field = (FieldMemo)entry.getValue();
                    if (!field.isSelectItem || field.isConstant) continue;
                    FieldInfo info = new FieldInfo();
                    info.setFullName(field.ref == null ? field.name : field.ref.toString());
                    info.setName(field.name);
                    info.setAlias(field.alias);
                    info.setMemo(field);
                    HashMap<String, FieldInfo> relations = new HashMap<String, FieldInfo>();
                    this.getFieldInfos(field, fields, relations, 0);
                    if (field.tables.size() > 0) {
                        this.getAtomTables(field.tables, tables, info.getTables());
                    }
                    if (relations.size() > 0) {
                        for (Map.Entry e : relations.entrySet()) {
                            info.getTables().putAll(((FieldInfo)e.getValue()).getTables());
                        }
                        info.setRelations(new ArrayList<FieldInfo>(relations.values()));
                    }
                    if (field.complex && relations.size() == 0) continue;
                    fieldMap.put(field.getUniqueName(), field);
                    outputFields.add(info);
                }
                continue;
            }
            this.getSelectFields(child, fields, fieldMap, tables, outputFields);
        }
    }

    private void getFieldInfos(FieldMemo fieldMemo, Map<String, FieldInfo> fields, Map<String, FieldInfo> output, int recursionTimes) {
        if (fieldMemo.children != null && fieldMemo.children.size() != 0) {
            for (FieldMemo child : fieldMemo.children) {
                if (++recursionTimes > 100) {
                    throw new ParserException("Children relation error. Grater than 100. field:" + child.getQualifiedName());
                }
                this.getFieldInfos(child, fields, output, recursionTimes);
                --recursionTimes;
            }
        } else {
            String name = fieldMemo.getAtomName();
            if (fields.containsKey(name)) {
                FieldInfo fieldInfo = fields.get(name);
                fieldInfo.getMemos().add(fieldMemo);
                output.put(name, fieldInfo);
            }
        }
    }

    private void getAtomTables(List<TableMemo> tables, Map<String, TableInfo> tableMap, Map<String, TableInfo> atomTableMap) {
        if (tables != null && tables.size() != 0) {
            for (TableMemo table : tables) {
                if (table.getChildren().size() == 0) {
                    TableInfo tableInfo = tableMap.get(table.getAtomName());
                    if (tableInfo == null) continue;
                    atomTableMap.put(tableInfo.getAtomName(), tableInfo);
                    continue;
                }
                this.getAtomTables(table.getChildren(), tableMap, atomTableMap);
            }
        }
    }

    private void getValues(Scope scope, Map<String, FieldInfo> fieldMap, List<ValueInfo> values) {
        for (ValueMemo value : scope.getValues()) {
            ValueInfo valueInfo = new ValueInfo(value);
            FieldMemo field = value.field;
            HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
            this.getFieldInfos(field, fieldMap, fields, 0);
            valueInfo.setFields(new ArrayList<FieldInfo>(fields.values()));
            values.add(valueInfo);
        }
    }

    public void replace(List<ValueInfo> values, Map<String, String> replaceValue) {
        ValueReplacer replacer = new ValueReplacer(replaceValue);
        replacer.replaceValues(values);
    }

    public void replace(List<ValueInfo> values, List<Map> whereList) {
        ValueReplacer replacer = new ValueReplacer(whereList);
        replacer.replaceValuesWithList(values);
    }

    public static StatementType getStatementType(SQLStatement statement) {
        if (statement instanceof SQLSelectStatement) {
            return StatementType.select;
        }
        if (statement instanceof SQLUpdateStatement) {
            return StatementType.update;
        }
        if (statement instanceof SQLDeleteStatement) {
            return StatementType.delete;
        }
        if (statement instanceof SQLInsertStatement) {
            return StatementType.insert;
        }
        if (statement instanceof SQLReplaceStatement) {
            return StatementType.replace;
        }
        if (statement instanceof SQLMergeStatement) {
            return StatementType.merge;
        }
        if (statement instanceof SQLTruncateStatement) {
            return StatementType.truncate;
        }
        if (statement instanceof SQLCreateTableStatement) {
            return StatementType.createTable;
        }
        if (statement instanceof SQLAlterTableStatement) {
            return StatementType.alterTable;
        }
        if (statement instanceof SQLDropTableStatement) {
            return StatementType.dropTable;
        }
        if (statement instanceof SQLCreateIndexStatement) {
            return StatementType.createIndex;
        }
        if (statement instanceof SQLAlterIndexStatement) {
            return StatementType.alterIndex;
        }
        if (statement instanceof SQLDropIndexStatement) {
            return StatementType.dropIndex;
        }
        if (statement instanceof SQLCreateViewStatement) {
            return StatementType.createView;
        }
        if (statement instanceof SQLAlterViewStatement) {
            return StatementType.alterView;
        }
        if (statement instanceof SQLDropViewStatement) {
            return StatementType.dropView;
        }
        if (statement instanceof SQLCreateProcedureStatement) {
            return StatementType.createProc;
        }
        if (statement instanceof SQLAlterProcedureStatement) {
            return StatementType.alterProc;
        }
        if (statement instanceof SQLDropProcedureStatement) {
            return StatementType.dropProc;
        }
        if (statement instanceof SQLCreateFunctionStatement) {
            return StatementType.createFunction;
        }
        if (statement instanceof SQLAlterFunctionStatement) {
            return StatementType.alterFunction;
        }
        if (statement instanceof SQLDropFunctionStatement) {
            return StatementType.dropFunction;
        }
        if (statement instanceof SQLCreateTriggerStatement) {
            return StatementType.createTrigger;
        }
        if (statement instanceof SQLDropTriggerStatement) {
            return StatementType.dropTrigger;
        }
        if (statement instanceof SQLDropEventStatement) {
            return StatementType.dropEvent;
        }
        if (statement instanceof SQLRevokeStatement) {
            return StatementType.revoke;
        }
        if (statement instanceof SQLGrantStatement) {
            return StatementType.grant;
        }
        if (statement instanceof SQLCallStatement) {
            return StatementType.callProc;
        }
        if (statement instanceof SQLShowIndexesStatement) {
            return StatementType.showIndex;
        }
        return statement instanceof SQLLoadIndexIntoCacheStatement ? StatementType.loadIndexIntoCache : StatementType.other;
    }

    public List<String> where(String sql) {
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, DbType.sqlserver);
        WhereVisitor visitor = new WhereVisitor();
        visitor.perform(statements);
        return visitor.getWheres();
    }

    public String format(String sql) {
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, DbType.sqlserver);
        if (statements != null && statements.size() != 0) {
            FormatVisitor visitor = new FormatVisitor();
            visitor.perform(statements);
            return statements.get(0).toString();
        }
        return "";
    }
}

