package com.chenyang.nse.bussiness.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertiesLocalStreamLoader {
   Map<String, Long> version = new HashMap();
   Map<String, Object> stream = new HashMap();
   ReadWriteLock lock = new ReentrantReadWriteLock(true);

   PropertiesLocalStreamLoader() {
   }

   public static PropertiesLocalStreamLoader instance() {
      return Holder.INSTANCE;
   }

   public InputStream load(String name) throws IOException {
      File file = new File(name);
      if (!file.exists()) {
         return null;
      } else {
         long l = file.lastModified();
         Long date = null;
         byte[] is = null;

         try {
            this.lock.readLock().lock();
            date = (Long)this.version.get(name);
            is = (byte[])this.stream.get(name);
         } finally {
            this.lock.readLock().unlock();
         }

         if (date == null) {
            ByteArrayInputStream var30;
            try {
               this.lock.writeLock().lock();
               if (!this.version.containsKey(name)) {
                  byte[] buffer = this.read(name);
                  this.version.put(name, l);
                  this.stream.put(name, buffer);
                  var30 = new ByteArrayInputStream(buffer);
                  return var30;
               }

               byte[] iss = (byte[])this.stream.get(name);
               var30 = new ByteArrayInputStream(iss);
            } finally {
               this.lock.writeLock().unlock();
            }

            return var30;
         } else if (l <= date) {
            return new ByteArrayInputStream(is);
         } else {
            ByteArrayInputStream var8;
            try {
               this.lock.writeLock().lock();
               date = (Long)this.version.get(name);
               if (date == null || l > date) {
                  byte[] buffer = this.read(name);
                  this.version.put(name, l);
                  this.stream.put(name, buffer);
                  var8 = new ByteArrayInputStream(buffer);
                  return var8;
               }

               byte[] iss = (byte[])this.stream.get(name);
               var8 = new ByteArrayInputStream(iss);
            } finally {
               this.lock.writeLock().unlock();
            }

            return var8;
         }
      }
   }

   private byte[] read(String file) throws IOException {
      ByteArrayOutputStream buffer = null;
      FileInputStream fis = null;

      byte[] var5;
      try {
         fis = new FileInputStream(file);
         buffer = new ByteArrayOutputStream();
         int b = -1;

         while((b = fis.read()) != -1) {
            buffer.write(b);
         }

         var5 = buffer.toByteArray();
         return var5;
      } catch (FileNotFoundException e) {
         e.printStackTrace();
         var5 = new byte[0];
      } finally {
         if (fis != null) {
            fis.close();
         }

         if (buffer != null) {
            buffer.close();
         }

      }

      return var5;
   }

   static class Holder {
      static PropertiesLocalStreamLoader INSTANCE = new PropertiesLocalStreamLoader();
   }
}
