package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDbfieldtype;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.enumeration.EcolumnType;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.console.DBFieldTypesService;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/dbfieldtypes"})
public class DBFieldTypesController {
   @Autowired
   private DBFieldTypesService dbFieldTypesService;
   @Autowired
   private DictionaryService dictionaryService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      return "console/dbfieldtypes";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public DataGridVO<TConsoleDbfieldtype> query(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TConsoleDbfieldtype> list = this.dbFieldTypesService.query(pageInfo);
      DataGridVO<TConsoleDbfieldtype> vo = new DataGridVO<TConsoleDbfieldtype>((long)Integer.valueOf(String.valueOf(pageInfo.getCount())), list);
      return vo;
   }

   @RequestMapping({"/refreshDBFieldTypes"})
   public void refreshDBFieldTypes() {
      this.dbFieldTypesService.refreshDBFieldTypes();
   }

   @RequestMapping({"/add"})
   public void add(TConsoleDbfieldtype dbFieldTypes, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dbFieldTypesService.save(dbFieldTypes);
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dbFieldTypesService.remove(idlist);
   }

   @RequestMapping({"/getcolumntypes"})
   @ResponseBody
   public List<ComboboxVO> getcolumntypes(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      EcolumnType[] db = EcolumnType.values();

      for(EcolumnType ecolumnType : db) {
         list.add(new ComboboxVO(ecolumnType.getJavatype(), ecolumnType.getColumnname()));
      }

      return list;
   }

   @RequestMapping({"/getdbtypes"})
   @ResponseBody
   public List<ComboboxVO> getdbtypes(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      EdbType[] db = EdbType.values();

      for(EdbType item : db) {
         list.add(new ComboboxVO(item.getDbcode()));
      }

      return list;
   }

   @RequestMapping({"/getenginecolumntypes"})
   @ResponseBody
   public List<ComboboxVO> getenginecolumntypes(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> typeList = this.dictionaryService.queryDictionaryValues("12");
      List<ComboboxVO> list = new ArrayList();

      for(String ecolumnType : typeList) {
         list.add(new ComboboxVO(ecolumnType));
      }

      return list;
   }
}
