package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.service.console.OperationService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/operation"})
public class OperationRecordController {
   @Autowired
   private OperationService operationService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      return "core/operationrecord";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public List<TConsoleLog> query(String user, String module, String operationtime, String operationObject, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleLog> list = this.operationService.query1(user, module, operationtime, operationObject);
      return list;
   }

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response queryAll(@RequestParam Map<String, String> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      String createuser = (String)params.get("createuser");
      String datasourceid = (String)params.get("datasourceid");
      String projectid = (String)params.get("projectid");
      List<Map<String, Object>> list = this.operationService.queryCategorySensitiveLog(pageInfo, "", createuser, projectid);
      return RespHelper.successResp(list, pageInfo.getCount().intValue());
   }
}
