package com.chenyang.nse.bussiness.controller.console;

import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRolemenu;
import com.chenyang.nse.bussiness.entity.vo.MenuGridVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.service.console.ButtonService;
import com.chenyang.nse.bussiness.service.console.MenuService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.RoleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/role"})
public class RoleController {
   @Autowired
   private RoleService roleService;
   @Autowired
   private MenuService menuService;
   @Autowired
   private ButtonService buttonService;
   @Autowired
   private OperationService operationService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      return "console/role";
   }

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_00201", new String[]{CommonUtils.loginUsername()}));
      Integer page = (Integer)params.get("page");
      Integer rows = (Integer)params.get("rows");
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TBaseRole> list = this.roleService.query(params, pageInfo);
      return RespHelper.updateResp(pageInfo, list);
   }

   @GetMapping({"/queryAll"})
   @ResponseBody
   public Response queryAll(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseRole> list = this.roleService.queryAll();
      return RespHelper.successResp(list);
   }

   @PostMapping({"/checkNameExit"})
   @ResponseBody
   public Response checkNameExit(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String rolename = (String)params.get("rolename");
      boolean result = this.roleService.checkNameExit(rolename);
      Map<String, Object> map = new HashMap();
      map.put("result", result);
      return result ? RespHelper.createResp(false, "POP_00012", MesUtil.getMsg("POP_00012", new String[0])) : RespHelper.successResp(map);
   }

   @PostMapping({"/initEdit"})
   @ResponseBody
   public Response queryRoleId(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String roleid = (String)params.get("roleid");
      TBaseRole tBaseRole = this.roleService.queryRoleId(roleid);
      List<TBaseRolemenu> tBaseRolemenus = this.roleService.queryMenuByRoleid(roleid);
      Map<String, Object> map = new HashMap();
      map.put("roles", tBaseRole);
      map.put("menuIdList", tBaseRolemenus);
      ddmauditLogger.info(MesUtil.getMsg("DDM_00202", new String[]{CommonUtils.loginUsername(), tBaseRole.getRolename()}));
      return RespHelper.successResp(map);
   }

   @PostMapping({"/modify"})
   @ResponseBody
   public Response modify(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> idList = (List)params.get("idList");
      TBaseRole role = (TBaseRole)ObjectTool.getObjectByMap(TBaseRole.class, (Map)params.get("roles"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_00203", new String[]{CommonUtils.loginUsername(), role.getRolename()}));
      this.roleService.deleteRoleMenuByRoleid(role.getId());
      this.roleService.updataRole(role);
      this.roleService.saveRoleMenu(idList, role.getId());
      return RespHelper.successResp();
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      ddmauditLogger.info(MesUtil.getMsg("DDM_00205", new String[]{CommonUtils.loginUsername(), this.roleService.queryRoleId(id).getRolename()}));
      this.roleService.remove(id);
      this.roleService.deleteRoleMenuByRoleid(id);
      return RespHelper.successResp();
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response add(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> idList = (List)params.get("idList");
      TBaseRole role = (TBaseRole)ObjectTool.getObjectByMap(TBaseRole.class, (Map)params.get("roles"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_00204", new String[]{CommonUtils.loginUsername(), role.getRolename()}));
      TBaseRole tBaseRole = new TBaseRole();
      tBaseRole.setId(StringTool.getTablePrimaryKey());
      tBaseRole.setRolename(role.getRolename());
      tBaseRole.setRemark(role.getRemark() == null ? "" : role.getRemark());
      tBaseRole.setCreatetime(new Date());
      tBaseRole.setCreateuser(CommonUtils.loginUsername());
      tBaseRole.setCreatetime(new Date());
      this.roleService.saveRoleMenu(idList, tBaseRole.getId());
      this.roleService.save(tBaseRole);
      return RespHelper.successResp();
   }

   @GetMapping({"/test"})
   public void test() {
      TBaseRole role = new TBaseRole();
      role.setRolename("2222");
      this.roleService.save(role);
   }

   @RequestMapping({"/querytreedata"})
   @ResponseBody
   public List<TreeVO> querytreedata(String id, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      List<TreeVO> list = this.menuService.queryMenuTree(flag);
      return list;
   }

   @ResponseBody
   @PostMapping({"/querylaytreedata"})
   public List<Object> querylaytreedata(String flag, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      List<TreeVO> layTreeList = this.menuService.queryMenuTree(flag);
      List<Object> list = new ArrayList();

      for(TreeVO ltl : layTreeList) {
         JSONObject treeObj = new JSONObject();
         treeObj.put("id", ltl.getId());
         treeObj.put("title", ltl.getText());
         treeObj.put("spread", true);
         if (ltl.getChildren() != null) {
            treeObj.put("children", this.getChildren(ltl.getId(), ltl.getChildren()));
         }

         list.add(treeObj);
      }

      return list;
   }

   public List<Object> getChildren(String Id, List<TreeVO> fileDirectories) {
      List<Object> list = new ArrayList();

      for(TreeVO f : fileDirectories) {
         JSONObject obj = new JSONObject();
         obj.put("id", f.getId());
         obj.put("title", f.getText());
         obj.put("pid", Id);
         obj.put("spread", true);
         if ("true".equals(f.getChecked())) {
            obj.put("checked", true);
         }

         if (f.getChildren() != null) {
            obj.put("children", this.getChildren(f.getId(), f.getChildren()));
         }

         list.add(obj);
      }

      return list;
   }

   public List<Object> getChildrenChecked(String Id, List<TreeVO> fileDirectories) {
      List<Object> list = new ArrayList();

      for(TreeVO f : fileDirectories) {
         JSONObject obj = new JSONObject();
         obj.put("id", f.getId());
         obj.put("title", f.getText());
         obj.put("pid", Id);
         obj.put("checked", true);
         if (f.getChildren() != null) {
            obj.put("children", this.getChildren(f.getId(), fileDirectories));
         }

         list.add(obj);
      }

      return list;
   }

   @RequestMapping({"/querycheckedtreedata"})
   @ResponseBody
   public List<TreeVO> querycheckedtreedata(String roleid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      List<TreeVO> list = this.menuService.queryMenuTree(flag);
      List<TBaseRolemenu> roleMenuList = this.roleService.queryMenuByRoleid(roleid);
      List<String> menulist = new ArrayList();

      for(TBaseRolemenu temp : roleMenuList) {
         menulist.add(temp.getMenuid());
      }

      for(TreeVO rootMenu : list) {
         if (rootMenu.getChildren() != null) {
            for(TreeVO childMenu : rootMenu.getChildren()) {
               if (menulist.contains(childMenu.getId())) {
                  if (childMenu.getChildren() != null) {
                     for(TreeVO grandson : childMenu.getChildren()) {
                        if (menulist.contains(grandson.getId())) {
                           grandson.setChecked(Boolean.TRUE.toString());
                        }
                     }
                  } else {
                     childMenu.setChecked(Boolean.TRUE.toString());
                  }
               }
            }
         }
      }

      return list;
   }

   @RequestMapping({"/querycheckedlaytreedata"})
   @ResponseBody
   public List<Object> querycheckedlaytreedata(String roleid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Object> returnList = new ArrayList();
      List<TreeVO> list = this.menuService.queryMenuTree(flag);
      List<TBaseRolemenu> roleMenuList = this.roleService.queryMenuByRoleid(roleid);
      List<String> menulist = new ArrayList();

      for(TBaseRolemenu temp : roleMenuList) {
         menulist.add(temp.getMenuid());
      }

      for(TreeVO rootMenu : list) {
         JSONObject treeObj = new JSONObject();
         treeObj.put("id", rootMenu.getId());
         treeObj.put("title", rootMenu.getText());
         treeObj.put("spread", true);
         if (menulist.contains(rootMenu.getId())) {
            rootMenu.setChecked(Boolean.TRUE.toString());
            treeObj.put("checked", "true");
         }

         List<TreeVO> childMenu = rootMenu.getChildren();
         if (childMenu != null) {
            for(int i = 0; i < childMenu.size(); ++i) {
               if (menulist.contains(((TreeVO)childMenu.get(i)).getId())) {
                  ((TreeVO)rootMenu.getChildren().get(i)).setChecked("true");
                  List<TreeVO> childchildMenu = ((TreeVO)childMenu.get(i)).getChildren();
                  if (childchildMenu != null) {
                     for(int j = 0; j < childchildMenu.size(); ++j) {
                        if (menulist.contains(((TreeVO)childchildMenu.get(j)).getId())) {
                           ((TreeVO)((TreeVO)rootMenu.getChildren().get(i)).getChildren().get(j)).setChecked("true");
                        }
                     }
                  }
               }
            }
         }

         if (rootMenu.getChildren() != null) {
            treeObj.put("children", this.getChildren(rootMenu.getId(), rootMenu.getChildren()));
         }

         returnList.add(treeObj);
      }

      return returnList;
   }

   @RequestMapping({"/querymenudetail"})
   @ResponseBody
   public List<TreeVO> querymenudetail(String roleid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TreeVO> result = new ArrayList();
      List<TreeVO> list = this.menuService.queryMenuTree(flag);
      List<TBaseRolemenu> roleMenuList = this.roleService.queryMenuByRoleid(roleid);
      List<String> menulist = new ArrayList();

      for(TBaseRolemenu temp : roleMenuList) {
         menulist.add(temp.getMenuid());
      }

      List<TreeVO> selectedSubmenu = null;
      List<TreeVO> selectedallbutton = null;

      for(int i = 0; i < list.size(); ++i) {
         TreeVO allmenu = (TreeVO)list.get(i);
         String allid = ((TreeVO)list.get(i)).getId();
         if (menulist.contains(allid)) {
            result.add(allmenu);
            if (allmenu.getChildren() != null) {
               List<TreeVO> allsubmenu = allmenu.getChildren();
               selectedSubmenu = new ArrayList();

               for(int j = 0; j < allsubmenu.size(); ++j) {
                  if (menulist.contains(((TreeVO)allsubmenu.get(j)).getId())) {
                     selectedSubmenu.add(allsubmenu.get(j));
                     if (((TreeVO)allsubmenu.get(j)).getChildren() != null) {
                        List<TreeVO> allbutton = ((TreeVO)allsubmenu.get(j)).getChildren();
                        selectedallbutton = new ArrayList();

                        for(int m = 0; m < allbutton.size(); ++m) {
                           if (menulist.contains(((TreeVO)allbutton.get(m)).getId())) {
                              selectedallbutton.add(allbutton.get(m));
                           }
                        }

                        ((TreeVO)allsubmenu.get(j)).setChildren(selectedallbutton);
                     }
                  }
               }

               allmenu.setChildren(selectedSubmenu);
            }
         }
      }

      return result;
   }

   @RequestMapping({"/querylaymenudetail"})
   @ResponseBody
   public List<Object> querylaymenudetail(String roleid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Object> returnList = new ArrayList();
      List<TreeVO> result = new ArrayList();
      List<TreeVO> list = this.menuService.queryMenuTree(flag);
      List<TBaseRolemenu> roleMenuList = this.roleService.queryMenuByRoleid(roleid);
      List<String> menulist = new ArrayList();

      for(TBaseRolemenu temp : roleMenuList) {
         menulist.add(temp.getMenuid());
      }

      List<TreeVO> selectedSubmenu = null;
      List<TreeVO> selectedallbutton = null;

      for(int i = 0; i < list.size(); ++i) {
         TreeVO allmenu = (TreeVO)list.get(i);
         String allid = ((TreeVO)list.get(i)).getId();
         if (menulist.contains(allid)) {
            result.add(allmenu);
            if (allmenu.getChildren() != null) {
               List<TreeVO> allsubmenu = allmenu.getChildren();
               selectedSubmenu = new ArrayList();

               for(int j = 0; j < allsubmenu.size(); ++j) {
                  if (menulist.contains(((TreeVO)allsubmenu.get(j)).getId())) {
                     selectedSubmenu.add(allsubmenu.get(j));
                     if (((TreeVO)allsubmenu.get(j)).getChildren() != null) {
                        List<TreeVO> allbutton = ((TreeVO)allsubmenu.get(j)).getChildren();
                        selectedallbutton = new ArrayList();

                        for(int m = 0; m < allbutton.size(); ++m) {
                           if (menulist.contains(((TreeVO)allbutton.get(m)).getId())) {
                              selectedallbutton.add(allbutton.get(m));
                           }
                        }

                        ((TreeVO)allsubmenu.get(j)).setChildren(selectedallbutton);
                     }
                  }
               }

               allmenu.setChildren(selectedSubmenu);
            }
         }
      }

      for(TreeVO ltl : result) {
         JSONObject treeObj = new JSONObject();
         treeObj.put("id", ltl.getId());
         treeObj.put("title", ltl.getText());
         treeObj.put("spread", true);
         if (ltl.getChildren() != null) {
            treeObj.put("children", this.getChildren(ltl.getId(), ltl.getChildren()));
         }

         returnList.add(treeObj);
      }

      return returnList;
   }

   @RequestMapping({"/queryMenuByRoleId"})
   @ResponseBody
   public List<MenuGridVO> queryMenuByRoleId(String roleId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<MenuGridVO> list = this.roleService.queryMenuGridByRoleid(roleId);
      return list;
   }

   @RequestMapping({"/queryUserRoleCountByRoleId"})
   @ResponseBody
   public int queryUserRoleCountByRoleId(String roleId, HttpServletRequest request, HttpServletResponse response, Model model) {
      int count = this.roleService.queryUserRoleCountByRoleId(roleId);
      return count;
   }

   @RequestMapping({"/queryroleByid"})
   @ResponseBody
   public TBaseRole queryroleByid(String id) {
      TBaseRole queryRoleId = this.roleService.queryRoleId(id);
      return queryRoleId;
   }
}
