package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/searchregex"})
public class SearchRegexController {
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private DictionaryService dictionaryService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      return "console/searchregex";
   }

   @RequestMapping({"/queryRegexType"})
   @ResponseBody
   public List<ComboboxVO> queryRegexType(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> list = this.dictionaryService.queryAllRegexTypes();
      List<ComboboxVO> result = new ArrayList();

      for(String str : list) {
         result.add(new ComboboxVO(str));
      }

      return result;
   }

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, Object> params) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_00301", new String[]{CommonUtils.loginUsername()}));
      PageInfo pageInfo = new PageInfo();
      if (null != params) {
         Integer page = (Integer)params.get("page");
         Integer rows = (Integer)params.get("rows");
         System.out.println();
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
      } else {
         pageInfo.setPageno(1);
         pageInfo.setPagesize(10);
      }

      List<TConsoleSearchregex> list = this.searchRegexService.query(pageInfo);

      for(int i = 0; i < list.size(); ++i) {
         TConsoleSearchregex var5 = (TConsoleSearchregex)list.get(i);
      }

      return RespHelper.updateResp(pageInfo, list);
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.searchRegexService.remove(idlist);
   }

   @RequestMapping({"/check"})
   @ResponseBody
   public ResultVO check(String name, String oldname, String regex, HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO vo = null;
      if (name.equals(oldname)) {
         vo = new ResultVO((String)null, false);
      } else {
         boolean result = this.searchRegexService.checkNameExit(name);
         vo = new ResultVO((String)null, result);
      }

      String message = "";
      if (vo.getResult()) {
         message = "规则名已存在，";
      }

      try {
         Pattern.compile(regex);
      } catch (Exception var10) {
         message = message + "正则表达式错误，";
         vo.setResult(true);
      }

      if (message != "") {
         vo.setMessage(message.substring(0, message.length() - 1));
      }

      return vo;
   }

   @RequestMapping({"/add"})
   public void add(TConsoleSearchregex searchRegex, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.searchRegexService.save(searchRegex);
   }

   @RequestMapping({"/deleteRegexTypeName"})
   @ResponseBody
   public List<RegexTypeColorVO> deleteRegexTypeName(String regexTypeName, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dictionaryService.delete(regexTypeName);
      return this.dictionaryService.queryAllRegexTypeColor();
   }

   @RequestMapping({"/saveRegexTypeName"})
   @ResponseBody
   public List<RegexTypeColorVO> saveRegexTypeName(String regexTypeName, String regexTypeColor, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dictionaryService.save(regexTypeName, regexTypeColor);
      return this.dictionaryService.queryAllRegexTypeColor();
   }

   @RequestMapping({"/queryRegexTypeColor"})
   @ResponseBody
   public String queryRegexTypeColor(String regexTypeName, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.dictionaryService.queryRegexTypeColor(regexTypeName);
   }

   @RequestMapping({"/queryAllRegexTypeColor"})
   @ResponseBody
   public List<RegexTypeColorVO> queryAllRegexTypeColor() {
      return this.dictionaryService.queryAllRegexTypeColor();
   }

   @RequestMapping({"/testRegex"})
   @ResponseBody
   public ResultVO testRegex(String regex, String testString, String ruleargument, HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO vo = null;

      try {
         if (regex.startsWith("MethodName:")) {
            String methodName = regex.substring(11);
            int maxLength = -1;
            int level = 0;
            if (methodName.contains("MaxLength:")) {
               String[] strings = methodName.split("\\|MaxLength:");
               if (strings.length == 2) {
                  methodName = strings[0];
                  String[] Weight = strings[1].split("\\|Weight:");
                  maxLength = Integer.parseInt(Weight[0]);

                  try {
                     level = Integer.parseInt(Weight[1]);
                  } catch (Exception var14) {
                     level = 0;
                  }
               }
            }

            this.searchRegexService.init();
            vo = new ResultVO((String)null, this.searchRegexService.matches(methodName, maxLength, testString, level));
         } else {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(testString);
            vo = new ResultVO((String)null, matcher.matches());
         }
      } catch (Exception ex) {
         vo = new ResultVO("SynaxError", true);
         ex.printStackTrace();
      }

      return vo;
   }

   @RequestMapping({"/querySensitiveTypes"})
   @ResponseBody
   public List<TConsoleDictionary> querySensitiveTypes(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.dictionaryService.querySensitiveTypes();
   }

   @RequestMapping({"/sortSensitiveTypes"})
   public void sortSensitiveTypes(@RequestParam("ids[]") List<String> ids, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dictionaryService.sortSensitiveTypes(ids);
   }
}
