package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.TCoreLogParamDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreLogParam;
import com.chenyang.nse.bussiness.job.LogTask;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/system/logconfig"})
public class SystemLogConfigController {
   @Autowired
   HttpServletRequest request;
   @Autowired
   TCoreLogParamDao tCoreLogParamDao;

   @RequestMapping({"/save"})
   @ResponseBody
   public Response save(@RequestBody(required = false) Map<String, String> map) {
      String reservemonth = (String)map.get("reservemonth");
      TCoreLogParam tCoreLogParam = new TCoreLogParam();
      tCoreLogParam.setReservemonth(reservemonth);
      tCoreLogParam.setCreatetime(new Date());
      String username = TokenUtil.getUserId(this.request.getHeader("token"));
      tCoreLogParam.setCreateuser(username);
      tCoreLogParam.setId(StringTool.getTablePrimaryKey());
      this.tCoreLogParamDao.save(tCoreLogParam);
      return RespHelper.successResp();
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, String> map) {
      List<Map<String, Object>> logParamList = this.tCoreLogParamDao.selectNewReservemonth();
      if (null == logParamList) {
         return RespHelper.successResp("0");
      } else {
         return logParamList.size() > 0 ? RespHelper.successResp(((Map)logParamList.get(0)).get("reservemonth")) : RespHelper.successResp("0");
      }
   }

   @RequestMapping({"/querylog"})
   @ResponseBody
   public Response querylog(@RequestBody(required = false) Map<String, Object> map) {
      String date = (String)map.get("date");
      Integer count = (Integer)map.get("count");
      String res = CommandTool.getlogcommand(date, count);
      return RespHelper.successResp(res);
   }

   @RequestMapping({"/download"})
   @ResponseBody
   public Response download(HttpServletResponse response, @RequestBody Map<String, String> map) {
      if (null != map) {
         String datestring = (String)map.get("date");
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String logpath = "";
         if (LocalDate.now().toString().equals(datestring)) {
            logpath = props.getProperty("deployPath") + "/encryption.log";
         } else {
            logpath = props.getProperty("oldlogpath") + "/system-" + datestring + ".log";
         }

         File file = new File(logpath);
         if (!file.exists()) {
            return RespHelper.errRespStr("日志不存在");
         } else {
            try {
               response.setCharacterEncoding("utf-8");
               response.setContentType("multipart/form-data");
               response.setHeader("Content-Disposition", "attachment;fileName=" + datestring + ".log");
               OutputStream outputStream = response.getOutputStream();
               InputStream inputStream = new FileInputStream(file);
               byte[] buffer = new byte[1024];
               int i = -1;

               while((i = inputStream.read(buffer)) != -1) {
                  outputStream.write(buffer, 0, i);
               }

               outputStream.flush();
               outputStream.close();
               inputStream.close();
            } catch (IOException e) {
               e.printStackTrace();
            }

            return null;
         }
      } else {
         return RespHelper.errRespStr("参数错误");
      }
   }

   @RequestMapping({"/testlog"})
   @ResponseBody
   @PassToken
   public Response testlog() {
      (new LogTask()).saveLog();
      return RespHelper.successResp();
   }
}
