package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.console.UserGroupService;
import com.chenyang.nse.bussiness.sso.SSOUserManager;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/usergroup"})
public class UserGroupController {
   @Autowired
   SSOUserManager ssoUserManager;
   @Autowired
   private UserGroupService userGroupService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @GetMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println();
      return "console/usergroup";
   }

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, Object> params) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_00301", new String[]{CommonUtils.loginUsername()}));
      PageInfo pageInfo = new PageInfo();
      if (null != params) {
         Integer page = (Integer)params.get("page");
         Integer rows = (Integer)params.get("rows");
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         List var5 = this.userGroupService.query(pageInfo, params);
         return RespHelper.updateResp(pageInfo, var5);
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/initEdit"})
   @ResponseBody
   public Response initEdit(@RequestBody(required = false) Map<String, Object> params) {
      String groupid = "7532c3d5780441fe9708b04b9c2788df";
      if (null != params) {
         groupid = (String)params.get("groupid");
         HashMap reMap = new HashMap();
         TBaseGroup tBaseGroup = this.userGroupService.queryGroupByid(groupid);
         List tBaseGrouproleList = this.userGroupService.querygroupRoleBygroupid(groupid);
         List tBaseGroupmenuList = this.userGroupService.querygroupMenuBygroupid(groupid);
         reMap.put("tBaseGroup", tBaseGroup);
         reMap.put("tBaseGrouproleList", tBaseGrouproleList);
         reMap.put("tBaseGroupmenuList", tBaseGroupmenuList);
         ddmauditLogger.info(MesUtil.getMsg("DDM_00302", new String[]{CommonUtils.loginUsername(), tBaseGroup.getGroupname()}));
         return RespHelper.successResp(reMap);
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response add(@RequestBody(required = false) Map<String, Object> params) {
      TBaseGroup group = null;
      List<String> roleList = null;
      List<String> menuList = null;
      if (null != params) {
         group = (TBaseGroup)ObjectTool.getObjectByMap(TBaseGroup.class, (Map)params.get("group"));
         List<String> var7 = (ArrayList)params.get("roleList");
         List<String> var8 = (ArrayList)params.get("menuList");
         ddmauditLogger.info(MesUtil.getMsg("DDM_00304", new String[]{CommonUtils.loginUsername(), group.getGroupname()}));
         group = this.userGroupService.saveGroup(group);
         this.userGroupService.saveGroupRole(group, var7);
         this.userGroupService.saveGroupMenu(group, var8);
         (new Thread(() -> this.ssoUserManager.sendUsersAndOrgs2SSOServer())).start();
         return RespHelper.successResp();
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/modify"})
   @ResponseBody
   public Response modify(@RequestBody(required = false) Map<String, Object> params) {
      TBaseGroup group = null;
      List<String> roleList = null;
      List<String> menuList = null;
      if (null != params) {
         group = (TBaseGroup)ObjectTool.getObjectByMap(TBaseGroup.class, (Map)params.get("group"));
         List<String> var6 = (ArrayList)params.get("roleList");
         List<String> var7 = (ArrayList)params.get("menuList");
         ddmauditLogger.info(MesUtil.getMsg("DDM_00303", new String[]{CommonUtils.loginUsername(), group.getGroupname()}));
         this.userGroupService.save(group);
         this.userGroupService.saveGroupRole(group, var6);
         this.userGroupService.saveGroupMenu(group, var7);
         return RespHelper.successResp();
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @GetMapping({"/checkNameExit"})
   @ResponseBody
   public Response checkNameExit(@RequestParam(required = false) String groupname) {
      if (StringUtil.isBlank(groupname)) {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      } else {
         boolean result = this.userGroupService.checkNameExit(groupname);
         return result ? RespHelper.createResp(false, "POP_00011", MesUtil.getMsg("POP_00011", new String[0])) : RespHelper.successResp(result);
      }
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response del(@RequestBody(required = false) Map<String, Object> params) {
      String groupid = "";
      if (null != params) {
         groupid = (String)params.get("groupid");
      } else if (StringUtil.isBlank(groupid)) {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }

      if (StringUtil.isBlank(groupid)) {
         return RespHelper.successResp(false);
      } else {
         ddmauditLogger.info(MesUtil.getMsg("DDM_00305", new String[]{CommonUtils.loginUsername(), this.userGroupService.queryGroupByid(groupid).getGroupname()}));
         this.userGroupService.removeGroupByid(groupid);
         return RespHelper.successResp();
      }
   }

   @RequestMapping({"/queryUserByGroupId"})
   @ResponseBody
   public DataGridVO<TBaseUser> queryUserByGroupId(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseUser> list = this.userGroupService.queryUserByGroupId(groupId);
      DataGridVO<TBaseUser> vo = new DataGridVO<TBaseUser>(0L, list);
      return vo;
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.userGroupService.remove(idlist);
   }

   @GetMapping({"/queryByGroupName"})
   @ResponseBody
   public Response queryByGroupName(@RequestParam(required = false) String groupname) {
      TBaseGroup tBaseGroup = this.userGroupService.queryGroupByGroupName(groupname);
      return RespHelper.successResp(tBaseGroup);
   }

   @GetMapping({"/queryAll"})
   @ResponseBody
   public Response queryallgroups() {
      List<TBaseGroup> groupsList = this.userGroupService.queryallgroups();
      return RespHelper.successResp(groupsList);
   }
}
