package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TXmlFile;
import com.chenyang.nse.bussiness.service.console.XmlEditService;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/xmledit"})
public class XMLEditController {
   @Autowired
   private XmlEditService xmlEditService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/propertiesedit/xmledit";
   }

   @RequestMapping({"/getpropertieselist"})
   @ResponseBody
   public List<TXmlFile> getPropertieseList(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      Map<String, Map<String, String>> list = XmlTool.getXmlFile();
      List<TXmlFile> list1 = this.xmlEditService.getXmlList(list);
      return list1;
   }
}
