package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.core.TCoreDataareaSecretkeyRelationDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataareaSecretkeyRelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ComplianceDirectoryVO;
import com.chenyang.nse.bussiness.service.console.DataareaSecretkeyRelationService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/dataareasecretkey"})
public class DataareaSecretkeyRelationController {
   @Autowired
   private DataareaSecretkeyRelationService dataareaSecretkeyRelationService;
   @Autowired
   TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   TCoreDataareaSecretkeyRelationDao tCoreDataareaSecretkeyRelationDao;

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, Object> params) {
      String dataarea = "";
      if (null != params) {
         dataarea = (String)params.get("dataarea");
      } else {
         dataarea = "";
      }

      List<TCoreDataArea> list = this.dataareaSecretkeyRelationService.queryDataAreaSecretKey(dataarea);
      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/save"})
   public Response save(@RequestBody TCoreDataareaSecretkeyRelation sec) {
      boolean b = this.dataareaSecretkeyRelationService.save(sec);
      return b ? RespHelper.successResp() : RespHelper.errRespStr("加密算法名重复");
   }

   @ResponseBody
   @RequestMapping({"/delete"})
   public Response delete(@RequestBody Map<String, String> map) {
      String relationid = (String)map.get("relationid");
      this.dataareaSecretkeyRelationService.delete(relationid);
      return RespHelper.successResp();
   }

   @PostMapping({"/queryenc"})
   @ResponseBody
   public Response queryenc(@RequestBody(required = false) Map<String, Object> map) {
      List<TCoreEncryption> list = this.tCoreEncryptionDao.queryAll();
      return RespHelper.successResp(list);
   }

   @PostMapping({"/querysec"})
   @ResponseBody
   public Response querysec(@RequestBody Map<String, Object> map) {
      String encryption_id = (String)map.get("encryption_id");
      List<TCoreSecretkey> list = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("encryption_id", encryption_id)});
      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryTask"})
   public Response<List<ComboboxVO>> queryTask(@RequestBody ComplianceDirectoryVO vo) {
      List<ComboboxVO> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      StringBuffer str = new StringBuffer();
      if (taskfile.exists()) {
         File[] f = taskfile.listFiles();

         for(int i = 0; i < f.length; ++i) {
            str.append("'" + f[i].getName() + "'" + ',');
         }

         list = this.tdataProjectService.queryTaskList(str.substring(0, str.length() - 1), vo.getProjectId());
      }

      return RespHelper.<List<ComboboxVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersion"})
   public Response queryTaskVersion(@RequestBody Map<String, Object> map) {
      String taskid = (String)map.get("taskid");
      List<Map<String, String>> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion") + taskid);
      String str = "";
      if (taskfile.listFiles() != null) {
         File[] f = taskfile.listFiles();

         for(int i = 0; i < f.length; ++i) {
            str = f[i].getName().split("\\.txt")[0];
            String username = str.substring(str.lastIndexOf("_") + 1);
            String s = str.replace("_" + username, "");
            String datetime = s.substring(s.lastIndexOf("_") + 1);
            String versionname = s.replace("_" + datetime, "");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
            Map<String, String> map1 = new HashMap();
            map1.put("versionname", versionname);
            map1.put("datetime", sd);
            map1.put("username", username);
            map1.put("filename", f[i].getName());
            list.add(map1);
         }
      }

      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/setBatchEncryption"})
   public Response setBatchEncryption(@RequestBody Map<String, String> params) {
      this.dataareaSecretkeyRelationService.setBatchEncryption(params);
      return RespHelper.successResp();
   }

   @ResponseBody
   @RequestMapping({"/setBatchClassifyEncryption"})
   public Response setBatchClassifyEncryption(@RequestBody Map<String, String> params) {
      this.dataareaSecretkeyRelationService.setBatchClassifyEncryption(params);
      return RespHelper.successResp();
   }

   @ResponseBody
   @RequestMapping({"/setdefault"})
   public Response setdefault(@RequestBody Map<String, String> map) {
      String relationid = (String)map.get("relationid");
      this.dataareaSecretkeyRelationService.setdefault(relationid);
      return RespHelper.successResp();
   }
}
