package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImpl;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImplService;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBeanDetail;
import com.chenyang.nse.bussiness.entity.orm.table.core.ImportMaskingExecute;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationselftask.DesensitizationSelfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationselftask.TCoreMonitorTmporary;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.EncryptionMasking;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.DesensitizationMonitorVO;
import com.chenyang.nse.bussiness.entity.vo.ProgressVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TCoreMonitorTmporaryVO;
import com.chenyang.nse.bussiness.service.core.DesensitizationMonitorService;
import com.chenyang.nse.bussiness.service.core.DesensitizationselftaskService;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskService;
import com.chenyang.nse.bussiness.service.core.EncryptionMaskingService;
import com.chenyang.nse.bussiness.service.core.ImportDesensitizationtaskService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.TCoreMonitorTmporaryService;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/desensitizationmonitor"})
public class DesensitizationMonitorController {
   private static Logger logger = LoggerFactory.getLogger(DesensitizationMonitorController.class);
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationtaskService desensitizationtaskService;
   @Autowired
   private ImportDesensitizationtaskService importDesensitizationtaskService;
   @Autowired
   private DesensitizationselftaskService desensitizationSelfTaskService;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private DesensitizationMonitorService desensitizationMonitorService;
   @Autowired
   private DesensitizationselftaskService desensitizationselftaskService;
   @Autowired
   private TCoreMonitorTmporaryService tCoreMonitorTmporaryService;
   @Autowired
   private EncryptionMaskingService encryptionMaskingService;
   @Autowired
   private EncryptionMaskingService encryptionmaskingService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/desensitizationmonitor/monitortask";
   }

   @RequestMapping({"/monitortaskselflog"})
   public String monitortaskselflog(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/desensitizationmonitor/monitortaskselflog";
   }

   @ResponseBody
   @RequestMapping({"/querytasklist"})
   public List<Desensitizationtask> querytasklist(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Desensitizationtask> list = this.desensitizationtaskService.queryTaskAll();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/querytasklistByPage"})
   public DataGridVO<Desensitizationtask> querytasklistByPage(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Desensitizationtask> list = this.desensitizationtaskService.queryTaskByPage(pageInfo);
      DataGridVO<Desensitizationtask> vo = new DataGridVO<Desensitizationtask>(pageInfo.getCount(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/querytmporary"})
   public DataGridVO<DesensitizationMonitorVO> querytmporary(String taskid, String groupid, Integer indexrow, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if (taskid != null && !"".equals(taskid)) {
         if (groupid != null && !"".equals(groupid)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            long ts = 0L;

            try {
               Date date = sdf.parse(groupid);
               ts = date.getTime();
            } catch (ParseException e) {
               e.printStackTrace();
            }

            String res = String.valueOf(ts);
            String masking_engine_type = "";
            this.desensitizationtaskService.querySourceInfo(taskid);
            this.desensitizationtaskService.queryTargetById(taskid);
            this.desensitizationtaskService.queryTaskById(taskid);
            this.desensitizationtaskService.queryDesensitizationfileBytaskid(taskid);

            try {
               masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
            } catch (IOException e) {
               e.printStackTrace();
            }

            List<DesensitizationMonitor> list = null;
            if ("1".equals(masking_engine_type)) {
               list = this.desensitizationMonitorService.queryTaskLogMonitor(taskid, res, pageInfo, indexrow);
            } else {
               list = this.desensitizationMonitorService.queryTaskMonitor(taskid, res, pageInfo, indexrow);
            }

            Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
            List<DesensitizationMonitorVO> listVo = new ArrayList();

            for(DesensitizationMonitor desensitizationMonitor : list) {
               DesensitizationMonitorVO desensitizationMonitorVO = new DesensitizationMonitorVO();
               desensitizationMonitorVO.setSourcename(desensitizationMonitor.getSourcename());
               desensitizationMonitorVO.setTargetname(desensitizationMonitor.getTargetname());
               desensitizationMonitorVO.setTasktype(desensitizationMonitor.getTasktype());
               desensitizationMonitorVO.setExecutetime(desensitizationMonitor.getExecutetime());
               desensitizationMonitorVO.setFlag(desensitizationMonitor.getFlag());
               desensitizationMonitorVO.setRunstatus(desensitizationMonitor.getRunstatus());
               desensitizationMonitorVO.setId(desensitizationMonitor.getId());
               desensitizationMonitorVO.setTaskid(desensitizationMonitor.getTaskid());
               desensitizationMonitorVO.setGroupid(desensitizationMonitor.getGroupid());
               desensitizationMonitorVO.setNote(desensitizationMonitor.getNote());
               desensitizationMonitorVO.setRunid(desensitizationMonitor.getRunid());
               desensitizationMonitorVO.setIsRecoverState("1".equals(task.getIsrecover()) ? "1" : "0");
               listVo.add(desensitizationMonitorVO);
            }

            DataGridVO<DesensitizationMonitorVO> vo = new DataGridVO<DesensitizationMonitorVO>(pageInfo.getCount(), listVo);
            return vo;
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytmporaryself"})
   public DataGridVO<TCoreMonitorTmporaryVO> querytmporaryself(String taskid, String groupid, Integer indexrow, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if (taskid != null && !"".equals(taskid)) {
         if (groupid != null && !"".equals(groupid)) {
            String res = String.valueOf(groupid);
            String masking_engine_type = "";
            this.desensitizationtaskService.querySourceInfo(taskid);
            Desensitizationtarget desensitizationtarget = this.desensitizationtaskService.queryTargetById(taskid);
            this.desensitizationtaskService.queryDesensitizationfileBytaskid(taskid);

            try {
               masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
            } catch (IOException e) {
               e.printStackTrace();
            }

            List<DesensitizationMonitor> list = null;
            List<TCoreMonitorTmporary> lists = null;
            if ("1".equals(masking_engine_type)) {
               lists = this.desensitizationMonitorService.queryTaskLogMonitors(taskid, res, pageInfo, indexrow);
            } else {
               this.desensitizationMonitorService.queryTaskMonitor(taskid, res, pageInfo, indexrow);
            }

            DesensitizationSelfTask task = this.desensitizationSelfTaskService.queryTaskById(taskid);
            List<TCoreMonitorTmporaryVO> listVo = new ArrayList();

            for(TCoreMonitorTmporary tCoreMonitorTmporary : lists) {
               TCoreMonitorTmporaryVO tCoreMonitorTmporaryVO = new TCoreMonitorTmporaryVO();
               tCoreMonitorTmporaryVO.setSourcename(tCoreMonitorTmporary.getSourcename());
               tCoreMonitorTmporaryVO.setTargetname(tCoreMonitorTmporary.getTargetname());
               tCoreMonitorTmporaryVO.setType(tCoreMonitorTmporary.getType());
               tCoreMonitorTmporaryVO.setCreatetime(tCoreMonitorTmporary.getCreatetime());
               tCoreMonitorTmporaryVO.setFlag(tCoreMonitorTmporary.getFlag());
               tCoreMonitorTmporaryVO.setJdbar(tCoreMonitorTmporary.getJdbar());
               tCoreMonitorTmporaryVO.setId(tCoreMonitorTmporary.getId());
               tCoreMonitorTmporaryVO.setTaskid(tCoreMonitorTmporary.getTaskid());
               tCoreMonitorTmporaryVO.setGroupid(tCoreMonitorTmporary.getGroupid());
               tCoreMonitorTmporaryVO.setNote(tCoreMonitorTmporary.getNote());
               tCoreMonitorTmporaryVO.setRunid(tCoreMonitorTmporary.getRunid());
               tCoreMonitorTmporaryVO.setInserttype(desensitizationtarget.getInserttype());
               tCoreMonitorTmporaryVO.setIsRecoverState("1".equals(task.getIsrecover()) ? "1" : "0");
               String structureid = "";
               int fieldcount = 0;
               int maskingfieldcount = 0;
               String tablename = tCoreMonitorTmporaryVO.getSourcename();

               for(DesensitizationTablecolumn column : this.desensitizationtaskService.queryColumInfo(taskid, tablename)) {
                  if (!"".equals(column.getColumnname()) && column.getColumnname() != null) {
                     ++fieldcount;
                  }

                  if (!"".equals(column.getRulename()) && column.getRulename() != null) {
                     ++maskingfieldcount;
                  }
               }

               tCoreMonitorTmporaryVO.setFieldcount(fieldcount);
               tCoreMonitorTmporaryVO.setMaskingfieldcount(maskingfieldcount);
               listVo.add(tCoreMonitorTmporaryVO);
            }

            DataGridVO<TCoreMonitorTmporaryVO> vo = new DataGridVO<TCoreMonitorTmporaryVO>(pageInfo.getCount(), listVo);
            return vo;
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytmporaryem"})
   public DataGridVO<DesensitizationMonitorVO> querytmporaryEM(String taskid, String groupid, Integer indexrow, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if (taskid != null && !"".equals(taskid)) {
         if (groupid != null && !"".equals(groupid)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            long ts = 0L;

            try {
               Date date = sdf.parse(groupid);
               ts = date.getTime();
            } catch (ParseException e) {
               e.printStackTrace();
            }

            String res = String.valueOf(ts);
            String masking_engine_type = "";

            try {
               masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
            } catch (IOException e) {
               e.printStackTrace();
            }

            List<DesensitizationMonitor> list = null;
            if ("1".equals(masking_engine_type)) {
               list = this.desensitizationMonitorService.queryTaskLogMonitor(taskid, res, pageInfo, indexrow);
            } else {
               list = this.desensitizationMonitorService.queryTaskMonitor(taskid, res, pageInfo, indexrow);
            }

            EncryptionMasking task = this.encryptionMaskingService.queryTaskById(taskid);
            List<DesensitizationMonitorVO> listVo = new ArrayList();

            for(DesensitizationMonitor desensitizationMonitor : list) {
               DesensitizationMonitorVO desensitizationMonitorVO = new DesensitizationMonitorVO();
               desensitizationMonitorVO.setSourcename(desensitizationMonitor.getSourcename());
               desensitizationMonitorVO.setTargetname(desensitizationMonitor.getTargetname());
               desensitizationMonitorVO.setTasktype(desensitizationMonitor.getTasktype());
               desensitizationMonitorVO.setExecutetime(desensitizationMonitor.getExecutetime());
               desensitizationMonitorVO.setFlag(desensitizationMonitor.getFlag());
               desensitizationMonitorVO.setRunstatus(desensitizationMonitor.getRunstatus());
               desensitizationMonitorVO.setId(desensitizationMonitor.getId());
               desensitizationMonitorVO.setTaskid(desensitizationMonitor.getTaskid());
               desensitizationMonitorVO.setGroupid(desensitizationMonitor.getGroupid());
               desensitizationMonitorVO.setNote(desensitizationMonitor.getNote());
               desensitizationMonitorVO.setRunid(desensitizationMonitor.getRunid());
               desensitizationMonitorVO.setIsRecoverState("1".equals(task.getIsrecover()) ? "1" : "0");
               listVo.add(desensitizationMonitorVO);
            }

            DataGridVO<DesensitizationMonitorVO> vo = new DataGridVO<DesensitizationMonitorVO>(pageInfo.getCount(), listVo);
            return vo;
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersionList"})
   public List<Map<String, String>> queryTaskVersionList(HttpServletRequest request, HttpServletResponse response, Model model, String taskId) {
      List list = this.desensitizationMonitorService.queryTaskVersionList(taskId);
      List<Map<String, String>> listMap = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
         long lt = new Long(list.get(i).toString());
         Date date = new Date(lt);
         String res = simpleDateFormat.format(date);
         Map<String, String> map = new HashMap();
         map.put("groupid", res);
         listMap.add(map);
      }

      return listMap;
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersion"})
   public List<Map<String, String>> queryTaskVersion(HttpServletRequest request, HttpServletResponse response, Model model, String taskId) {
      List list = this.desensitizationMonitorService.queryTaskVersionList(taskId);
      List<Map<String, String>> listMap = new ArrayList();
      String object = list.get(0).toString();
      SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
      long lt = new Long(list.get(0).toString());
      Date date = new Date(lt);
      String res = simpleDateFormat.format(date);
      Map<String, String> map = new HashMap();
      map.put("groupid", res);
      listMap.add(map);
      return listMap;
   }

   @ResponseBody
   @RequestMapping({"/querytaskobj"})
   public List<Desensitizationtask> querytaskobj(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Desensitizationtask> task = this.desensitizationtaskService.queryTaskList(taskid);
      return task;
   }

   @ResponseBody
   @RequestMapping({"/querytaskobjem"})
   public List<EncryptionMasking> querytaskobjEM(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<EncryptionMasking> task = this.encryptionMaskingService.queryTaskList(taskid);
      return task;
   }

   @ResponseBody
   @RequestMapping({"/queryimporttaskobj"})
   public List<ImportMaskingExecute> queryimporttaskobj(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ImportMaskingExecute> task = this.importDesensitizationtaskService.queryTaskList(taskid);
      return task;
   }

   @RequestMapping({"/exeTaskMonitor"})
   @ResponseBody
   public SessionBean exeTaskMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname, String monitorId) {
      Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
      new Properties();
      new SessionBean();

      SessionBean sessionbean;
      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getLogForTaskMapping(task.getFoldername(), info, task.getTasknamereal() + "_" + wfname);
      } catch (Exception var14) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      model.addAttribute("tmpid", monitorId);
      return sessionbean;
   }

   @RequestMapping({"/exeTaskMonitorEM"})
   @ResponseBody
   public SessionBean exeTaskMonitorEM(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname, String monitorId) {
      EncryptionMasking task = this.encryptionmaskingService.queryTaskById(taskid);
      new Properties();
      new SessionBean();

      SessionBean sessionbean;
      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getLogForTaskMapping(task.getFoldername(), info, task.getTasknamereal() + "_" + wfname);
      } catch (Exception var14) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      model.addAttribute("tmpid", monitorId);
      return sessionbean;
   }

   @RequestMapping({"/monitorCount"})
   @ResponseBody
   public String monitorCount(HttpServletRequest request, HttpServletResponse response, Model model, String progressid) {
      String absolutely = "60%";
      String message = "正在执行脱敏任务......";
      new Properties();
      new SessionBean();
      Map map = (Map)request.getSession().getAttribute("instantfilemasking");
      String stamp = (String)map.get("stamp");
      String folder = (String)map.get("folder");
      Long longcount = (Long)map.get("longcount");
      ProgressVO progressVO = new ProgressVO();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         SessionBean sessionbean = this.desensitizationMonitorService.getLogForMappingByInstantFile(folder, info, "s" + stamp, longcount);
         Long applied_rows = ((SessionBeanDetail)sessionbean.getSessionBeanDetail().get(0)).getApplied_rows();
         Long rejected_rows = ((SessionBeanDetail)sessionbean.getSessionBeanDetail().get(0)).getRejected_rows();
         Long run_rows = applied_rows + rejected_rows;
         if (longcount == 0L) {
            longcount = new Long(1L);
         }

         DecimalFormat df = new DecimalFormat("######0.00");
         double progressValue = (double)60.0F + (double)run_rows / (double)longcount * 0.4 * (double)100.0F;
         absolutely = df.format(progressValue);
         if (progressValue > (double)99.0F) {
            absolutely = "99";
            message = "执行脱敏任务成功并且开始压缩.........请稍等";
         }

         if ("FAILED".equals(sessionbean.getStatus())) {
            progressVO.setProgressid(progressid);
            progressVO.setProgresscontent("执行脱敏敏任务失败");
            progressVO.setProgressState(false);
            progressVO.setProgressValue(new Double((double)99.0F));
         } else {
            progressVO.setProgressid(progressid);
            progressVO.setProgresscontent(message);
            progressVO.setProgressState(true);
            progressVO.setProgressValue(new Double(absolutely));
         }

         request.getSession().setAttribute("progress", progressVO);
         return absolutely;
      } catch (Exception e) {
         System.out.println(e);
         return absolutely;
      }
   }

   @RequestMapping({"/exeImportTaskMonitor"})
   @ResponseBody
   public SessionBean exeImportTaskMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname, String monitorId) {
      ImportMaskingExecute task = this.importDesensitizationtaskService.getImportMaskingExecute(taskid);
      new Properties();
      new SessionBean();

      SessionBean sessionbean;
      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getLogForTaskMapping(task.getFoldername(), info, task.getTaskname().replace("wf_", ""));
      } catch (Exception var14) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      model.addAttribute("tmpid", monitorId);
      return sessionbean;
   }

   @ResponseBody
   @RequestMapping({"/queryInportTmporary"})
   public DataGridVO<DesensitizationMonitor> queryInportTmporary(String taskid, String groupid, Integer indexrow, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if (taskid != null && !"".equals(taskid)) {
         if (groupid != null && !"".equals(groupid)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            long ts = 0L;

            try {
               Date date = sdf.parse(groupid);
               ts = date.getTime();
            } catch (ParseException e) {
               e.printStackTrace();
            }

            String res = String.valueOf(ts);
            List<DesensitizationMonitor> list = this.desensitizationMonitorService.queryImportTaskMonitor(taskid, res, pageInfo, indexrow);
            DataGridVO<DesensitizationMonitor> vo = new DataGridVO<DesensitizationMonitor>(pageInfo.getCount(), list);
            return vo;
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   @RequestMapping({"/updateMonitorTaskState"})
   @ResponseBody
   public void updateMonitorTaskState(String monitorId, String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      DesensitizationMonitor desensitizationMonitor = this.desensitizationMonitorService.getMonitorById(monitorId);
      if ("1".equals(state) || "2".equals(state)) {
         desensitizationMonitor.setFlag(state);
         this.desensitizationMonitorService.update(desensitizationMonitor);
      }
   }

   @RequestMapping({"/stopworkflow"})
   @ResponseBody
   public ResultVO stopWorkflow(String taskid, String wfname, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
      new Properties();
      String stopWorkflow = "FAIL";

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         stopWorkflow = this.desensitizationMonitorService.stopWorkflow(info, task.getTasknamereal() + "_" + wfname, task.getFoldername());
      } catch (IOException e) {
         e.printStackTrace();
      }

      return !"FAIL".equals(stopWorkflow) ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/stopworkflowInterface"})
   @ResponseBody
   public ResultVO stopworkflowInterface(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
      new Properties();
      String stopWorkflow = "FAIL";

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         List<DesensitizationTable> tableList = this.desensitizationtaskService.queryTableList(taskid);
         HashSet<String> tablenameSet = new HashSet();

         for(int i = 0; i < tableList.size(); ++i) {
            tablenameSet.add(((DesensitizationTable)tableList.get(i)).getTablename());
         }

         for(Iterator<String> it = tablenameSet.iterator(); it.hasNext(); stopWorkflow = this.desensitizationMonitorService.stopWorkflow(info, task.getTasknamereal() + "_" + (String)it.next(), task.getFoldername())) {
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return !"FAIL".equals(stopWorkflow) ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/stopEngineWorkflowInterface"})
   @ResponseBody
   public String stopEngineWorkflowInterface(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);

      try {
         List list = this.desensitizationMonitorService.queryTaskVersionList(taskid);
         String commandlf = "ps -elf|grep \"masking-engine.jar " + task.getTasknamereal() + " \"|grep -v grep|awk  '{print \"kill -9 \" $4}' |sh";
         CommandTool.commandPipeRtn(commandlf);
         this.desensitizationtaskService.updateEngineMonitor(taskid, list.get(0).toString(), "3");
         String command = "ps -ef|grep \"masking-engine.jar " + task.getTasknamereal() + " \"|grep -v grep|awk  '{print \"kill -9 \" $2}' |sh";
         CommandTool.commandPipeRtn(command);
         this.desensitizationtaskService.updateEngineMonitor(taskid, list.get(0).toString(), "3");
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "任务停止成功";
   }

   @RequestMapping({"/recoverworkflow"})
   @ResponseBody
   public ResultVO recoverworkflow(String taskid, String wfname, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
      new Properties();
      String recoverWorkflow = "FAIL";

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         recoverWorkflow = this.desensitizationMonitorService.recoverWorkflow(info, task.getTasknamereal() + "_" + wfname, task.getFoldername());
      } catch (IOException e) {
         e.printStackTrace();
      }

      return !"FAIL".equals(recoverWorkflow) ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/querySessionLog"})
   @ResponseBody
   public SessionBean querySessionLog(String taskid, String wfname, String isLoadMore) {
      new Properties();
      SessionBean sessionbean = new SessionBean();

      try {
         Desensitizationtask task = this.desensitizationtaskService.queryTaskById(taskid);
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getSessionLog(task.getFoldername(), task.getTasknamereal() + "_" + wfname, engine);
         String[] split = sessionbean.getSe_log().split("\\n");
         StringBuffer log = new StringBuffer();

         for(int i = 0; i < split.length; ++i) {
            log.append(split[i]).append(System.getProperty("line.separator"));
            if ("0".equals(isLoadMore) && i == 5000) {
               log.append("<p style=\"text-align:center\"><a class=\"run-log\" href=\"javascript:;\" onclick=\"logDetails(1)\"  class=\"easyui-linkbutton\" data-options=\"plain:true,iconCls:\\'icon-zx\\'\">加载更多</a></p><br/>");
               break;
            }

            if ("1".equals(isLoadMore) && i == 10000) {
               break;
            }
         }

         sessionbean.setSe_log(log.toString());
         System.out.println("日志行数=" + split.length);
      } catch (IOException e) {
         e.printStackTrace();
      }

      return sessionbean;
   }

   @RequestMapping({"/querySessionLogEM"})
   @ResponseBody
   public SessionBean querySessionLogEM(String taskid, String wfname, String isLoadMore) {
      new Properties();
      SessionBean sessionbean = new SessionBean();

      try {
         EncryptionMasking task = this.encryptionmaskingService.queryTaskById(taskid);
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getSessionLog(task.getFoldername(), task.getTasknamereal() + "_" + wfname, engine);
         String[] split = sessionbean.getSe_log().split("\\n");
         StringBuffer log = new StringBuffer();

         for(int i = 0; i < split.length; ++i) {
            log.append(split[i]).append(System.getProperty("line.separator"));
            if ("0".equals(isLoadMore) && i == 5000) {
               log.append("<p style=\"text-align:center\"><a class=\"run-log\" href=\"javascript:;\" onclick=\"logDetails(1)\"  class=\"easyui-linkbutton\" data-options=\"plain:true,iconCls:\\'icon-zx\\'\">加载更多</a></p><br/>");
               break;
            }

            if ("1".equals(isLoadMore) && i == 10000) {
               break;
            }
         }

         sessionbean.setSe_log(log.toString());
         System.out.println("日志行数=" + split.length);
      } catch (IOException e) {
         e.printStackTrace();
      }

      return sessionbean;
   }

   @RequestMapping({"/queryImportSessionLog"})
   @ResponseBody
   public SessionBean queryImportSessionLog(String taskid, String wfname) {
      new Properties();
      SessionBean sessionbean = new SessionBean();

      try {
         ImportMaskingExecute task = this.importDesensitizationtaskService.getImportMaskingExecute(taskid);
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineid = props.getProperty("engineid");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> enginemap = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, enginemap);
         sessionbean = this.desensitizationMonitorService.getSessionLog(task.getFoldername(), task.getTaskname().replace("wf_", ""), engine);
      } catch (IOException e) {
         e.printStackTrace();
      }

      return sessionbean;
   }

   @RequestMapping({"/querytaskobjselflog"})
   @ResponseBody
   public List<DesensitizationSelfTask> querytaskobjselflog(String taskid) {
      List<DesensitizationSelfTask> task = this.desensitizationselftaskService.queryTaskList(taskid);
      return task;
   }

   @RequestMapping({"/querytmporarycoreindex"})
   @ResponseBody
   public List<Map<String, String>> querytmporarycoreindex(String taskid) {
      List list = this.tCoreMonitorTmporaryService.queryTaskList(taskid);
      List<Map<String, String>> listMap = new ArrayList();
      String object = list.get(0).toString();
      SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
      long lt = new Long(list.get(0).toString());
      Date date = new Date(lt);
      String res = simpleDateFormat.format(date);
      Map<String, String> map = new HashMap();
      map.put("groupid", res);
      listMap.add(map);
      return listMap;
   }

   @RequestMapping({"/exeTaskMonitorself"})
   @ResponseBody
   public SessionBean exeTaskMonitorself(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname, String monitorId, Long groupid, String logType) {
      DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
      DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
      DesensitizationSelfTask task = (DesensitizationSelfTask)this.desensitizationselftaskService.queryTaskList(taskid).get(0);
      SessionBean sessionbean = new SessionBean();
      List<SessionBeanDetail> sessionBeanDetailList = new ArrayList();

      try {
         new ArrayList();
         StringBuffer sbr = new StringBuffer();
         List e = engineInterfaceImpl.readFileToPage(task.getTasknamereal(), wfname, logType, groupid);
         int sucCnt = 0;
         if ("PU".equals(logType)) {
            if (e.size() > 0 && e != null) {
               for(int i = 0; i < e.size(); ++i) {
                  String[] str = e.get(i).toString().split("#\\|\\|#");
                  SessionBeanDetail sessionBeanDetail = new SessionBeanDetail();
                  sessionBeanDetail.setWidgetInstanceName(str[0]);
                  sessionBeanDetail.setTablename(str[0]);
                  if (str[1].equals("1")) {
                     ++sucCnt;
                  } else if (str[1].equals("0")) {
                     sessionbean.setStatus("RUNNING");
                  } else {
                     sessionbean.setStatus("FAIL");
                  }

                  sessionbean.setStart_time(str[2]);
                  sessionbean.setEnd_time(str[3]);
                  sessionBeanDetail.setApplied_rows(Long.parseLong(str[4]));
                  sessionBeanDetail.setAffected_rows(Long.parseLong(str[5]));
                  sessionBeanDetail.setRejected_rows(Long.parseLong(str[6]));
                  DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                  Long startdate = dateFormat.parse(str[2]).getTime();
                  long throughput = 0L;
                  if (str[1].equals("0")) {
                     throughput = Long.parseLong(str[5]) / (((new Date()).getTime() - startdate) / 1000L);
                     sessionBeanDetail.setThroughput(String.valueOf(throughput));
                  } else {
                     sessionBeanDetail.setThroughput(str[7]);
                  }

                  sessionBeanDetail.setTabletype(str[8]);
                  sessionBeanDetailList.add(sessionBeanDetail);
               }

               if (2 == sucCnt) {
                  sessionbean.setStatus("SUCCEEDED");
               }
            }
         } else if (e.size() > 0 && e != null) {
            for(int i = 0; i < e.size(); ++i) {
               String[] str = e.get(i).toString().split("#\\|\\|#");
               if (i == 2) {
                  sessionbean.setStart_time(str[2]);
                  sessionbean.setEnd_time(str[3]);
               }

               if (i > 1) {
                  SessionBeanDetail sessionBeanDetail = new SessionBeanDetail();
                  sessionBeanDetail.setWidgetInstanceName(str[0]);
                  sessionBeanDetail.setTablename(str[0]);
                  sbr.append(str[1]);
                  sessionBeanDetail.setApplied_rows(Long.parseLong(str[4]));
                  sessionBeanDetail.setAffected_rows(Long.parseLong(str[5]));
                  sessionBeanDetail.setRejected_rows(Long.parseLong(str[6]));
                  DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                  Long startdate = dateFormat.parse(str[2]).getTime();
                  long throughput = Long.parseLong(str[5]) / (((new Date()).getTime() - startdate) / 1000L);
                  if (str[1].equals("0")) {
                     sessionBeanDetail.setThroughput(String.valueOf(throughput));
                  } else {
                     sessionBeanDetail.setThroughput("0");
                  }

                  sessionBeanDetail.setTabletype(str[8]);
                  sessionBeanDetailList.add(sessionBeanDetail);
               }
            }

            if (sbr.toString().contains("2")) {
               sessionbean.setStatus("FAIL");
            } else if (sbr.toString().contains("0")) {
               sessionbean.setStatus("RUNNING");
            } else {
               sessionbean.setStatus("SUCCEEDED");
            }
         }

         sessionbean.setSessionBeanDetail(sessionBeanDetailList);
      } catch (Exception e) {
         e.printStackTrace();
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      model.addAttribute("tmpid", monitorId);
      return sessionbean;
   }

   @RequestMapping({"/querySessionLogself"})
   @ResponseBody
   public SessionBean querySessionLogself(String taskid, String wfname, String monitorId, Long groupid, String logType, String isLoadMore) {
      DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
      DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
      DesensitizationSelfTask task = this.desensitizationselftaskService.queryTaskById(taskid);
      SessionBean sessionbean = new SessionBean();
      List list = engineInterfaceImpl.readFileToPage(task.getTasknamereal(), wfname, logType, groupid);
      StringBuffer logLine = new StringBuffer();

      for(int i = 0; i < list.size(); ++i) {
         logLine.append(list.get(i)).append(System.getProperty("line.separator"));
         if ("0".equals(isLoadMore) && i == 5000) {
            logLine.append("<p style=\"text-align:center\"><a class=\"run-log\" href=\"javascript:;\" onclick=\"logDetails(1)\"  class=\"easyui-linkbutton\" data-options=\"plain:true,iconCls:\\'icon-zx\\'\">加载更多</a></p><br/>");
            break;
         }

         if ("1".equals(isLoadMore) && i == 10000) {
            break;
         }
      }

      sessionbean.setSe_log(logLine.toString());
      System.out.println("日志行数=" + list.size());
      return sessionbean;
   }
}
