package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskSerialService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.service.info.db.DatabaseTool;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.system.SysUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import transdbf.transdbf;

@EnableAsync
@Controller
@RequestMapping({"/core/desensitizationtaskserial"})
public class DesensitizationSerialController {
   private static Logger logger = LoggerFactory.getLogger(DesensitizationController.class);
   private static final String Link_character = "_";
   public static final String DB_pwc_FILE_batchwrite_DB = "DBtoDB,normal,batchwrite";
   public static final String DB_batchread_FILE_pwc_DB = "DBtoDB,batchread,normal";
   public static final String DB_batchread_FILE_pwc_FILE_batchwrite_DB = "DBtoDB,batchread,batchwrite";
   public static final String DB_pwc_DB = "DBtoDB,normal,normal";
   public static final String DB_pwc_FILE = "DBtoFILE,normal";
   public static final String DB_batchread_FILE_pwc_FILE = "DBtoFILE,batchread";
   public static final String FILE_pwc_FILE_batchwrite_DB = "FILEtoDB,batchwrite";
   public static final String FILE_pwc_DB = "FILEtoDB,normal";
   public static final String FILE_pwc_FILE = "FILEtoFILE";
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DesensitizationtaskSerialService desensitizationtaskSerialService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private RedisService redisService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/desensitizationtaskserial/desensitizationtaskseriallist";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<Desensitizationtask> querytask(String engineid, String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Desensitizationtask> list = this.desensitizationtaskSerialService.queryTask(taskname, pageInfo);

      for(Desensitizationtask desensitizationtask : list) {
         String tasknamereal = desensitizationtask.getTasknamereal();
         if (!desensitizationtask.getSave_state().equals("0")) {
            if (desensitizationtask.getSave_state().equals("1")) {
               desensitizationtask.setCount_exe("");
            } else {
               desensitizationtask.setCount_exe("100%");
            }

            this.redisService.remove(tasknamereal + "_zcount");
            this.redisService.remove(tasknamereal + "_ncount");
         } else {
            String time_exe = (String)this.redisService.get(tasknamereal + "_ntime");
            String count_exe = (String)this.redisService.get(tasknamereal + "_zcount");
            String ncount_exe = (String)this.redisService.get(tasknamereal + "_ncount");
            long ncount_exe_num = 0L;
            long count_exe_num = 1L;

            try {
               if (ncount_exe == null) {
                  ncount_exe = "0";
               }

               if (count_exe == null) {
                  count_exe = "1";
               }

               ncount_exe_num = new Long(ncount_exe);
               count_exe_num = new Long(count_exe);
            } catch (Exception var22) {
            }

            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            String result = numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
            desensitizationtask.setCount_exe(result + "%");
         }
      }

      DataGridVO<Desensitizationtask> vo = new DataGridVO<Desensitizationtask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("tasknamereal", (String)this.request.getSession().getAttribute("tasknamereal"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "desensitizationtaskserial_one":
            this.desensitizationtaskserial_one(map, model);
            break;
         case "desensitizationtaskserial_two":
            this.desensitizationtaskserial_two(map, model);
            break;
         case "desensitizationtaskserial_two_file":
            this.desensitizationtaskserial_two_file(map, model);
            break;
         case "desensitizationtaskserial_three":
            this.desensitizationtaskserial_three(map, model);
            break;
         case "desensitizationtaskserial_three_file":
            this.desensitizationtaskserial_three_file(map, model);
            break;
         case "desensitizationtaskserial_four":
            String sourceType = this.source_type(map);
            if (sourceType.equals("db")) {
               step = "desensitizationtaskserial_four";
            } else if (sourceType.equals("file")) {
               step = "desensitizationtaskserial_four_file";
            }

            this.desensitizationtaskserial_four(map, model);
            break;
         case "desensitizationtaskserial_five":
            this.request.getSession().setAttribute("page_five", map.get("pageparam"));
      }

      return "core/desensitizationtaskserial/" + step;
   }

   @RequestMapping({"/exportway"})
   @ResponseBody
   public String exportway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ExportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/importway"})
   @ResponseBody
   public String importway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ImportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/targetparam"})
   @ResponseBody
   public Map<String, String> targetparam(String database, String execution_type, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      Map<String, String> targetparam = new HashMap();
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         if (execution_type.equals("normal")) {
            targetparam = base.TargetParameter_normal();
         } else {
            targetparam = base.TargetParameter_notNormal();
         }
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return targetparam;
   }

   public void desensitizationtaskserial_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String tasknamereal = (String)map.get("tasknamereal");
      if (newtask != null) {
         model.addAttribute("state", "checked");
      } else {
         Desensitizationtask desensitizationtask = new Desensitizationtask();
         desensitizationtask = (Desensitizationtask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
         model.addAttribute("taskname", desensitizationtask.getTaskname());
         model.addAttribute("folder", desensitizationtask.getFoldername());
         model.addAttribute("tasknote", desensitizationtask.getRemark());
         model.addAttribute("isrecover", desensitizationtask.getIsrecover());
         model.addAttribute("state", desensitizationtask.getFastexecution() != null && desensitizationtask.getFastexecution().equals("1") ? "checked" : "");
      }

   }

   public void desensitizationtaskserial_two(Map<String, String> map, Model model) {
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         model.addAttribute("dataschema", desensitizationsource.getDataschema());
         model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
         model.addAttribute("execution_type", desensitizationsource.getExecution_type());
         desensitizationtask.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         desensitizationtask.setIsrecover(map.get("isrecover") == null ? "0" : (String)map.get("isrecover"));
         desensitizationtask.setFastexecution((String)map.get("isfast"));
         desensitizationtask.setFoldername((String)map.get("folder"));
         desensitizationtask.setTaskname((String)map.get("taskname"));
         desensitizationtask.setUserid((String)map.get("userid"));
         desensitizationtask.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         desensitizationtask.setRemark((String)map.get("tasknote"));
         desensitizationtask.setStamp(stamp);
         desensitizationtask.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + desensitizationtask.getClass().getSimpleName(), desensitizationtask);
         this.request.getSession().setAttribute("isrecoverState", map.get("isrecover") == null ? "0" : map.get("isrecover"));
         this.request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      }

   }

   public void desensitizationtaskserial_two_file(Map<String, String> map, Model model) {
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         String datasourceid = desensitizationsource.getDatasourceid();
         String filesystemlocation = "";
         if (datasourceid != null && !datasourceid.equals("")) {
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
            String dbtype = tCoreDatasystem.getDbtype();
            if (dbtype.equals("FTP")) {
               filesystemlocation = "1";
            } else if (dbtype.equals("SFTP")) {
               filesystemlocation = "2";
            }
         } else {
            filesystemlocation = "0";
         }

         model.addAttribute("filesystemid", desensitizationsource.getDataschema());
         model.addAttribute("filesystemlocation", filesystemlocation);
         model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
         model.addAttribute("datasourceid", datasourceid);
         desensitizationtask.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         desensitizationtask.setFastexecution((String)map.get("isfast"));
         desensitizationtask.setFoldername((String)map.get("folder"));
         desensitizationtask.setTaskname((String)map.get("taskname"));
         desensitizationtask.setUserid((String)map.get("userid"));
         desensitizationtask.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         desensitizationtask.setRemark((String)map.get("tasknote"));
         desensitizationtask.setStamp(stamp);
         desensitizationtask.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + desensitizationtask.getClass().getSimpleName(), desensitizationtask);
         this.request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      }

   }

   public void desensitizationtaskserial_three(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget != null) {
            model.addAttribute("dataschema", desensitizationtarget.getDataschema());
            model.addAttribute("datasourceid", desensitizationtarget.getDatasourceid());
            model.addAttribute("execution_type", desensitizationtarget.getExecution_type());
            model.addAttribute("inserttype", desensitizationtarget.getInserttype());
            model.addAttribute("isclear", desensitizationtarget.getIsclear());
            model.addAttribute("isindex", desensitizationtarget.getIsindex());
            model.addAttribute("isprimary", desensitizationtarget.getIsprimary());
            model.addAttribute("isrebuild", desensitizationtarget.getIsrebuild());
         }
      } else if (((String)map.get("way")).equals("next")) {
         if ("0".equals(map.get("s-systemtype"))) {
            Desensitizationsource desensitizationsource = new Desensitizationsource();
            desensitizationsource.setDataschema((String)map.get("dataschema"));
            desensitizationsource.setDatasourceid((String)map.get("datasourceid"));
            desensitizationsource.setExecution_type((String)map.get("execution_type"));
            this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
            model.addAttribute("isrebuild", "isrebuild");
            model.addAttribute("isclear", "isclear");
         } else if ("1".equals(map.get("s-systemtype"))) {
            Desensitizationsource desensitizationsource = new Desensitizationsource();
            desensitizationsource.setDataschema((String)map.get("filesystemid"));
            if ("1".equals(map.get("filesystemlocation"))) {
               String filesystemftp = (String)map.get("filesystemftp");
               desensitizationsource.setDatasourceid(filesystemftp);
            } else if ("2".equals(map.get("filesystemlocation"))) {
               String filesystemsftp = (String)map.get("filesystemsftp");
               desensitizationsource.setDatasourceid(filesystemsftp);
            }

            model.addAttribute("isrebuild", "isrebuild");
            model.addAttribute("isclear", "isclear");
            desensitizationsource.setExecution_type("normal");
            desensitizationsource.setSourcefiledir((String)map.get("sourcefiledir"));
            this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
         }
      } else {
         model.addAttribute("isrebuild", "isrebuild");
         model.addAttribute("isclear", "isclear");
      }

   }

   public void desensitizationtaskserial_three_file(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         model.addAttribute("filesystemlocation", desensitizationfile.getFiletype());
         if (desensitizationfile.getFiletype() == 1) {
            model.addAttribute("filesystemftp", desensitizationtarget.getDatasourceid());
         } else if (desensitizationfile.getFiletype() == 2) {
            model.addAttribute("filesystemsftp", desensitizationtarget.getDatasourceid());
         }

         model.addAttribute("filesystempath", desensitizationfile.getFiledir());
         model.addAttribute("filesystemextension", desensitizationfile.getSuffix());
         model.addAttribute("filesystemcodepage", desensitizationfile.getCodepage());
         model.addAttribute("filesystemcolumnformat", desensitizationfile.getDateformat());
         String delimiters = desensitizationfile.getDelimiters();
         if (!delimiters.equals(",") && !delimiters.equals(";") && !delimiters.equals("|")) {
            model.addAttribute("delimiters", "other");
            model.addAttribute("order_delimiters", delimiters);
         } else {
            model.addAttribute("delimiters", delimiters);
         }

         model.addAttribute("quotecharacter", desensitizationfile.getQuotecharacter());
      }

   }

   public void desensitizationtaskserial_four(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         model.addAttribute("way", "prev");
         new Desensitizationsource();
         Desensitizationsource filterMap = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
         if (filterMap != null) {
            model.addAttribute("group", filterMap.getDataschema());
         }

         new Desensitizationtarget();
         Desensitizationtarget desensitizationsource = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + "Desensitizationtarget");
         if (desensitizationsource != null) {
            model.addAttribute("group", desensitizationsource.getDataschema());
         }

         if (filterMap.getDatasourceid() != null && !filterMap.getDatasourceid().equals("")) {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(filterMap.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
               model.addAttribute("mappingEditFlag", "dbsystem_diff");
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         model.addAttribute("isshow", "1");
      } else if (((String)map.get("way")).equals("next")) {
         Map<String, String> filterMap = new HashMap();
         this.request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", filterMap);
         new Desensitizationsource();
         Desensitizationsource var25 = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
         if (((String)map.get("s-systemtype")).equals("0")) {
            List<Map<String, String>> tableList = new ArrayList();
            if (var25.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(var25.getDatasourceid()).getFlag().equals("2")) {
               for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(var25.getDatasourceid(), var25.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getTablename());
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            } else {
               for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(var25.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getFilestructurename());
                  tableMap.put("structureid", dbTableVO.getId());
                  tableMap.put("filedir", "");
                  tableMap.put("filename", "");
                  tableMap.put("extension", "");
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            }

            this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDataschema((String)map.get("dataschema"));
            desensitizationtarget.setDatasourceid((String)map.get("datasourceid"));
            desensitizationtarget.setExecution_type((String)map.get("execution_type"));
            desensitizationtarget.setInserttype((String)map.get("inserttype"));
            desensitizationtarget.setIsclear((String)map.get("isclear"));
            desensitizationtarget.setIsindex((String)map.get("isindex"));
            desensitizationtarget.setIsprimary((String)map.get("isprimary"));
            desensitizationtarget.setIsrebuild((String)map.get("isrebuild"));
            this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
            if (var25.getDatasourceid() != null && !var25.getDatasourceid().equals("")) {
               TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(var25.getDatasourceid());
               TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else if (((String)map.get("s-systemtype")).equals("1")) {
            String filesystemlocation = (String)map.get("filesystemlocation");
            String datasourceid = "";
            if (filesystemlocation.equals("1")) {
               datasourceid = (String)map.get("filesystemftp");
            } else if (filesystemlocation.equals("2")) {
               datasourceid = (String)map.get("filesystemsftp");
            }

            String filesystempath = (String)map.get("filesystempath");
            String filesystemextension = (String)map.get("filesystemextension");
            String filesystemcodepage = (String)map.get("filesystemcodepage");
            String filesystemcolumnformat = (String)map.get("filesystemcolumnformat");
            String delimiters = (String)map.get("delimiters");
            if (delimiters.equals("other")) {
               delimiters = (String)map.get("order_delimiters");
            }

            String quotecharacter = (String)map.get("quotecharacter");
            DesensitizationFile desensitizationfile = new DesensitizationFile();
            desensitizationfile.setFiletype(Integer.parseInt(filesystemlocation));
            if (!filesystemlocation.equals("0")) {
               TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
               desensitizationfile.setIp(tCoreDatasystem.getDbip());
               desensitizationfile.setPort(tCoreDatasystem.getDbport());
               desensitizationfile.setUsername(tCoreDatasystem.getUsername());
               desensitizationfile.setUserpassword(tCoreDatasystem.getPassword());
            }

            desensitizationfile.setFiledir(filesystempath);
            desensitizationfile.setCodepage(filesystemcodepage);
            desensitizationfile.setSuffix(filesystemextension);
            desensitizationfile.setDateformat(filesystemcolumnformat);
            desensitizationfile.setDelimiters(delimiters);
            desensitizationfile.setQuotecharacter(quotecharacter);
            this.redisService.set(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName(), desensitizationfile);
            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDatasourceid(datasourceid);
            desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDatasourceid(datasourceid);
            desensitizationtarget.setExecution_type("normal");
            this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
            List<Map<String, String>> tableList = new ArrayList();
            if (var25.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(var25.getDatasourceid()).getFlag().equals("2")) {
               for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(var25.getDatasourceid(), var25.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getTablename());
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            } else {
               for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(var25.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getFilestructurename());
                  tableMap.put("structureid", dbTableVO.getId());
                  tableMap.put("filedir", "");
                  tableMap.put("filename", "");
                  tableMap.put("extension", "");
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            }

            this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         model.addAttribute("isshow", "0");
      }

   }

   @RequestMapping({"/querytasktype"})
   @ResponseBody
   public List<ComboboxVO> querytasktype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(EmaskingTaskType e : EmaskingTaskType.values()) {
         ComboboxVO c = new ComboboxVO(e.getFlag(), e.getMaskingtype());
         list.add(c);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryfolder"})
   public List<Map<String, String>> queryfolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> folder = this.infoService.queryFolderList(engineid);
      List<Map<String, String>> list = new ArrayList();

      for(String item : folder) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroups"})
   public List<ComboboxVO> querysensitivegroups(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.searchRegexService.querySensitiveGroups();
   }

   @RequestMapping({"/executepubtask"})
   public String executepubtask(String taskid, String engineid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorrun";
      } else if ("2".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorimptask";
      } else if ("3".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorsubtask";
      } else {
         return "";
      }
   }

   @ResponseBody
   @RequestMapping({"/savetask"})
   public Map<String, String> savetask(String tableName, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      request.getSession().setAttribute("tasknamerealTableOrder", tableName);
      Map<String, String> map = new HashMap();
      if (tasknamereal == null) {
         map.put("state", "1");
      } else {
         String taskid = this.desensitizationtaskSerialService.gettaskBytasknamereal(tasknamereal);
         map.put("state", taskid);
      }

      return map;
   }

   @RequestMapping({"/savetask_info"})
   public String savetask_info(String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String tableName = (String)request.getSession().getAttribute("tasknamerealTableOrder");
      Map<String, Object> map = new HashMap();
      Object obj = request.getSession().getAttribute("loginUser");
      Map<String, String> map_table_filterConditions = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      map.put("state", state);
      map.put("loginUser", obj);
      map.put("map_table_filterConditions", map_table_filterConditions);
      map.put("tableList", request.getSession().getAttribute("tableList_" + tasknamereal));
      if (!state.equals("1")) {
         this.desensitizationtaskSerialService.savetask_info(tasknamereal, map, tableName);
      }

      request.getSession().removeAttribute("tableList_" + tasknamereal);
      request.getSession().removeAttribute("tasknamereal");
      return "core/desensitizationtaskserial/desensitizationtaskseriallist";
   }

   @ResponseBody
   @RequestMapping({"/querytaskdetail"})
   public Map<String, Object> querytaskdetail(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      if (taskid != null && !taskid.equals("")) {
         tasknamereal = "";
      }

      Map<String, Object> map = new HashMap();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      desensitizationtask = (Desensitizationtask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
      if (desensitizationtask == null) {
         desensitizationtask = this.desensitizationtaskSerialService.queryTaskById(taskid);
      }

      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         desensitizationsource = this.desensitizationtaskSerialService.querySourceInfo(taskid);
      }

      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         desensitizationtarget = this.desensitizationtaskSerialService.queryTargetById(taskid);
      }

      map.put("desensitizationtask", desensitizationtask);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationtarget);
      if (desensitizationsource.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         if (desensitizationfile == null) {
            desensitizationfile = this.desensitizationtaskSerialService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String, String>> var28 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      if (var28 != null) {
         var28 = (List)var28.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
      } else {
         var28 = new ArrayList();

         for(DesensitizationTable desensitizationTable : this.desensitizationtaskSerialService.queryTableList(taskid)) {
            Map<String, String> desensitizationTablemap = new HashMap();
            desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
            var28.add(desensitizationTablemap);
         }
      }

      map.put("tCoreMaskingTaskTableList", var28);
      return map;
   }

   @RequestMapping({"/inittasktable"})
   @ResponseBody
   public DataGridVO<DBTableVO> inittabledg(HttpServletRequest request, String tableNamePattern, Model model, String status) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();
      List<Map<String, String>> tableList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      if ("0".equals(status)) {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            list.add(dbTableVO);
         }
      } else {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            if (!status.equals("1") || !"0".equals(map.get("status")) && !"1".equals(map.get("status"))) {
               if (!status.equals("2") || !"2".equals(map.get("status")) && !"3".equals(map.get("status"))) {
                  if (!status.equals("3") || !"0".equals(map.get("status")) && !"2".equals(map.get("status"))) {
                     if (status.equals("4") && ("1".equals(map.get("status")) || "3".equals(map.get("status")))) {
                        dbTableVO.setTablename((String)map.get("tableName"));
                        dbTableVO.setStatus((String)map.get("status"));
                        list.add(dbTableVO);
                     }
                  } else {
                     dbTableVO.setTablename((String)map.get("tableName"));
                     dbTableVO.setStatus((String)map.get("status"));
                     list.add(dbTableVO);
                  }
               } else {
                  dbTableVO.setTablename((String)map.get("tableName"));
                  dbTableVO.setStatus((String)map.get("status"));
                  list.add(dbTableVO);
               }
            } else {
               dbTableVO.setTablename((String)map.get("tableName"));
               dbTableVO.setStatus((String)map.get("status"));
               list.add(dbTableVO);
            }
         }
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/inputtable"})
   public String inputmulti(String flag, String title, String multivalue, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tableName = title;
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationsource = this.desensitizationtaskSerialService.querySourceInfo(taskid);
      }

      String filedir = desensitizationsource.getSourcefiledir();
      String filename = "";
      String extension = ".txt";

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         if (tableName.equals(map.get("tableName"))) {
            if (((String)map.get("status")).equals("1")) {
               filedir = (String)map.get("filedir");
               filename = (String)map.get("filename");
               extension = (String)map.get("extension");
            }
            break;
         }
      }

      model.addAttribute("title", title);
      model.addAttribute("multivalue", multivalue);
      model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
      model.addAttribute("isfile", desensitizationsource.getDatasourceid() == null);
      model.addAttribute("dataschema", desensitizationsource.getDataschema());
      model.addAttribute("filedir", filedir);
      model.addAttribute("filename", filename);
      model.addAttribute("extension", extension);
      String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
      DesensitizationTable desensitizationTable = this.desensitizationtaskSerialService.queryTableByTableName(taskid, multivalue);
      if (desensitizationTable != null) {
         model.addAttribute("sqlFilter", desensitizationTable.getSqlFilter().replaceAll("'", "\\\\'"));
      } else {
         String sqlFilter = "";
         Map map = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
         if (!"".equals((String)map.get(multivalue)) && (String)map.get(multivalue) != null) {
            sqlFilter = ((String)map.get(multivalue)).replaceAll("'", "\\\\'");
         } else {
            sqlFilter = (String)map.get(multivalue);
         }

         model.addAttribute("sqlFilter", sqlFilter);
      }

      return "core/desensitizationtaskserial/" + flag;
   }

   @ResponseBody
   @RequestMapping({"/checkWhereStatement"})
   public ResultVO checkWhereStatement(String dataSystemId, String schema, String whereStatements, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dataSystemId);
      this.iskeberos(datasystem);
      Connection conn = JdbcTool.getConnection(datasystem);
      String[] tempArr = whereStatements.split(":");
      if (tempArr.length != 2) {
         return new ResultVO("过滤条件格式不正确！", false);
      } else {
         String sql = MessageFormat.format("select * from {0}.{1} where {2}", schema, tempArr[0], tempArr[1]);

         try {
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            statement.close();
         } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return new ResultVO(tempArr[0] + ": " + e.getMessage(), false);
         }

         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return new ResultVO((String)null, true);
      }
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/querycolumninfodiff"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfodiff(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         return null;
      } else {
         String datasystemid = id.replace(tablename, "");
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(datasystemid);
         if (tCoreDatasystemSource == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            Map<String, String> targetFieldNameMap = new HashMap();

            for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
               String targetName = "";
               String fieldname = desensitizationDataTargetfield.getFieldname();

               for(Map<String, String> map : map_t) {
                  if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
                     targetName = ((String)map.get("sourcefieldname")).toLowerCase();
                     break;
                  }
               }

               targetFieldNameMap.put(fieldname, targetName);
            }

            Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
            List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);
            List<ColumnInfoVO> list1 = new ArrayList();
            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               for(ColumnInfoVO civ : list) {
                  if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                     civ.setDecimaldigits("");
                  }

                  list1.add(civ);
               }

               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
                  new ArrayList();
                  List<TCoreMaskingTaskTableInfo> var32 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
                  if (var32 != null) {
                     for(ColumnInfoVO civ : list1) {
                        for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var32) {
                           if (civ.getColumnname().equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                              civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                              break;
                           }
                        }
                     }
                  }
               } else {
                  for(ColumnInfoVO civ : list1) {
                     for(Map<String, String> map : map_s) {
                        if (civ.getTypename().toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                           civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                           break;
                        }
                     }
                  }
               }
            } else if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
               new ArrayList();
               List<TCoreMaskingTaskTableInfo> var34 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
               if (var34 != null) {
                  for(ColumnInfoVO civ : list) {
                     for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var34) {
                        if (civ.getColumnname().equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                           civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                           break;
                        }
                     }
                  }
               }
            } else {
               for(ColumnInfoVO civ : list) {
                  for(Map<String, String> map : map_s) {
                     if (civ.getTypename().toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                        civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                        break;
                     }
                  }
               }
            }

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               return list1;
            } else {
               return list;
            }
         }
      }
   }

   @RequestMapping({"/querycolumntypediff"})
   @ResponseBody
   public List<ComboboxVO> querycolumntype(HttpServletRequest request, HttpServletResponse response, Model model, String sourceColumnType) {
      List<ComboboxVO> list = new ArrayList();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return null;
      } else {
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            String fieldName = "";

            for(Map<String, String> map : map_s) {
               if (sourceColumnType.toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                  fieldName = (String)map.get("targetfieldname");
               }
            }

            List<String> targetFieldNameList = new ArrayList();

            for(Map<String, String> map : map_t) {
               if (fieldName.equals(map.get("targetfieldname"))) {
                  targetFieldNameList.add(((String)map.get("sourcefieldname")).toLowerCase());
               }
            }

            for(String string : targetFieldNameList) {
               ComboboxVO c = new ComboboxVO(string);
               list.add(c);
            }

            return list;
         }
      }
   }

   @RequestMapping({"/querycolumnfileinfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumnfileinfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/queryfilecolumnbyid"})
   @ResponseBody
   public List<TCoreFileStructurecolumnVO> queryfilecolumnbyid(String structureid) {
      List<TCoreFileStructurecolumn> list = this.fileSystemService.queryFileStructureColumn(structureid);
      List<TCoreFileStructurecolumnVO> volist = null;

      try {
         volist = ObjectTool.listConvert(list, TCoreFileStructurecolumnVO.class);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return volist;
   }

   @RequestMapping({"/savetableinfo"})
   @ResponseBody
   public boolean savetableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap, String filterConditions) {
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (!"".equals(filterConditions) && filterConditions != null) {
         if (request.getSession().getAttribute(tasknamereal + "_" + "filterConditions") == null) {
            Map<String, String> map = new HashMap();
            map.put(tableName, filterConditions);
            request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", map);
         } else {
            ((Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions")).put(tableName, filterConditions);
         }
      }

      if (desensitizationsource == null) {
         return false;
      } else {
         List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), tableName);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][primarykey]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][typename]"));
            tCoreMaskingTaskTableInfo.setTargetType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][targettypename]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnsize]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][decimaldigits]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("0")) {
                  map.put("status", "2");
               } else if (((String)map.get("status")).equals("1")) {
                  map.put("status", "3");
               }
            }
         }

         return true;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   @RequestMapping({"/savefiletableinfo"})
   @ResponseBody
   public boolean savefiletableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      String structureid = (String)tableInfoMap.get("tableInfoMap[structureid]");
      String filedir = (String)tableInfoMap.get("tableInfoMap[filedir]");
      String filename = (String)tableInfoMap.get("tableInfoMap[filename]");
      String extension = (String)tableInfoMap.get("tableInfoMap[extension]");
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return false;
      } else {
         List<TCoreFileStructurecolumn> queryColumnInfo = this.fileSystemService.queryFileStructureColumn(structureid);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][keytype]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columntype]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnaccuracy]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columndecimal]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("filedir", filedir);
               map.put("filename", filename);
               map.put("extension", extension);
               map.put("status", "1");
            }
         }

         return true;
      }
   }

   @RequestMapping({"/savechoosetable"})
   @ResponseBody
   public boolean saveChooseTable(String tableName, String chooseType, HttpServletRequest request) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         new ArrayList();
         List<Map<String, String>> list = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if ("onCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "3");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "1");
               }
            }
         } else if ("onUnCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         } else if ("onCheckAll".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "3");
               } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "1");
               }
            }
         } else if ("onUnCheckAll".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         }

         request.getSession().setAttribute("tableList_" + tasknamereal, list);
         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/getTableColumnSensitiveRule"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByIdBySchema(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String schema = (String)parameter.get("schema");
      String table = (String)parameter.get("table");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table)) {
         new ArrayList();
         List<TCoreMaskingTaskTableInfo> e = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table);
         if (e != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : e) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               tcoreDiscoverySensitivecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexRuleName());
               tcoreDiscoverySensitivecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      } else {
         new ArrayList();
         List<TCoreFieldSensitiveMemory> var15 = (List)this.redisService.get(table + "+" + schema);
         if (var15 != null) {
            for(int i = 0; i < var15.size(); ++i) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(((TCoreFieldSensitiveMemory)var15.get(i)).getColumnname());
               tcoreDiscoverySensitivecolumn.setRegextype(((TCoreFieldSensitiveMemory)var15.get(i)).getRegextype());
               tcoreDiscoverySensitivecolumn.setRuleid(((TCoreFieldSensitiveMemory)var15.get(i)).getRuleid());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/resetTableInfo"})
   public boolean resetTableInfo(HttpServletRequest request, String tableName) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         this.redisService.remove(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tableName);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("2")) {
                  map.put("status", "0");
               } else if (((String)map.get("status")).equals("3")) {
                  map.put("status", "1");
               }
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @RequestMapping({"/editDesensitizationTask"})
   public String editDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      model.addAttribute("taskid", taskid);
      Desensitizationtask desensitizationtask = this.desensitizationtaskSerialService.queryTaskById(taskid);
      String tasktype = desensitizationtask.getTasktype();
      String sourcetype = tasktype.split("to")[0];
      String path = "";
      request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      request.getSession().setAttribute(desensitizationtask.getTasknamereal() + "_taskid", taskid);
      Desensitizationsource desensitizationsource = this.desensitizationtaskSerialService.querySourceInfo(taskid);
      Desensitizationtarget desensitizationtarget = this.desensitizationtaskSerialService.queryTargetInfo(taskid);
      List<Map<String, String>> tableList = new ArrayList();
      if ("DB".equals(sourcetype)) {
         Map<String, String> allTable = this.dataSystemService.queryTableName(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "");

         for(DesensitizationTable desensitizationTable : this.desensitizationtaskSerialService.queryTableList(taskid)) {
            allTable.put(desensitizationTable.getTablename(), desensitizationTable.getStatus());
         }

         List<DBTableVO> list = new ArrayList();

         for(String key : allTable.keySet()) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename(key);
            dbTableVO.setStatus((String)allTable.get(key));
            list.add(dbTableVO);
         }

         Collections.sort(list);

         for(DBTableVO dbTableVO : list) {
            Map<String, String> map = new HashMap();
            map.put("tableName", dbTableVO.getTablename());
            map.put("status", dbTableVO.getStatus());
            tableList.add(map);
         }

         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         if (tCoreDatasystemTarget != null && !tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype())) {
            model.addAttribute("mappingEditFlag", "dbsystem_diff");
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         request.getSession().setAttribute("tableList_" + desensitizationtask.getTasknamereal(), tableList);
         path = "core/desensitizationtaskserial/taskedit/desensitizationtaskserial_edit";
      } else if ("FILE".equals(sourcetype)) {
         List<TCoreFileStructure> list = this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "");
         List<DesensitizationTable> desensitizationTablelist = this.desensitizationtaskSerialService.queryTableList(taskid);
         Map<String, DesensitizationTable> maptable = new HashMap();

         for(DesensitizationTable desensitizationTable : desensitizationTablelist) {
            maptable.put(desensitizationTable.getTablename(), desensitizationTable);
         }

         for(TCoreFileStructure dbTableVO : list) {
            Map<String, String> tableMap = new HashMap();
            tableMap.put("tableName", dbTableVO.getFilestructurename());
            tableMap.put("structureid", dbTableVO.getId());
            tableMap.put("filedir", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilepath());
            tableMap.put("filename", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[0]);
            tableMap.put("extension", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : "." + ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[1]);
            tableMap.put("status", maptable.get(dbTableVO.getFilestructurename()) == null ? "0" : "1");
            tableList.add(tableMap);
         }

         request.getSession().setAttribute("tableList_" + desensitizationtask.getTasknamereal(), tableList);
         model.addAttribute("isshow", "1");
         model.addAttribute("taskid", taskid);
         path = "core/desensitizationtaskserial/taskedit/desensitizationtaskserial_edit_file";
      }

      return path;
   }

   @RequestMapping({"/showDesensitizationTask"})
   public String showDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      model.addAttribute("taskid", taskid);
      return "core/desensitizationtaskserial/taskedit/desensitizationtaskserial_show";
   }

   @RequestMapping({"/querymultitable"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitable(String taskid, String table, HttpServletRequest request) {
      if (taskid == null) {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         List<ColumnInfoVO> queryColumnInfo = new ArrayList();
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         if (desensitizationsource == null) {
            desensitizationsource = this.desensitizationtaskSerialService.querySourceInfo(taskid);
         }

         new ArrayList();
         List<TCoreMaskingTaskTableInfo> var16 = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
         HashMap<String, String> map = new HashMap();
         if (var16 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var16) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
            if (this.redisService.exists(table + "+" + desensitizationsource.getDataschema())) {
               new ArrayList();
               List<TCoreFieldSensitiveMemory> var18 = (List)this.redisService.get(table + "+" + desensitizationsource.getDataschema());
               if (var18 != null) {
                  for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : var18) {
                     map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
                  }
               }
            }
         }

         if (var16 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var16) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               queryColumnInfo.add(columnInfo);
            }
         }

         for(ColumnInfoVO columnInfo : queryColumnInfo) {
            columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
         }

         return queryColumnInfo;
      } else {
         List<ColumnInfoVO> queryColumnInfo = new ArrayList();

         for(DesensitizationTablecolumn desensitizationTablecolumn : this.desensitizationtaskSerialService.queryColumInfo(taskid, table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
            queryColumnInfo.add(columnInfo);
         }

         return queryColumnInfo;
      }
   }

   @RequestMapping(
      value = {"/removetask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.desensitizationtaskSerialService.removeTask(taskid);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("数据脱敏");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setLogmessage("删除数据脱敏任务");
      this.operationService.add(record);
   }

   @RequestMapping({"/executeDesensitizationTask"})
   public String executeDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      try {
         Desensitizationsource desensitizationsource = this.desensitizationtaskSerialService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.desensitizationtaskSerialService.queryTargetById(taskid);
         Desensitizationtask desensitizationtask = this.desensitizationtaskSerialService.queryTaskById(taskid);
         TCoreDatasystem tCoreDatasystemSource = new TCoreDatasystem();
         TCoreDatasystem tCoreDatasystemTarget = new TCoreDatasystem();
         if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         } else {
            tCoreDatasystemSource.setDbtype("FILE");
         }

         if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
            tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         } else {
            tCoreDatasystemTarget.setDbtype("FILE");
         }

         String type = JdbcTool.returnType(desensitizationsource.getExecution_type(), desensitizationtarget.getExecution_type(), desensitizationtask.getTasktype());
         InfoProperty infoProperty = this.desensitizationtaskSerialService.getInfoProperty();
         long groupId = (new Date()).getTime();
         ExecuteParam executeParam = new ExecuteParam();
         executeParam.setSourceDataSystem(tCoreDatasystemSource);
         executeParam.setTargetDataSystem(tCoreDatasystemTarget);
         executeParam.setInfoProperty(infoProperty);
         executeParam.setDataSourceId(desensitizationsource.getDatasourceid());
         executeParam.setDataTargetId(desensitizationtarget.getDatasourceid());
         executeParam.setFolderName(desensitizationtask.getFoldername());
         executeParam.setSourceSchemaName(desensitizationsource.getDataschema());
         executeParam.setTargetSchemaName(desensitizationtarget.getDataschema());
         executeParam.setIsPrimary(desensitizationtarget.getIsprimary());
         executeParam.setIsIndex(desensitizationtarget.getIsindex());
         executeParam.setTaskid(taskid);
         executeParam.setSourceFileDir(desensitizationsource.getSourcefiledir());
         executeParam.setTaskNameReal(desensitizationtask.getTasknamereal());
         String taskType = JdbcTool.returnTaskType(desensitizationtask.getTasktype());
         List<DesensitizationTable> tableList = this.desensitizationtaskSerialService.queryTableList(taskid);
         Map<String, String> tableMap = new HashMap();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);

         for(DesensitizationTable desensitizationTable : tableList) {
            String id = UUID.randomUUID().toString();
            tableMap.put(desensitizationTable.getTablename(), id);
            DesensitizationMonitor desensitizationMonitor = new DesensitizationMonitor();
            desensitizationMonitor.setId(id);
            desensitizationMonitor.setSourcename(desensitizationTable.getTablename());
            desensitizationMonitor.setTargetname(desensitizationTable.getTablename());
            desensitizationMonitor.setRunstatus(0);
            desensitizationMonitor.setGroupid(new BigInteger(String.valueOf(groupId)));
            desensitizationMonitor.setTaskid(taskid);
            desensitizationMonitor.setTasktype(taskType);
            batchInserSql.append(JdbcTool.sql_insert_h(desensitizationMonitor, list_table));
         }

         executeParam.setTableMap(tableMap);
         this.desensitizationtaskSerialService.saveDesensitizationMonitor(batchInserSql.deleteCharAt(batchInserSql.length() - 1));
         switch (type) {
            case "DBtoDB,normal,batchwrite":
               this.desensitizationtaskSerialService.executeDB_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "FILEtoDB,batchwrite":
               this.desensitizationtaskSerialService.executeFILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoDB,batchread,batchwrite":
               this.desensitizationtaskSerialService.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoFILE,batchread":
               this.desensitizationtaskSerialService.executeDB_batchread_FILE_pwc_FILE(executeParam);
               break;
            case "DBtoDB,batchread,normal":
               this.desensitizationtaskSerialService.executeDB_batchread_FILE_pwc_DB(executeParam);
               break;
            default:
               this.desensitizationtaskSerialService.executeTaskNormal(executeParam);
         }

         model.addAttribute("taskid", taskid);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "core/desensitizationmonitor/monitorrun";
   }

   @RequestMapping({"/detail"})
   public String detail(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model) throws SQLException {
      model.addAttribute("taskid", taskid);
      return "core/desensitizationtaskserial/desensitizationtaskserial_details";
   }

   @RequestMapping({"/isrun"})
   @ResponseBody
   public boolean isrun(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      long num_exeing = this.desensitizationtaskSerialService.getExeTaskNum();
      long num_table = this.desensitizationtaskSerialService.getTableNum(taskid);
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      long num_thread = new Long(props.getProperty("threadPool.queueCapacity"));
      return num_exeing + num_table < num_thread;
   }

   @RequestMapping({"/checksystem"})
   @ResponseBody
   public Map<String, Object> checksystem(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      Map<String, Object> map = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Float sys_Alert_Threshold = new Float(props.getProperty("Sys_Alert_Threshold"));
      sys_Alert_Threshold = sys_Alert_Threshold * 100.0F;
      map.put("flag", false);

      try {
         if (!((double)sys_Alert_Threshold <= SysUtils.cpuUsage()) && !((double)sys_Alert_Threshold <= SysUtils.memoryUsage()) && !((double)sys_Alert_Threshold <= SysUtils.getDiskUsage())) {
            map.put("flag", false);
         } else {
            System.out.println("CPU利用率：" + SysUtils.cpuUsage());
            System.out.println("内存占用率：" + SysUtils.memoryUsage());
            System.out.println("磁盘空间占用率：" + SysUtils.getDiskUsage());
            map.put("disk", SysUtils.getDiskUsage());
            map.put("cpu", SysUtils.cpuUsage());
            map.put("memory", SysUtils.memoryUsage());
            map.put("flag", true);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return map;
   }

   public String source_type(Map<String, String> map) {
      String sourceType = "";
      String tasknamereal = (String)map.get("tasknamereal");
      new Desensitizationsource();
      Desensitizationsource desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
      String datasourceid = desensitizationsource.getDatasourceid();
      if (datasourceid != null && !"".equals(datasourceid)) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
         String dbtype = tCoreDatasystem.getDbtype();
         if (!dbtype.equals("FTP") && !dbtype.equals("SFTP")) {
            sourceType = "db";
         } else {
            sourceType = "file";
         }
      } else {
         sourceType = "file";
      }

      return sourceType;
   }

   @RequestMapping({"/structure/querystructurebygroup"})
   @ResponseBody
   public DataGridVO<DBTableVO> querystructurebygroup(String groupname, String tableNamePattern) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         DBTableVO dbTableVO = new DBTableVO();
         if ("0".equals(map.get("status")) || "1".equals(map.get("status"))) {
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            dbTableVO.setDatasystemid((String)map.get("structureid"));
            list.add(dbTableVO);
         }
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/getFileContent"})
   @ResponseBody
   public Map<String, Object> getFileContent(@RequestParam("file") MultipartFile file, String charset) {
      System.out.println("开始");
      String path = this.request.getSession().getServletContext().getRealPath("upload");
      CommonsMultipartFile cf = (CommonsMultipartFile)file;
      DiskFileItem fi = (DiskFileItem)cf.getFileItem();
      File files = fi.getStoreLocation();
      Map<String, String> map = transdbf.selectdbf(charset, files, ",");
      Map<String, Object> map_list = new HashMap();
      String content = (String)map.get("content");
      String[] a = content.split("\\\n");
      List<String> list = new ArrayList();

      for(String string : a) {
         list.add(string);
      }

      map_list.put("list", list);
      map_list.put("title", map.get("fieldtitle"));
      return map_list;
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }
}
