package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitiveField;
import com.chenyang.nse.bussiness.entity.vo.UserGroupVO;
import com.chenyang.nse.bussiness.service.core.FieldDesensitiveConfigService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/fielddesensitiveconfig"})
public class FieldDesensitiveConfigController {
   @Autowired
   FieldDesensitiveConfigService fieldDesensitiveConfigService;

   @RequestMapping({"/queryUserGroupList"})
   @ResponseBody
   public Response queryUserGroupList() {
      List<UserGroupVO> list = this.fieldDesensitiveConfigService.queryUserGroupList();
      return RespHelper.successResp(list);
   }

   @RequestMapping({"/save"})
   @ResponseBody
   public Response save(@RequestBody Map<String, Object> map) {
      this.fieldDesensitiveConfigService.save(map);
      return RespHelper.successResp();
   }

   @RequestMapping({"/queryFieldConfigList"})
   @ResponseBody
   public Response queryFieldConfigList(@RequestBody Map<String, String> map) {
      String project_id = (String)map.get("project_id");
      String datasystem_id = (String)map.get("datasystem_id");
      String tschema = (String)map.get("tschema");
      String tname = (String)map.get("tname");
      List<TCoreDesensitiveField> result = this.fieldDesensitiveConfigService.queryFieldConfigList(project_id, datasystem_id, tschema, tname);
      return RespHelper.successResp(result);
   }
}
