package com.chenyang.nse.bussiness.controller.core;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreDesensitizationRuleDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiverelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivetablelog;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreColumnKey;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreDesensitizationRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.DataSystemConfig;
import com.chenyang.nse.bussiness.entity.vo.DiscoverytaskVO;
import com.chenyang.nse.bussiness.entity.vo.DutyPersonVO;
import com.chenyang.nse.bussiness.entity.vo.FeildScopeReqVO;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import com.chenyang.nse.bussiness.entity.vo.Releasecolumn;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.SenstiveColumnRelationVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridSensitiveDataVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ComplianceDirectoryVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataScopeVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataSystemInfoVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.EditionProjectVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.TreeGridFiledDataVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ScopeInfoVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.CoreProjectService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.ITcoreCatacoryLevelLogService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.SearchFieldService;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import com.chenyang.nse.bussiness.service.core.SensitiveLevelService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryResultService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.office.ExcelTool;
import com.chenyang.nse.bussiness.tools.redis.CacheUtil;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.TextUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/fieldscopedata"})
public class FieldScopeController {
   public static final String mysql_datascop_file_path = "/data/";
   @Autowired
   TCoreDesensitizationRuleDao tCoreDesensitizationRuleDao;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   private SensitiveColumnService sensitiveColumnService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private SearchFieldService searchFieldService;
   @Autowired
   private DictionaryService dictionaryService;
   @Autowired
   private ImportMaskingRuleService maskingRuleService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private CoreProjectService coreProjectService;
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private TdataDiscoveryResultService tdataDiscoveryResultService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private UserService userService;
   @Autowired
   private SensitiveLevelService sensitiveLevelService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private ITcoreCatacoryLevelLogService tcoreCatacoryLevelLogService;
   @Autowired
   private TCoreScopeFieldDao tCoreScopeFieldDao;
   @Autowired
   private TCoreFieldSensitiveDao tCoreFieldSensitiveDao;
   public static List<String> typelist_buffer = null;
   public static List<String> namelist_buffer = null;
   public static List<String> regexlist_buffer = null;

   @ResponseBody
   @RequestMapping({"/getMaskingRuleByversioninfo"})
   public Response<Map> getMaskingRuleByversioninfo(@RequestBody Map<String, String> params) {
      String projectid = (String)params.get("projectid");
      String versions = (String)params.get("versions");
      String versionname = (String)params.get("versionname");
      Map<String, Map<String, Object>> map = new HashMap();
      Map<String, String> editionmap = this.dataScopeService.queryNewTProEditionScope(projectid);
      String scope_category = (String)editionmap.get("scope_category");
      String scope_level = (String)editionmap.get("scope_level");
      if (versions != null && !"".equals(versions)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         if (versions.contains("AllVersion")) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if (versions.contains("ProjectVersion")) {
            File file = new File(props.getProperty("ProjectVersion") + projectid);
            filepath = props.getProperty("ProjectVersion") + projectid + File.separator + versions.split("/")[1];
         } else if (versions.contains("TaskVersion")) {
            File file = new File(props.getProperty("TaskVersion") + projectid);
            filepath = props.getProperty("TaskVersion") + versions.split("/")[1] + File.separator + versions.split("/")[2];
         }

         if (FileTool.isFileExit(filepath)) {
            InputStreamReader newRead = null;

            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e1) {
               e1.printStackTrace();
            } catch (FileNotFoundException e1) {
               e1.printStackTrace();
            }

            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] str = null;

            try {
               while((newInformationLine = newBufferedReader.readLine()) != null) {
                  str = newInformationLine.split(",", -1);
                  if (!"".equals(str[3])) {
                     new ArrayList();
                     Map<String, Object> map1 = new HashMap();
                     map1.put("dataareaid", str[3]);
                     map1.put("dataareaname", str[4]);
                     map1.put("maskingruleid", str[5]);
                     map1.put("maskingrulename", str[6]);
                     List<TCoreDesensitizationRule> rulelist = this.tCoreDesensitizationRuleDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", str[3]), Restrictions.eq("defaluttype", "1")});
                     if (null != rulelist && rulelist.size() > 0) {
                        map1.put("ruleId", ((TCoreDesensitizationRule)rulelist.get(0)).getId());
                        map1.put("rulename", ((TCoreDesensitizationRule)rulelist.get(0)).getRulename());
                     } else {
                        map1.put("ruleId", "");
                        map1.put("rulename", "");
                     }

                     String key = str[0] + "." + str[1] + "." + str[2];
                     if (!map1.get("maskingruleid").toString().equals("") && !map1.get("maskingrulename").toString().equals("")) {
                        map.put(key, map1);
                     }

                     map1.put("tschemas", str[0]);
                     map1.put("names", str[1]);
                     map1.put("table_field_id", str[2]);
                     map1.put("dataSystemid", str[8]);
                  }
               }
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               a(newBufferedReader, newRead);
            }
         }
      }

      return RespHelper.<Map>successResp(map);
   }

   @ResponseBody
   @RequestMapping({"/getversioninfo"})
   public Response<Map> getVersionInfo(@RequestBody Map<String, String> params) {
      String projectid = (String)params.get("projectid");
      String versions = (String)params.get("versions");
      String versionname = (String)params.get("versionname");
      Map<String, Map<String, Object>> map = new HashMap();
      Map<String, String> editionmap = this.dataScopeService.queryNewTProEditionScope(projectid);
      String scope_category = (String)editionmap.get("scope_category");
      String scope_level = (String)editionmap.get("scope_level");
      if (versions != null && !"".equals(versions)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         if ("AllVersion".equals(versions)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(versions)) {
            File file = new File(props.getProperty("ProjectVersion") + projectid);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + versions.split("/")[1] + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(versions)) {
            File file = new File(props.getProperty("TaskVersion") + projectid);
            String filename = "";
            if (file.listFiles() != null && file.listFiles().length > 0) {
               File[] files = file.listFiles();

               for(File file1 : files) {
                  String substring = file1.getName().substring(0, file1.getName().indexOf("_"));
                  if (substring.equals(versionname)) {
                     filename = file1.getName();
                  }
               }
            }

            filepath = props.getProperty("TaskVersion") + projectid + "/" + filename;
         }

         if (FileTool.isFileExit(filepath)) {
            InputStreamReader newRead = null;

            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e1) {
               e1.printStackTrace();
            } catch (FileNotFoundException e1) {
               e1.printStackTrace();
            }

            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] str = null;

            try {
               while((newInformationLine = newBufferedReader.readLine()) != null) {
                  str = newInformationLine.split(",", -1);
                  if (!"".equals(str[3])) {
                     Map<String, Object> objectMap = new HashMap();
                     List<Map<String, String>> scopelist = this.dataScopeService.getScopelist(scope_category, str[3]);
                     List<Map<String, String>> scopenewlist = new ArrayList();
                     scopelist.forEach((scopeinfo) -> {
                        String scopeid = (String)scopeinfo.get("id");
                        Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scopeid);
                        Map<String, String> map1 = new HashMap();
                        map1.put("scopeid", scopeid);
                        map1.put("scopename", scopenamemap.get("scope_name"));
                        scopenewlist.add(map1);
                     });
                     objectMap.put("scope", scopenewlist);
                     List<Map<String, String>> scopelevellist = this.dataScopeService.getScopelevellist(scope_level, str[3]);
                     Map<String, String> map2 = new HashMap();
                     if (scopelevellist.size() > 0) {
                        String scopelevelid = (String)((Map)scopelevellist.get(0)).get("id");
                        map2.put("id", scopelevelid);
                        Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scopelevelid);
                        map2.put("name", scopenamemap.get("sensitive_name"));
                     } else {
                        map2.put("id", "");
                        map2.put("name", "");
                     }

                     objectMap.put("scopelevel", map2);
                     String key = str[8] + "." + str[0] + "." + str[1] + "." + str[2];
                     map.put(key, objectMap);
                  }
               }
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               a(newBufferedReader, newRead);
            }
         }
      }

      return RespHelper.<Map>successResp(map);
   }

   @ResponseBody
   @RequestMapping({"/allsave"})
   public Response<String> allsave(@RequestBody Map<String, String> params) {
      String projectid = (String)params.get("projectid");
      String versions = (String)params.get("versions");
      String dataSystemid = (String)params.get("dataSystemid");
      String editionid = this.tdataProjectService.queryEdtionIdByProId(projectid);
      String username = CommonUtils.loginUsername();
      Map<String, Map<String, Object>> map = this.dataScopeService.getVersionInfo(projectid, versions, editionid);
      List<TCoreScopeField> tCoreScopeFields = this.dataScopeService.queryScopeById(projectid, dataSystemid, editionid);
      List<TCoreFieldSensitive> tCoreFieldSensitives = this.dataScopeService.queryScopeLevelById(projectid, dataSystemid, editionid);
      boolean customVersion = versions.contains("CustomVersion");
      map.forEach((k, v) -> {
         String[] split = k.split("\\.");
         String schemaname = split[1];
         String tablename = split[2];
         String fieldname = split[3];
         List<TCoreScopeField> collect = (List)tCoreScopeFields.stream().filter((x) -> schemaname.equals(x.getTschemas()) && tablename.equals(x.getNames())).collect(Collectors.toList());
         List<TCoreFieldSensitive> collect1 = (List)tCoreFieldSensitives.stream().filter((x) -> schemaname.equals(x.getTschemas()) && tablename.equals(x.getNames())).collect(Collectors.toList());
         if (customVersion) {
            collect = (List)collect.stream().filter((x) -> fieldname.equalsIgnoreCase(x.getTablefield_id())).collect(Collectors.toList());
            collect1 = (List)collect1.stream().filter((x) -> fieldname.equalsIgnoreCase(x.getTablefield_id())).collect(Collectors.toList());
         }

         if (collect.size() == 0 || collect1.size() == 0) {
            List<Map<String, String>> scopelist = (List)v.get("scope");
            List<String> datascoTidList = new ArrayList();
            List<String> dataColumList = new ArrayList();
            dataColumList.add(dataSystemid);
            dataColumList.add(fieldname);
            dataColumList.add(tablename);
            dataColumList.add(schemaname);
            dataColumList.add("1");
            dataColumList.add(editionid);
            dataColumList.add(projectid);
            dataColumList.add(username);
            if (scopelist.size() > 0) {

               dataColumList.add((scopelist.get(0)).get("dataareaid"));
            } else {
               dataColumList.add("");
            }

            scopelist.forEach((scopeinfo) -> datascoTidList.add(scopeinfo.get("scopeid")));
            Map<String, String> scopeLevel = (Map)v.get("scopelevel");
            List<String> datascoLevelTidList = new ArrayList();
            List<String> dataLevelColumList = new ArrayList();
            dataLevelColumList.add(dataSystemid);
            dataLevelColumList.add(fieldname);
            dataLevelColumList.add(tablename);
            dataLevelColumList.add(schemaname);
            dataLevelColumList.add("3");
            dataLevelColumList.add(editionid);
            dataLevelColumList.add(projectid);
            dataLevelColumList.add(username);
            dataLevelColumList.add(scopeLevel.get("dataareaid"));
            String id = (String)scopeLevel.get("id");
            datascoLevelTidList.add(id);

            try {
               this.searchFieldService.saveColumnType(dataColumList, datascoTidList, customVersion);
               this.searchFieldService.saveColumnType(dataLevelColumList, datascoLevelTidList, customVersion);
               this.searchFieldService.addScopeLog(dataColumList, datascoTidList, editionid, datascoLevelTidList, dataLevelColumList);
               String catagoryids = (String)datascoTidList.stream().collect(Collectors.joining(","));
               String bindtype = "1";
               if (customVersion) {
                  bindtype = "4";
               }

               this.tcoreCatacoryLevelLogService.save(projectid, editionid, dataSystemid, schemaname, tablename, fieldname, catagoryids, id, "1", bindtype, username, "", new Date(), (Date)null);
            } catch (IllegalAccessException e) {
               e.printStackTrace();
            } catch (InvocationTargetException e) {
               e.printStackTrace();
            }
         }

      });
      return RespHelper.<String>successResp();
   }

   @ResponseBody
   @RequestMapping({"/queryProVersion"})
   public Response queryProVersion(@RequestBody Map<String, String> map) {
      String projectid = (String)map.get("projectid");
      String versiontype = (String)map.get("versiontype");
      Map<String, String> projectmap = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String str = "";
      String filepath = "";
      if ("project".equals(versiontype)) {
         filepath = props.getProperty("ProjectVersion") + projectid;
      } else {
         filepath = props.getProperty("AllVersion");
      }

      File projectfile = new File(filepath);
      if (projectfile.listFiles() != null && projectfile.listFiles().length > 0) {
         str = projectfile.listFiles()[0].getName().split("\\.txt")[0];
         String username = str.substring(str.lastIndexOf("_") + 1);
         String s = str.replace("_" + username, "");
         String datetime = s.substring(s.lastIndexOf("_") + 1);
         String versionname = s.replace("_" + datetime, "");
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
         projectmap.put("versionname", versionname);
         projectmap.put("datetime", sd);
         projectmap.put("username", username);
         projectmap.put("filename", projectfile.listFiles()[0].getName());
      }

      return RespHelper.successResp(projectmap);
   }

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      model.addAttribute("id", id);
      return "core/datascope/fielddatascope";
   }

   @ResponseBody
   @RequestMapping({"/queryversion"})
   public Response<List<ComboboxVO>> queryversion() {
      List<ComboboxVO> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      File projectfile = new File(props.getProperty("ProjectVersion"));
      File allfile = new File(props.getProperty("AllVersion"));
      if (taskfile.listFiles() != null && taskfile.listFiles().length > 0) {
         ComboboxVO taskbox = new ComboboxVO();
         taskbox.setText("任务版本");
         taskbox.setValue("TaskVersion");
         list.add(taskbox);
      }

      if (projectfile.listFiles() != null && projectfile.listFiles().length > 0) {
         ComboboxVO probox = new ComboboxVO();
         probox.setText("项目版本");
         probox.setValue("ProjectVersion");
         list.add(probox);
      }

      if (allfile.listFiles() != null && allfile.listFiles().length > 0) {
         ComboboxVO allbox = new ComboboxVO();
         allbox.setText("全局版本");
         allbox.setValue("AllVersion");
         list.add(allbox);
      }

      ComboboxVO allbox = new ComboboxVO();
      allbox.setText("无版本");
      allbox.setValue("null");
      list.add(allbox);
      return RespHelper.<List<ComboboxVO>>successResp(list);
   }

   @RequestMapping({"/fielddatascopereport"})
   public String fielddatascopeReport(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datascope/fielddatascopereport";
   }

   @RequestMapping({"/searchByName"})
   @ResponseBody
   public String searchByName(String showstate, String tableparam, String feildparam, String continuestate, String taskname, String datasystemid, @RequestParam("table[]") List<String> table, String schemas, String findtaskId, @RequestParam("dataAreaList[]") List<String> dataAreaList, @RequestParam("editionScopeList[]") List<String> editionScopeList, String editionsearchId, String setuptype, String versions, HttpServletRequest request, HttpServletResponse response, Model model) {
      long startTime = System.currentTimeMillis();
      String dasyid = null;
      HttpSession session = request.getSession();
      if (session == null) {
         return "1";
      } else {
         ProgressInfo progressInfo = new ProgressInfo(-1L);
         session.setAttribute("progressInfo", progressInfo);
         if ("0".equals(continuestate)) {
            dasyid = datasystemid;
         } else if ("1".equals(continuestate)) {
            dasyid = this.searchFieldService.getdatasystemid(taskname);
         }

         TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dasyid);
         this.searchRegexService.setYearNow();
         int queren = 0;
         this.searchRegexService.init();
         int listCount = 1;
         String s = request.getSession().getId();
         new ArrayList();
         this.searchFieldService.clearColumnKey(s);
         Map<String, String> map = new HashMap();
         map.put("tableparam", tableparam);
         map.put("feildparam", feildparam);
         map.put("showstate", showstate);
         this.searchFieldService.getAllTableColumnsByName(map, continuestate, taskname, datasystem, table, schemas, progressInfo, s, findtaskId, dataAreaList, editionScopeList, editionsearchId, setuptype, versions);
         session.setAttribute("queren", queren);
         request.getSession().setAttribute("sensitiveFlag", s);
         return "0";
      }
   }

   @RequestMapping({"/saveData"})
   @ResponseBody
   public String saveData(@RequestParam("datascopelist[]") List<String> datascopelist, String isDatascope, String showstate, String tableparam, String feildparam, String datasystemid, @RequestParam("table[]") List<String> table, String schemas, String edition_id, String findtaskId, @RequestParam("dataAreaList[]") List<String> dataAreaList, @RequestParam("editionScopeList[]") List<String> editionScopeList, String editionsearchId, String setuptype, String projectId, String versions, HttpServletRequest request, HttpServletResponse response, Model model) {
      HttpSession session = request.getSession();
      if (session == null) {
         return "1";
      } else {
         TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
         Map<String, String> map = new HashMap();
         map.put("tableparam", tableparam);
         map.put("feildparam", feildparam);
         map.put("showstate", showstate);
         map.put("isDatascope", isDatascope);
         this.searchFieldService.saveData(datascopelist, map, datasystem, table, schemas, edition_id, findtaskId, dataAreaList, editionScopeList, editionsearchId, setuptype, projectId, versions, datasystemid);
         String tableClassName = this.isDatascope(isDatascope);
         CommandTool.commandRtn("/data/" + tableClassName + ".sh");
         return "0";
      }
   }

   @RequestMapping({"/querySaveRateOfProgress"})
   @ResponseBody
   public Object querySaveRateOfProgress(boolean complete, HttpServletRequest request, HttpServletResponse response, Model model) {
      HttpSession session = request.getSession();
      if (complete) {
         session.setAttribute("saveProgressInfo", null);
         return "1";
      } else {
         return session.getAttribute("saveProgressInfo");
      }
   }

   @RequestMapping({"/queryRateOfProgress"})
   @ResponseBody
   public Object queryRateOfProgress(boolean complete, HttpServletRequest request, HttpServletResponse response, Model model) {
      HttpSession session = request.getSession();
      if (complete) {
         session.setAttribute("progressInfo", null);
         return "1";
      } else {
         return session.getAttribute("progressInfo");
      }
   }

   @RequestMapping({"/toSaveRedis"})
   @ResponseBody
   public String toSaveRedis(HttpServletRequest request, HttpServletResponse response, Model model) {
      String s = request.getSession().getId();

      try {
         this.searchFieldService.toSaveRedis(s);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "0";
   }

   @ResponseBody
   @RequestMapping({"/querydatasystem"})
   public List<TCoreDatasystem> querydatasource(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = new ArrayList();
      Map<String, String> sysMap = new HashMap();
      sysMap.put("MYSQL", "1");
      sysMap.put("ORACLE", "1");
      sysMap.put("MSSQLSERVER", "1");
      sysMap.put("DB2", "1");
      sysMap.put("SYBASE", "1");
      sysMap.put("AS400", "1");
      sysMap.put("INFORMIX", "1");
      sysMap.put("HIVE", "1");
      sysMap.put("LOCALFILE", "1");
      sysMap.put("SYBASE_IQ", "1");
      sysMap.put("MARIADB", "1");
      sysMap.put("FTP", "1");
      sysMap.put("SFTP", "1");
      sysMap.put("TERADATA", "1");
      sysMap.put("GREENPLUM", "1");
      sysMap.put("HANA", "1");
      list.addAll(this.dataSystemService.querydatasource());
      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         String icon = ((TCoreDatasystem)list.get(i)).getDbtype().toLowerCase();
         ((TCoreDatasystem)list.get(i)).setIconCls(icon);
         if (!"4".equals(((TCoreDatasystem)list.get(i)).getFlag()) && sysMap.containsKey(((TCoreDatasystem)list.get(i)).getDbtype().toUpperCase())) {
            reList.add(list.get(i));
         }
      }

      return reList;
   }

   @ResponseBody
   @RequestMapping({"/queryShemas"})
   public List<ComboboxVO> queryShemas(String param1, String param2, String param3, HttpServletRequest param4, HttpServletResponse param5, Model param6) {
      // $FF: Couldn't be decompiled
      return null;
   }

   @ResponseBody
   @RequestMapping({"/queryTable"})
   public List<DBTableVO> queryTable(String tablename, String value, String dataSystemId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(dataSystemId, value);
      if (tablename != null && !tablename.equals("")) {
         String[] table_List = tablename.trim().split("\\,");
         List<DBTableVO> tableSearchList = new ArrayList();
         List<String> table_List_name = Arrays.asList(table_List);

         for(DBTableVO dbTableVO : list) {
            for(String string : table_List_name) {
               if (columnnameLikeMethod(dbTableVO.getTablename(), string)) {
                  tableSearchList.add(dbTableVO);
               }
            }
         }

         List<DBTableVO> temporaryList = new ArrayList();
         HashMap<String, Integer> hash = new HashMap();

         for(DBTableVO dbTableVO2 : tableSearchList) {
            if (hash.get(dbTableVO2.getTablename()) == null) {
               temporaryList.add(dbTableVO2);
               hash.put(dbTableVO2.getTablename(), 1);
            }
         }

         return temporaryList;
      } else {
         return list;
      }
   }

   @RequestMapping({"/queryMaskingRules"})
   @ResponseBody
   public List<TCoreMaskingRule> queryMaskingRules(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingRule> list = this.maskingRuleService.queryValidRule();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/exportToExceltoLog"})
   public ResultVO exportToExceltoLog(String groupid, String state, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      String path = request.getSession().getServletContext().getRealPath("/") + "css" + File.separator + UUID.randomUUID().toString() + ".xlsx";
      LinkedBlockingQueue<TreeGridSensitiveDataVO> queue = new LinkedBlockingQueue();
      new ArrayList();

      for(TCoreSensitivetablelog tCoreSensitivetablelog : this.sensitiveColumnService.queryTCoreSensitivetablelog(groupid, state)) {
         try {
            queue.put(new TreeGridSensitiveDataVO(tCoreSensitivetablelog.getDatasourcename(), tCoreSensitivetablelog.getTschema(), tCoreSensitivetablelog.getTablename(), tCoreSensitivetablelog.getColumnname(), tCoreSensitivetablelog.getSampling(), tCoreSensitivetablelog.getEtsampling(), tCoreSensitivetablelog.getMate(), tCoreSensitivetablelog.getMateratio(), tCoreSensitivetablelog.getRegextype(), tCoreSensitivetablelog.getRuie()));
         } catch (InterruptedException e) {
            e.printStackTrace();
         }
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("数据源", "datasourcename");
      titlevalue.put("所有者", "schema");
      titlevalue.put("表名", "parentname");
      titlevalue.put("列名", "name");
      titlevalue.put("取样", "totalCount");
      titlevalue.put("有效取样", "validCount");
      titlevalue.put("匹配", "matchCount");
      titlevalue.put("匹配率", "matchRate");
      titlevalue.put("敏感类型", "regexType");
      titlevalue.put("脱敏规则", "ruleName");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      columnWidthList.add(2700);
      columnWidthList.add(1600);
      columnWidthList.add(2200);
      columnWidthList.add(2700);
      columnWidthList.add(2700);
      ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, (List)null);
      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @RequestMapping({"/downloadfile"})
   public String downloadfile(String path, HttpServletRequest request, HttpServletResponse response, Model model) {
      try {
         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=dataoutput.xlsx");
         InputStream inputStream = new FileInputStream(new File(path));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
         FileTool.removeFile(path);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }

   @RequestMapping({"/queryAllRegexTypeColor"})
   @ResponseBody
   public List<RegexTypeColorVO> queryAllRegexTypeColor() {
      return this.dictionaryService.queryAllRegexTypeColor();
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumnId"})
   public ResultVO querySensitiveColumnId(String groupId, String dataSourceId, String schema, String tableName, String columnName, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreSensitivecolumn column = this.sensitiveColumnService.querySensitiveColumn(groupId, dataSourceId, schema, tableName, columnName);
      ResultVO result = null;
      if (null == column) {
         result = new ResultVO("请先保存该字段", false);
      } else if (null != column.getRegextype() && !"".equals(column.getRegextype())) {
         result = new ResultVO(column.getId(), true);
      } else {
         result = new ResultVO("请先保存该字段的敏感类型", false);
      }

      return result;
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumns"})
   public List<SenstiveColumnRelationVO> querySensitiveColumns(String groupId, String sensitiveColumnId, String regexType, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveColumns(groupId, sensitiveColumnId, regexType);
   }

   @ResponseBody
   @RequestMapping({"/saveSensitiveRelation"})
   public Boolean saveSensitiveRelation(String sourceColumnId, @RequestParam(value = "targetColumnIds[]",required = false) List<String> targetColumnIds, @RequestParam(value = "deletedColumnIds[]",required = false) List<String> deletedColumnIds, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.saveSensitiveRelation(sourceColumnId, targetColumnIds, deletedColumnIds);
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumnRelations"})
   public List<TCoreSensitiverelation> querySensitiveColumnRelations(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveColumnRelations(groupId);
   }

   @ResponseBody
   @RequestMapping({"/exportColumnRelations"})
   public ResultVO exportColumnRelations(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      List<TCoreSensitiverelation> list = this.sensitiveColumnService.querySensitiveColumnRelations(groupId);
      Map<String, TCoreSensitiverelation> columnIdMap = new HashMap();
      Map<String, List<String>> relationMap = new HashMap();
      String targetColumnIds = "";

      for(TCoreSensitiverelation relation : list) {
         List<String> currentColumnRelationList = null;
         String columnId = relation.getSsensitivecolumnid();
         String targetColumnId = relation.getTsensitivecolumnid();
         targetColumnIds = targetColumnIds + targetColumnId + ",";
         if (!columnIdMap.containsKey(columnId)) {
            columnIdMap.put(columnId, relation);
         }

         if (targetColumnIds.indexOf(columnId) == -1) {
            if (!relationMap.containsKey(columnId)) {
               currentColumnRelationList = new ArrayList();
               relationMap.put(columnId, currentColumnRelationList);
            } else {
               currentColumnRelationList = (List)relationMap.get(columnId);
            }

            currentColumnRelationList.add(targetColumnId);
         }
      }

      String path = request.getSession().getServletContext().getRealPath("/") + "css" + File.separator + UUID.randomUUID().toString() + ".xlsx";
      LinkedBlockingQueue<TCoreSensitiverelation> queue = new LinkedBlockingQueue();
      List<Integer> mergeCellArray = new ArrayList();
      int rowIndex = 1;

      for(Map.Entry<String, List<String>> entry : relationMap.entrySet()) {
         TCoreSensitiverelation column = (TCoreSensitiverelation)columnIdMap.get(entry.getKey());
         List<TCoreSensitiverelation> tempList = new ArrayList();
         tempList.add(column);
         mergeCellArray.add(rowIndex);

         for(String targetColumnId : entry.getValue()) {
            TCoreSensitiverelation targetColumn = (TCoreSensitiverelation)columnIdMap.get(targetColumnId);
            if (targetColumn != null) {
               tempList.add(targetColumn);
            }

            ++rowIndex;
         }

         mergeCellArray.add(rowIndex++);
         mergeCellArray.add(0);
         mergeCellArray.add(0);
         Collections.sort(tempList, new Comparator<TCoreSensitiverelation>() {
            public int compare(TCoreSensitiverelation r1, TCoreSensitiverelation r2) {
               if (r1 == null) {
                  return 0;
               } else if (r1.getTablename() == null) {
                  return 0;
               } else if (r2 == null) {
                  return 0;
               } else {
                  return r1.getTablename() == null ? 0 : r1.getTablename().compareTo(r2.getTablename());
               }
            }
         });
         queue.addAll(tempList);
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("敏感类型", "regextype");
      titlevalue.put("数据源", "datasourcename");
      titlevalue.put("所有者", "schema");
      titlevalue.put("表名", "tablename");
      titlevalue.put("列名", "columnname");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(2700);
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, mergeCellArray);
      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroup"})
   public List<TCoreSensitivegroup> querySensitiveGroup(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup();
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroupbycondition"})
   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId, @RequestParam("schemas[]") List<String> schemas, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup(dataSourceId, schemas);
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroupbyconditionbymysql"})
   public List<TCoreSensitivegroup> querySensitiveGroupByMysql(String dataSourceId, @RequestParam("schemas[]") List<String> schemas, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup(dataSourceId);
   }

   @RequestMapping({"/fielddatascopelist"})
   public String searchSensitiveDataList(HttpServletRequest request, String type, String checksearch, String schemaTable, String columnname, String sensitivesearch, String compliancesearch, String datascopesearch) {
      if (schemaTable != null) {
         request.getSession().setAttribute("schemaTable", schemaTable);
      }

      if (columnname != null) {
         request.getSession().setAttribute("columnname", columnname);
      }

      if (sensitivesearch != null) {
         request.setAttribute("sensitivesearch", sensitivesearch);
      }

      if (compliancesearch != null) {
         request.setAttribute("compliancesearch", compliancesearch);
      }

      if (datascopesearch != null) {
         request.setAttribute("datascopesearch", datascopesearch);
      }

      if (checksearch != null) {
         request.setAttribute("checksearch", checksearch);
      }

      return "core/datascope/fielddatascopelist";
   }

   @ResponseBody
   @RequestMapping({"/fieldinstalllist"})
   public HashMap showSensitiveDataList(String setuptype, String showstate, String checksure, String checksearch, String schemaTable, String columnname, String state, int rows, int page, String projectId, HttpServletRequest request, HttpServletResponse response, Model model) {
      String s = request.getSession().getId();
      int listCount = 1;
      DataGridVO<TreeGridFiledDataVO> vo = null;
      String datasystem_id = null;
      List<TCoreColumnKey> keylist = this.searchFieldService.getColumnKeyByPage(s, rows, page);
      List<TCoreColumnKey> keylistall = this.searchFieldService.getColumnKey(s);
      int totol = keylistall.size();
      HashMap map = new HashMap();
      List<List<TreeGridFiledDataVO>> hashlist = new ArrayList();
      List<String> tableandschamelist = new ArrayList();
      List<String> tablenamelist = new ArrayList();

      for(TCoreColumnKey tck : keylist) {
         String schemaTableRedisId = tck.getColumn_key();
         List<TreeGridFiledDataVO> list = (List)this.redisService.get(schemaTableRedisId);
         new TreeGridFiledDataVO();
         new ArrayList();
         String tableandschemaname = schemaTableRedisId.split("#_#")[1] + "." + schemaTableRedisId.split("#_#")[0];
         datasystem_id = schemaTableRedisId.split("#_#")[2];
         String tablename = schemaTableRedisId.split("#_#")[0];
         tableandschamelist.add(tableandschemaname);
         tablenamelist.add(tablename);
         hashlist.add(list);
      }

      for(int i = 0; i < hashlist.size(); ++i) {
         List<HashMap<String, String>> sureColumn = this.searchFieldService.isSureColumn(datasystem_id, ((TreeGridFiledDataVO)((List)hashlist.get(i)).get(0)).getSchema(), ((TreeGridFiledDataVO)((List)hashlist.get(i)).get(0)).getTable(), (String)null, projectId);
         List<String> tablefieldlist = new ArrayList();

         for(int k = 0; k < sureColumn.size(); ++k) {
            String tablefield = (String)((HashMap)sureColumn.get(k)).get("tablefield_id");
            tablefieldlist.add(tablefield);
         }

         for(int j = 0; j < ((List)hashlist.get(i)).size(); ++j) {
            boolean sureC = tablefieldlist.contains(((TreeGridFiledDataVO)((List)hashlist.get(i)).get(j)).getName());
            if (sureC) {
               ((TreeGridFiledDataVO)((List)hashlist.get(i)).get(j)).setColumnChecked("1");
            } else {
               ((TreeGridFiledDataVO)((List)hashlist.get(i)).get(j)).setColumnChecked("0");
            }

            if ("1".equals(showstate) && !sureC) {
               ((List)hashlist.get(i)).remove(j);
               --j;
            }

            if ("2".equals(showstate) && sureC) {
               ((List)hashlist.get(i)).remove(j);
               --j;
            }
         }
      }

      map.put("totol", totol);
      map.put("page", page);
      map.put("tablenamelist", tableandschamelist);
      map.put("hashmap", hashlist);
      map.put("tablestatus", tableandschamelist);
      return map;
   }

   @RequestMapping({"/searchBySchemaTable"})
   @ResponseBody
   public JSONArray searchBySchemaTable(HttpServletRequest request) {
      JSONArray jsonArr = JSONArray.parseArray((String)request.getSession().getAttribute("schameTable"));
      return jsonArr;
   }

   @ResponseBody
   @RequestMapping({"/getMatchValuesAndNotMatchValues"})
   public HashMap<String, List<String>> a(String schema, String tableName, String columnname, HttpServletRequest request, HttpServletResponse response, Model model) {
      String key = schema + "_m" + tableName + "_m" + columnname;
      Object obj = this.redisService.get(key);
      HashMap<String, List<String>> keyhash = (HashMap)obj;
      return keyhash;
   }

   public static Boolean columnnameLikeMethod(String name, String columnname) {
      String eColumnname = columnname.replace("%", "");
      if (columnname.contains("%")) {
         if (columnname.endsWith("%") && columnname.startsWith("%")) {
            return name.contains(eColumnname);
         }

         if (columnname.endsWith("%")) {
            return name.startsWith(eColumnname);
         }

         if (columnname.startsWith("%")) {
            return name.endsWith(eColumnname);
         }
      }

      return name.equals(eColumnname);
   }

   @ResponseBody
   @RequestMapping({"/project"})
   public List<HashMap<String, String>> project(String schema, String tableName, String columnname, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<HashMap<String, String>> maplist = new ArrayList();

      for(TCoreProjectInfo tCoreProjectInfo : this.coreProjectService.queryAll()) {
         HashMap<String, String> map = new HashMap();
         map.put("text", tCoreProjectInfo.getProjectname());
         map.put("id", tCoreProjectInfo.getRealprojectname());
         maplist.add(map);
      }

      return maplist;
   }

   @ResponseBody
   @RequestMapping({"/queryAllInforZuoYou"})
   public List<Releasecolumn> queryAllInforZuoYou(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      new HashMap();
      String projectid = (String)parameter.get("projectid");
      String state = (String)parameter.get("state");
      new ArrayList();
      List<Releasecolumn> releasecolumnleftlist = new ArrayList();
      List<Releasecolumn> releasecolumnrightlist = new ArrayList();
      if (state.equals("2")) {
         releasecolumnrightlist = (List)request.getSession().getAttribute("releasecolumnrightlist");
         return releasecolumnrightlist;
      } else if (!state.equals("1")) {
         return null;
      } else {
         HttpSession session = request.getSession();
         List<TCoreColumnKey> keyList = this.searchFieldService.getColumnKey(session.getId());
         List<String> schemas = (List)session.getAttribute("schemas");
         HashMap<String, String> map = new HashMap();

         for(String String : schemas) {
            map.put(String, String);
         }

         List<Releasecolumn> releasecolumnlist = this.sensitiveColumnService.queryTcoreReleasecolumn(schemas, projectid, projectid);
         HashMap<String, Releasecolumn> maprelease = new HashMap();
         new HashMap();

         for(Releasecolumn releasecolumn : releasecolumnlist) {
            String stc = releasecolumn.getDatasystemid() + "-" + releasecolumn.getTschema() + "-" + releasecolumn.getTablename() + "-" + releasecolumn.getColumnname();
            maprelease.put(stc, releasecolumn);
         }

         int count = keyList.size();

         for(TCoreColumnKey tck : keyList) {
            String tablekey = tck.getColumn_key();
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (treeGridSensitiveDataVO != null) {
               new ArrayList();

               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i);
                  String tablekey_c = treeGridSensitiveDataVOchildren.getDatasourceid() + "-" + tablekey + "-" + treeGridSensitiveDataVOchildren.getName();
                  Releasecolumn releasecolumn = (Releasecolumn)maprelease.get(tablekey_c);
                  if (releasecolumn == null) {
                     releasecolumn = new Releasecolumn();
                     releasecolumn.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                     releasecolumn.setColumnname(treeGridSensitiveDataVOchildren.getName());
                     releasecolumn.setProjectid(projectid);
                     releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRuleName());
                     releasecolumn.setTablename(tablename);
                     releasecolumn.setTid(UUID.randomUUID().toString());
                     releasecolumn.setTschema(schema);
                     releasecolumn.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                     Releasecolumn releasecolumnnew = new Releasecolumn();
                     releasecolumnleftlist.add(releasecolumn);
                     releasecolumnrightlist.add(releasecolumnnew);
                  } else {
                     String compare_old = releasecolumn.getChecked() + releasecolumn.getRulename();
                     String compare_new = treeGridSensitiveDataVOchildren.getColumnChecked() + (treeGridSensitiveDataVOchildren.getRuleName() == null ? "" : treeGridSensitiveDataVOchildren.getRuleName());
                     if (!compare_old.equals(compare_new)) {
                        Releasecolumn releasecolumn_left = new Releasecolumn();
                        releasecolumn_left.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                        releasecolumn_left.setColumnname(treeGridSensitiveDataVOchildren.getName());
                        releasecolumn_left.setProjectid(projectid);
                        releasecolumn_left.setRulename(treeGridSensitiveDataVOchildren.getRuleName());
                        releasecolumn_left.setTablename(tablename);
                        releasecolumn_left.setTid(UUID.randomUUID().toString());
                        releasecolumn_left.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                        releasecolumn_left.setTschema(schema);
                        releasecolumnleftlist.add(releasecolumn_left);
                        releasecolumnrightlist.add(releasecolumn);
                     }

                     releasecolumnlist.remove(releasecolumn);
                     maprelease.remove(tablekey_c);
                  }
               }
            }
         }

         Releasecolumn releasecolumnnew = new Releasecolumn();

         for(int i = 0; i < maprelease.entrySet().size(); ++i) {
            releasecolumnleftlist.add(releasecolumnnew);
         }

         releasecolumnrightlist.addAll(releasecolumnlist);
         request.getSession().setAttribute("releasecolumnrightlist", releasecolumnrightlist);
         return releasecolumnleftlist;
      }
   }

   @ResponseBody
   @RequestMapping({"/getfieldattribute"})
   public List<HashMap<String, String>> getfieldattribute(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<HashMap<String, String>> list = this.searchFieldService.getScopeField(parameter);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/getComplianceDirectory"})
   public List<TCoreComplianceDirectory> getComplianceDirectory(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreComplianceDirectory> table = this.searchFieldService.getComplianceDirectory();
      return table;
   }

   @ResponseBody
   @RequestMapping({"/getSensitiveLevel"})
   public List<TCoreSensitiveLevel> getSensitiveLevel(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreSensitiveLevel> table = this.searchFieldService.getSensitiveLevel();
      return table;
   }

   @ResponseBody
   @RequestMapping({"/edit"})
   public TreeGridFiledDataVO edit(String columnNames, String tableName, String schema, String datasystemid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String system_field = columnNames + "#_#" + tableName + "#_#" + schema + "#_#" + datasystemid;
      TreeGridFiledDataVO value = (TreeGridFiledDataVO)this.redisService.get(system_field);
      return value;
   }

   @ResponseBody
   @RequestMapping({"/saveEdit"})
   public void saveEdit(@RequestParam("arrrowid[]") List<String> arrrowid, @RequestParam("directorys[]") List<String> directorys, @RequestParam("sensitives[]") List<String> sensitives, @RequestParam("datascopes[]") List<String> datascopes, HttpServletRequest request, HttpServletResponse response, Model model) {
      for(String system_field : arrrowid) {
         TreeGridFiledDataVO value = (TreeGridFiledDataVO)this.redisService.get(system_field);
         value.setCompliancedirectory(directorys);
         value.setDatascope(datascopes);
         value.setSensitivelevel(sensitives);
      }

   }

   @ResponseBody
   @RequestMapping({"/saveinfo"})
   public void saveinfo(@RequestParam("dataColumList[]") List<String> dataColumList, @RequestParam("datascoTidList[]") List<String> datascoTidList, HttpServletRequest request, HttpServletResponse response, Model model) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      if (datascoTidList == null) {
         datascoTidList = new ArrayList();
      } else if (datascoTidList.size() == 1 && "null".equals(datascoTidList.get(0))) {
         datascoTidList = new ArrayList();
      }

      this.searchFieldService.saveColumnType(dataColumList, datascoTidList, false);
      this.searchFieldService.toSureRedisColumn(dataColumList, datascoTidList);
   }

   @ResponseBody
   @RequestMapping({"/removeinfo"})
   public void removeinfo(String contid, String setuptype, HttpServletRequest request, HttpServletResponse response, Model model) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      this.searchFieldService.removeColumnType(contid, setuptype);
   }

   @ResponseBody
   @RequestMapping({"/getScopeDirectory"})
   public List getScopeDirectory(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreScopeDirectory> list = this.searchFieldService.getScopeDirectory();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/deleteDiscoverytask"})
   public void deleteDiscoverytask(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.searchFieldService.deleteDiscoverytask(id);
   }

   @ResponseBody
   @RequestMapping({"/getTableInfo"})
   public List getTableInfo(String type, String dataSystemId, String tableName, String schemaName, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dataSystemId);
      this.iskeberos(datasystem);
      Connection conn = JdbcTool.getConnection(datasystem);
      List<ColumnInfoVO> columnList = JdbcTool.getColumnInfoVO(conn, schemaName, tableName);
      List<ColumnInfoVO> columnList_all = new ArrayList();
      Object obj = this.redisService.get(tableName + "+" + schemaName);
      new ArrayList();
      List<TCoreFieldSensitiveMemory> tCoreFieldSensitiveMemorylist = (List)obj;
      HashMap<String, String> hash = new HashMap();
      if (tCoreFieldSensitiveMemorylist != null && tCoreFieldSensitiveMemorylist.size() > 0) {
         for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : tCoreFieldSensitiveMemorylist) {
            hash.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
         }
      }

      for(int i = 0; i < columnList.size(); ++i) {
         String column = ((ColumnInfoVO)columnList.get(i)).getColumnname();
         ((ColumnInfoVO)columnList.get(i)).setRegextype(hash.get(column) == null ? "" : (String)hash.get(column));
         String regextype = ((ColumnInfoVO)columnList.get(i)).getRegextype();
         if ("2".equals(type)) {
            if (!"".equals(((ColumnInfoVO)columnList.get(i)).getRemarks())) {
               columnList_all.add(columnList.get(i));
            }
         } else if ("3".equals(type)) {
            if (!"".equals(regextype)) {
               columnList_all.add(columnList.get(i));
            }
         } else {
            columnList_all.add(columnList.get(i));
         }
      }

      return columnList_all;
   }

   @ResponseBody
   @RequestMapping({"/getTableReport"})
   public List getTableReport(String dataSystemId, String tableName, String schemaName, String filedName, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> list = new ArrayList();
      Map<String, String> map = new HashMap();
      String scopeMap = this.searchFieldService.getScopecount(dataSystemId, tableName, schemaName, filedName);
      String sensitiveMap = this.searchFieldService.getSensitivecount(dataSystemId, tableName, schemaName, filedName);
      String complianceMap = this.searchFieldService.getCompliancecount(dataSystemId, tableName, schemaName, filedName);
      map.put("scopecount", scopeMap);
      map.put("sensitivecount", sensitiveMap);
      map.put("compliancecount", complianceMap);
      if (null != filedName && !"".equals(filedName)) {
         map.put("filedName", filedName);
      } else {
         map.put("tablename", tableName);
      }

      list.add(map);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/getScopeinfo"})
   public List getScopeinfo(String dataSystemId, String tableName, String schemaName, String filedName, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> list = new ArrayList();
      new ArrayList();
      List<String> listvalue = this.searchFieldService.getScopeInfo(dataSystemId, tableName, schemaName, filedName);

      for(int i = 0; i < listvalue.size(); ++i) {
         Map<String, String> map = new HashMap();
         map.put("scopename", ((String)listvalue.get(i)).toString());
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/getSensitiveinfo"})
   public List getSensitiveinfo(String dataSystemId, String tableName, String schemaName, String filedName, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> list = new ArrayList();
      new ArrayList();
      List<String> listvalue = this.searchFieldService.getSensitiveInfo(dataSystemId, tableName, schemaName, filedName);

      for(int i = 0; i < listvalue.size(); ++i) {
         Map<String, String> map = new HashMap();
         map.put("sensitivename", ((String)listvalue.get(i)).toString());
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/getComplianceinfo"})
   public List getComplianceinfo(String dataSystemId, String tableName, String schemaName, String filedName, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> list = new ArrayList();
      new ArrayList();
      List<String> listvalue = this.searchFieldService.getComplianceInfo(dataSystemId, tableName, schemaName, filedName);

      for(int i = 0; i < listvalue.size(); ++i) {
         Map<String, String> map = new HashMap();
         map.put("compliancename", ((String)listvalue.get(i)).toString());
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/exportToExceltoLog11"})
   public ResultVO exportToExceltoLog11(@RequestParam Map<String, Object> dataall, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      String userAgent = request.getHeader("User-Agent");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("fieldreportformDir");
      SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHMMSS");
      String fileName = df.format(new Date()) + ".xlsx";
      path = path + fileName;
      XSSFWorkbook wb = new XSSFWorkbook();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      String dataSystemId = (String)dataall.get("dataall[dataSystemId]");
      String tableName = (String)dataall.get("dataall[tableName]");
      String schemaName = (String)dataall.get("dataall[schemaName]");
      String filedName = (String)dataall.get("dataall[filedName]");
      List<String> scopelist = this.searchFieldService.getScopeInfo(dataSystemId, tableName, schemaName, filedName);
      List<String> sensitivelist = this.searchFieldService.getSensitiveInfo(dataSystemId, tableName, schemaName, filedName);
      List<String> compliancelist = this.searchFieldService.getComplianceInfo(dataSystemId, tableName, schemaName, filedName);
      Map<String, List<String>> map = new HashMap();
      map.put("分类", scopelist);
      map.put("分级", sensitivelist);
      map.put("合规", compliancelist);

      for(Map.Entry<String, List<String>> entry : map.entrySet()) {
         LinkedBlockingQueue<HashMap<String, String>> queue = new LinkedBlockingQueue();
         List<String> list1 = (List)entry.getValue();
         String sheetname = (String)entry.getKey();

         for(int i = 0; i < list1.size(); ++i) {
            try {
               HashMap<String, String> hashmap = new HashMap();
               hashmap.put("name", list1.get(i));
               queue.put(hashmap);
            } catch (InterruptedException e) {
               e.printStackTrace();
            }
         }

         Map<String, String> titlevalue = new LinkedHashMap();
         titlevalue.put("名称", "name");
         List<Integer> columnWidthList = new ArrayList();
         columnWidthList.add(2200);
         ExcelTool.generateSheetExcel(wb, path, queue, titlevalue, columnWidthList, (List)null, sheetname);
      }

      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/discoverytasklist"})
   public List<DiscoverytaskVO> discoveryTaskList(String datasystemid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<DiscoverytaskVO> list = this.discoverytaskService.discoveryTaskList(datasystemid);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/discoverydataarealist"})
   public List<TcoreDiscoverySensitivecolumn> discoveryDataAreaList(String versions, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      Set<TcoreDiscoverySensitivecolumn> set = new HashSet();
      if (versions != null && !"".equals(versions)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         String ver = versions.split("/")[0];
         if ("AllVersion".equals(ver)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(ver)) {
            File file = new File(props.getProperty("ProjectVersion") + versions.split("/")[1]);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + versions.split("/")[1] + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(ver)) {
            filepath = props.getProperty("TaskVersion") + versions.split("/")[1] + "/" + versions.split("/")[2];
         }

         if (FileTool.isFileExit(filepath)) {
            InputStreamReader newRead = null;

            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e1) {
               e1.printStackTrace();
            } catch (FileNotFoundException e1) {
               e1.printStackTrace();
            }

            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] str = null;

            try {
               while((newInformationLine = newBufferedReader.readLine()) != null) {
                  TcoreDiscoverySensitivecolumn tDS = new TcoreDiscoverySensitivecolumn();
                  str = newInformationLine.split(",", -1);
                  if (!"".equals(str[4])) {
                     tDS.setDatadomainId(str[3]);
                     tDS.setDatadomainName(str[4]);
                     set.add(tDS);
                  }
               }

               list = new ArrayList(set);
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setDatadomainId("0");
               tcoreDiscoverySensitivecolumn.setDatadomainName("全选");
               list.add(0, tcoreDiscoverySensitivecolumn);
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               a(newBufferedReader, newRead);
            }
         }
      }

      return list;
   }

   private static void a(Closeable... closeables) {
      if (closeables != null) {
         try {
            for(Closeable closeable : closeables) {
               if (closeable != null) {
                  closeable.close();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @ResponseBody
   @RequestMapping({"/removesingle"})
   public void removeSingle(String setuptype, String singleid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.searchFieldService.removeSingle(setuptype, singleid);
   }

   public String isDatascope(String isDatascope) {
      String tableClass = "";
      switch (isDatascope) {
         case "1":
            tableClass = "t_core_scope_field";
            break;
         case "2":
            tableClass = "t_core_field_directory";
            break;
         case "3":
            tableClass = "t_core_field_sensitive";
      }

      return tableClass;
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }

   @ResponseBody
   @RequestMapping({"/queryTask"})
   public Response<List<ComboboxVO>> queryTask(@RequestBody ComplianceDirectoryVO vo) {
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      StringBuffer str = new StringBuffer();
      File[] f = taskfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         str.append("'" + f[i].getName() + "'" + ',');
      }

      List<ComboboxVO> list = this.tdataProjectService.queryTaskList(str.substring(0, str.length() - 1), vo.getProjectId());
      return RespHelper.<List<ComboboxVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersion"})
   public Response queryTaskVersion(String taskid) {
      List<Map<String, String>> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion") + taskid);
      String str = "";
      if (taskfile.listFiles() != null) {
         File[] f = taskfile.listFiles();

         for(int i = 0; i < f.length; ++i) {
            str = f[i].getName().split("\\.txt")[0];
            String username = str.substring(str.lastIndexOf("_") + 1);
            String s = str.replace("_" + username, "");
            String datetime = s.substring(s.lastIndexOf("_") + 1);
            String versionname = s.replace("_" + datetime, "");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
            Map<String, String> map1 = new HashMap();
            map1.put("versionname", versionname);
            map1.put("datetime", sd);
            map1.put("username", username);
            map1.put("filename", f[i].getName());
            list.add(map1);
         }
      }

      return RespHelper.successResp(list);
   }

   public String TimeStamp2Date(String timestampString, String formats) {
      if (TextUtils.isEmpty(formats)) {
         formats = "yyyy-MM-dd HH:mm:ss";
      }

      Long timestamp = Long.parseLong(timestampString) * 1000L;
      String date = (new SimpleDateFormat(formats, Locale.CHINA)).format(new Date(timestamp));
      return date;
   }

   @ResponseBody
   @RequestMapping({"/getselectedcolumn"})
   public Response<Map<String, Object>> getselectedcolumnallsave(@RequestBody FeildScopeReqVO vo) throws SQLException {
      String datasystemid = vo.getDatasystemid();
      String schema = vo.getSchema();
      String fieldname = vo.getFieldname();
      String pageSize = vo.getPageSize();
      String pageNo = vo.getPageNo();
      Map<String, Object> map = new HashMap();
      if (CacheUtil.cacheManager.containsKey("filter_name_" + datasystemid + "_" + schema + "_" + fieldname)) {
         List<Map<String, String>> list = (List)CacheUtil.getCacheValue("filter_name_" + datasystemid + "_" + schema + "_" + fieldname);
         int datacount = list.size();
         List<Map<String, String>> collect = (List)list.stream().skip((long)(Integer.parseInt(pageSize) * (Integer.parseInt(pageNo) - 1))).limit((long)Integer.parseInt(pageSize)).collect(Collectors.toList());
         map.put("pageSize", pageSize);
         map.put("pageSize", pageNo);
         map.put("datacount", datacount);
         map.put("data", collect);
      }

      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      this.iskeberos(datasystem);
      Connection connection = JdbcTool.getConnection(datasystem);
      List<Map<String, String>> list = new ArrayList();
      StringBuilder str = new StringBuilder();
      ResultSet rs = null;
      PreparedStatement ps = null;
      str = this.searchColumnDiffDatasource(str, fieldname, schema, datasystem.getDbtype());
      ps = connection.prepareStatement(str.toString(), 1003, 1007);
      ps.setFetchSize(30000);
      rs = ps.executeQuery();

      while(rs.next()) {
         Map<String, String> colmap = new HashMap();
         colmap.put("tablename", rs.getString("table_name"));
         colmap.put("columnname", rs.getString("column_name"));
         list.add(colmap);
      }

      connection.close();
      int datacount = list.size();
      List<Map<String, String>> collect = (List)list.stream().skip((long)(Integer.parseInt(pageSize) * (Integer.parseInt(pageNo) - 1))).limit((long)Integer.parseInt(pageSize)).collect(Collectors.toList());
      CacheUtil.put("filter_name_" + datasystemid + "_" + schema + "_" + fieldname, list);
      map.put("pageSize", pageSize);
      map.put("pageNo", pageNo);
      map.put("datacount", datacount);
      map.put("data", collect);
      return RespHelper.<Map<String, Object>>successResp(map);
   }

   private StringBuilder searchColumnDiffDatasource(StringBuilder str, String fieldname, String schema, String dbtype) {
      if ("MYSQL".equals(dbtype)) {
         str.append("select table_name,column_name from information_schema.columns where (1=2");
         if (StringUtils.isNotBlank(fieldname)) {
            str.append(" or column_name ='" + fieldname + "'");
         }

         str.append(")  and table_schema=");
         str.append("'" + schema + "'");
      } else if ("MSSQLSERVER".equals(dbtype)) {
         str.append("SELECT d.name table_name, a.name column_name FROM syscolumns a LEFT JOIN systypes b ON a.usertype = b.usertype INNER JOIN sysobjects d ON a.id = d.id AND d.name <> 'dtproperties' LEFT JOIN syscomments e ON a.cdefault = e.id WHERE  (1=2");
         if (StringUtils.isNotBlank(fieldname)) {
            str.append(" or a.name ='" + fieldname + "'");
         }

         str.append(")");
      } else if ("INFORMIX".equals(dbtype)) {
         str.append("select a.tabname table_name,b.colname column_name from systables a left join syscolumns b on a.tabid=b.tabid where  (1=2");
         if (StringUtils.isNotBlank(fieldname)) {
            str.append(" or b.colname ='" + fieldname + "'");
         }

         str.append(")");
      } else if (!"SYBASE_IQ".equals(dbtype)) {
         if ("SYBASE".equals(dbtype)) {
            str.append("SELECT d.name table_name, a.name column_name FROM syscolumns a LEFT JOIN systypes b ON a.usertype = b.usertype INNER JOIN sysobjects d ON a.id = d.id AND d.name <> 'dtproperties' LEFT JOIN syscomments e ON a.cdefault = e.id WHERE  (1=2");
            if (StringUtils.isNotBlank(fieldname)) {
               str.append(" or a.name ='" + fieldname + "'");
            }

            str.append(")");
         } else if ("ORACLE".equals(dbtype)) {
            str.append("select table_name,column_name from all_tab_columns where (1=2");
            if (StringUtils.isNotBlank(fieldname)) {
               str.append(" or column_name ='" + fieldname + "'");
            }

            str.append(")  and OWNER=");
            str.append("Upper('" + schema + "')");
         } else if ("DB2".equals(dbtype)) {
            str.append("select table_name,column_name from sysibm.columns where (1=2");
            if (StringUtils.isNotBlank(fieldname)) {
               str.append(" or column_name ='" + fieldname + "'");
            }

            str.append(")  and table_schema =");
            str.append("'" + schema + "'");
         } else if ("TERADATA".equals(dbtype)) {
            str.append("select TableName table_name,ColumnName column_name from dbc.columns where (1=2");
            if (StringUtils.isNotBlank(fieldname)) {
               str.append(" or ColumnName ='" + fieldname + "'");
            }

            str.append(")  and DatabaseName =");
            str.append("'" + schema + "'");
         } else if ("OCEANBASE".equals(dbtype)) {
            str.append("select * from user_tab_columns WHERE TABLE_NAME IN ('");
            if (StringUtils.isNotBlank(fieldname)) {
               str.append(fieldname + "','");
            }

            str = str.delete(str.length() - 2, str.length());
            str.append(")");
         }
      }

      return str;
   }

   @ResponseBody
   @RequestMapping({"/getlayscopetable"})
   public Response<List<Object>> getLayScopeTable(@RequestBody FeildScopeReqVO vo) {
      Map<String, Object> datacolum = new HashMap();
      List<DataScopeVO> dataScopeList = this.dataScopeService.getScopeTable(vo.getEditionid());
      datacolum.put("setuptype", vo.getSetuptype());
      datacolum.put("version", vo.getVersion());
      datacolum.put("projectId", vo.getProjectId());
      datacolum.put("datasystemid", vo.getDatasystemid());
      datacolum.put("field", vo.getField());
      datacolum.put("table", vo.getTable());
      datacolum.put("schema", vo.getSchema());
      List<HashMap<String, String>> fieldScopelist = this.searchFieldService.getScopeField(datacolum);
      List<String> fieldScopeIdList = new ArrayList();

      for(HashMap<String, String> fieldScope : fieldScopelist) {
         fieldScopeIdList.add(fieldScope.get("roottid"));
      }

      List<Object> returnList = new ArrayList();

      for(DataScopeVO ltl : dataScopeList) {
         JSONObject treeObj = new JSONObject();
         treeObj.put("id", ltl.getTid());
         treeObj.put("title", ltl.getText());
         treeObj.put("spread", true);
         if (fieldScopeIdList.contains(ltl.getTid())) {
            treeObj.put("checked", true);
         }

         if (ltl.getChildren() != null) {
            treeObj.put("children", this.getChildren(ltl.getTid(), ltl.getChildren(), fieldScopeIdList));
         }

         returnList.add(treeObj);
      }

      return RespHelper.<List<Object>>successResp(returnList);
   }

   public List<Object> getChildren(String Id, List<DataScopeVO> fileDirectories, List<String> fieldScopeIdList) {
      List<Object> list = new ArrayList();

      for(DataScopeVO f : fileDirectories) {
         JSONObject obj = new JSONObject();
         obj.put("id", f.getTid());
         obj.put("title", f.getText());
         obj.put("pid", Id);
         obj.put("spread", true);
         if (fieldScopeIdList.contains(f.getTid())) {
            obj.put("checked", true);
         }

         if (f.getChildren() != null) {
            obj.put("children", this.getChildren(f.getId(), f.getChildren(), fieldScopeIdList));
         }

         list.add(obj);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/batchsave"})
   public Response<String> batchsave(@RequestBody Map<String, Object> map, HttpServletRequest request, HttpServletResponse response) {
      String fieldname = (String)map.get("fieldName");
      String flag = (String)map.get("flag");
      String schema = (String)map.get("schema");
      String datasystemid = (String)map.get("datasystemid");
      String projectid = (String)map.get("projectid");
      String editionid = (String)map.get("editionid");
      String username = TokenUtil.getUserId(request.getHeader("token"));
      List<Map<String, String>> list = null;
      if ("1".equals(flag) && CacheUtil.cacheManager.containsKey("filter_name_" + datasystemid + "_" + schema + "_" + fieldname)) {
         list = (List)CacheUtil.getCacheValue("filter_name_" + datasystemid + "_" + schema + "_" + fieldname);
      }

      list.forEach((data) -> {
         String tablename = (String)data.get("tablename");
         String columnname = (String)data.get("columnname");
         String schemaname = schema;
         List<Map<String, String>> scopelist = (List)map.get("scope");
         List<String> datascoTidList = new ArrayList();
         List<String> dataColumList = new ArrayList();
         dataColumList.add(datasystemid);
         dataColumList.add(columnname);
         dataColumList.add(tablename);
         dataColumList.add(schema);
         dataColumList.add("1");
         dataColumList.add(editionid);
         dataColumList.add(projectid);
         dataColumList.add(username);
         scopelist.forEach((scopeinfo) -> datascoTidList.add(scopeinfo.get("scopeid")));
         Map<String, String> scopeLevel = (Map)map.get("scopelevel");
         List<String> datascoLevelTidList = new ArrayList();
         List<String> dataLevelColumList = new ArrayList();
         dataLevelColumList.add(datasystemid);
         dataLevelColumList.add(columnname);
         dataLevelColumList.add(tablename);
         dataLevelColumList.add(schema);
         dataLevelColumList.add("3");
         dataLevelColumList.add(editionid);
         dataLevelColumList.add(projectid);
         dataLevelColumList.add(username);
         String id = (String)scopeLevel.get("id");
         datascoLevelTidList.add(id);

         try {
            String _catagoryids = "";
            String _levelid = "";
            List<TCoreScopeField> tCoreScopeFields = this.tCoreScopeFieldDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename), Restrictions.eq("tablefield_id", fieldname), Restrictions.eq("edition_id", editionid)});
            if (CollectionUtil.isNotEmpty(tCoreScopeFields)) {
               List<String> collect = (List)tCoreScopeFields.stream().map(TCoreScopeField::getScope_id).collect(Collectors.toList());
               _catagoryids = (String)collect.stream().collect(Collectors.joining(","));
            }

            List<TCoreFieldSensitive> tCoreFieldSensitives = this.tCoreFieldSensitiveDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename), Restrictions.eq("tablefield_id", fieldname), Restrictions.eq("edition_id", editionid)});
            if (CollectionUtil.isNotEmpty(tCoreFieldSensitives)) {
               _levelid = ((TCoreFieldSensitive)tCoreFieldSensitives.get(0)).getScope_id();
            }

            this.searchFieldService.saveColumnType(dataColumList, datascoTidList, false);
            this.searchFieldService.saveColumnType(dataLevelColumList, datascoLevelTidList, false);
            this.searchFieldService.addScopeLog(dataColumList, datascoTidList, editionid, datascoLevelTidList, dataLevelColumList);
            String bindtype = "2";
            if (StringUtils.isNotBlank(_catagoryids) || StringUtils.isNotBlank(_levelid)) {
               this.tcoreCatacoryLevelLogService.save(projectid, editionid, datasystemid, schemaname, tablename, fieldname, _catagoryids, _levelid, "2", bindtype, username, "", new Date(), (Date)null);
            }

            String catagoryids = (String)datascoTidList.stream().collect(Collectors.joining(","));
            this.tcoreCatacoryLevelLogService.save(projectid, editionid, datasystemid, schemaname, tablename, fieldname, catagoryids, id, "1", bindtype, username, "", new Date(), (Date)null);
         } catch (IllegalAccessException e) {
            e.printStackTrace();
         } catch (InvocationTargetException e) {
            e.printStackTrace();
         }

      });
      return RespHelper.<String>successResp();
   }

   @ResponseBody
   @RequestMapping({"/getfieldnames"})
   public Response<List<ScopeInfoVO>> getfieldnames(@RequestBody Map<String, String> map) {
      String projectid = (String)map.get("projectId");
      String id = (String)map.get("id");
      String schema = (String)map.get("schema");
      String tablename = (String)map.get("tableName");
      String editionid = (String)map.get("editionid");
      String datasystemid = id.replace(tablename, "");
      return RespHelper.<List<ScopeInfoVO>>successResp(this.queryColumnInfo(projectid, editionid, editionid, datasystemid, schema, tablename));
   }

   public List<ScopeInfoVO> queryColumnInfo(String projectid, String scope_category, String scope_level, String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<TCoreScopeField> tCoreScopeFields = this.dataScopeService.queryScopeById(projectid, datasystemid, scope_category);
         List<TCoreFieldSensitive> tCoreFieldSensitives = this.dataScopeService.queryScopeLevelById(projectid, datasystemid, scope_level);
         tCoreScopeFields = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName) && x.getTschemas().equals(schema)).collect(Collectors.toList());
         tCoreFieldSensitives = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName)).collect(Collectors.toList());
         List<ScopeInfoVO> list1 = new ArrayList();
         String scopeeditedflag = "0";
         String leveleditedflag = "0";
         if (tCoreScopeFields.size() > 0) {
            scopeeditedflag = "1";
         }

         if (tCoreFieldSensitives.size() > 0) {
            leveleditedflag = "1";
         }

         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               ScopeInfoVO civ1 = new ScopeInfoVO();
               BeanUtils.copyProperties(civ, civ1);
               List<TCoreScopeField> tCoreScopeFieldlist = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               List<TCoreDataScope> list2 = new ArrayList();
               tCoreScopeFieldlist.forEach((tCoreScopeField) -> {
                  TCoreDataScope tCoreDataScope = new TCoreDataScope();
                  String scope_id = tCoreScopeField.getScope_id();
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scope_id);
                  tCoreDataScope.setScope_id(scope_id);
                  tCoreDataScope.setScope_name((String)scopenamemap.get("scope_name"));
                  list2.add(tCoreDataScope);
               });
               civ1.settCoreDataScopeList(list2);
               List<TCoreFieldSensitive> tCoreFieldSensitivelist = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               String scope_id = "";
               if (tCoreScopeFieldlist.size() > 0) {
                  scope_id = ((TCoreFieldSensitive)tCoreFieldSensitivelist.get(0)).getScope_id();
               }

               TCoreSensitiveLevel tCoreSensitiveLevel = new TCoreSensitiveLevel();
               if (StringUtils.isNotBlank(scope_id)) {
                  tCoreSensitiveLevel.setSensitive_id(scope_id);
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scope_id);
                  tCoreSensitiveLevel.setSensitive_name((String)scopenamemap.get("sensitive_name"));
               }

               civ1.settCoreSensitiveLevel(tCoreSensitiveLevel);
               if (!"1".equals(scopeeditedflag) && !"1".equals(leveleditedflag)) {
                  civ1.setFlag("0");
               } else {
                  civ1.setFlag("1");
               }

               list1.add(civ1);
            }
         } else {
            for(ColumnInfoVO civ : list) {
               ScopeInfoVO civ1 = new ScopeInfoVO();
               BeanUtils.copyProperties(civ, civ1);
               List<TCoreScopeField> tCoreScopeFieldlist = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               List<TCoreDataScope> list2 = new ArrayList();
               if (tCoreScopeFieldlist.size() > 0) {
                  scopeeditedflag = "1";
               }

               tCoreScopeFieldlist.forEach((tCoreScopeField) -> {
                  TCoreDataScope tCoreDataScope = new TCoreDataScope();
                  String scope_id = tCoreScopeField.getScope_id();
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scope_id);
                  tCoreDataScope.setScope_id(scope_id);
                  tCoreDataScope.setScope_name((String)scopenamemap.get("scope_name"));
                  list2.add(tCoreDataScope);
               });
               civ1.settCoreDataScopeList(list2);
               List<TCoreFieldSensitive> tCoreFieldSensitivelist = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               String scope_id = "";
               if (tCoreFieldSensitivelist.size() > 0) {
                  scope_id = ((TCoreFieldSensitive)tCoreFieldSensitivelist.get(0)).getScope_id();
                  leveleditedflag = "1";
               }

               TCoreSensitiveLevel tCoreSensitiveLevel = new TCoreSensitiveLevel();
               if (StringUtils.isNotBlank(scope_id)) {
                  tCoreSensitiveLevel.setSensitive_id(scope_id);
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scope_id);
                  tCoreSensitiveLevel.setSensitive_name((String)scopenamemap.get("sensitive_name"));
               }

               civ1.settCoreSensitiveLevel(tCoreSensitiveLevel);
               if (!"1".equals(scopeeditedflag) && !"1".equals(leveleditedflag)) {
                  civ1.setFlag("0");
               } else {
                  civ1.setFlag("1");
               }

               list1.add(civ1);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return list1;
      }
   }

   @ResponseBody
   @RequestMapping({"/save"})
   public Response<String> save(@RequestBody Map<String, Object> map, HttpServletRequest request, HttpServletResponse response) {
      String projectid = (String)map.get("projectId");
      String dataSystemid = (String)map.get("datasystemid");
      String editionid = (String)map.get("editionid");
      String username = TokenUtil.getUserId(request.getHeader("token"));
      ((Map)map.get("map")).forEach((k, v) -> {
         String[] split = k.toString().split("\\.");
         String schemaname = split[0];
         String tablename = split[1];
         String fieldname = split[2];
         List<Map<String, String>> scopelist = (List)((Map)v).get("scope");
         List<String> datascoTidList = new ArrayList();
         List<String> dataColumList = new ArrayList();
         dataColumList.add(dataSystemid);
         dataColumList.add(fieldname);
         dataColumList.add(tablename);
         dataColumList.add(schemaname);
         dataColumList.add("1");
         dataColumList.add(editionid);
         dataColumList.add(projectid);
         dataColumList.add(username);
         dataColumList.add("");
         scopelist.forEach((scopeinfo) -> datascoTidList.add(scopeinfo.get("scopeid")));
         Map<String, String> scopeLevel = (Map)((Map)v).get("scopelevel");
         List<String> datascoLevelTidList = new ArrayList();
         List<String> dataLevelColumList = new ArrayList();
         dataLevelColumList.add(dataSystemid);
         dataLevelColumList.add(fieldname);
         dataLevelColumList.add(tablename);
         dataLevelColumList.add(schemaname);
         dataLevelColumList.add("3");
         dataLevelColumList.add(editionid);
         dataLevelColumList.add(projectid);
         dataLevelColumList.add(username);
         dataLevelColumList.add("");
         String id = (String)scopeLevel.get("id");
         datascoLevelTidList.add(id);

         try {
            String _catagoryids = "";
            String _levelid = "";
            List<TCoreScopeField> tCoreScopeFields = this.tCoreScopeFieldDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", dataSystemid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename), Restrictions.eq("tablefield_id", fieldname), Restrictions.eq("edition_id", editionid)});
            if (CollectionUtil.isNotEmpty(tCoreScopeFields)) {
               List<String> collect = (List)tCoreScopeFields.stream().map(TCoreScopeField::getScope_id).collect(Collectors.toList());
               _catagoryids = (String)collect.stream().collect(Collectors.joining(","));
            }

            List<TCoreFieldSensitive> tCoreFieldSensitives = this.tCoreFieldSensitiveDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", dataSystemid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename), Restrictions.eq("tablefield_id", fieldname), Restrictions.eq("edition_id", editionid)});
            if (CollectionUtil.isNotEmpty(tCoreFieldSensitives)) {
               _levelid = ((TCoreFieldSensitive)tCoreFieldSensitives.get(0)).getScope_id();
            }

            this.searchFieldService.saveColumnType(dataColumList, datascoTidList, false);
            this.searchFieldService.saveColumnType(dataLevelColumList, datascoLevelTidList, false);
            this.searchFieldService.addScopeLog(dataColumList, datascoTidList, editionid, datascoLevelTidList, dataLevelColumList);
            String bindtype = "3";
            if (StringUtils.isNotBlank(_catagoryids) || StringUtils.isNotBlank(_levelid)) {
               this.tcoreCatacoryLevelLogService.save(projectid, editionid, dataSystemid, schemaname, tablename, fieldname, _catagoryids, _levelid, "2", bindtype, username, "", new Date(), (Date)null);
            }

            String catagoryids = (String)datascoTidList.stream().collect(Collectors.joining(","));
            this.tcoreCatacoryLevelLogService.save(projectid, editionid, dataSystemid, schemaname, tablename, fieldname, catagoryids, id, "1", bindtype, username, "", new Date(), (Date)null);
         } catch (IllegalAccessException e) {
            e.printStackTrace();
         } catch (InvocationTargetException e) {
            e.printStackTrace();
         }

      });
      return RespHelper.<String>successResp();
   }

   @ResponseBody
   @RequestMapping({"/getSystemdataInfo"})
   public Response getSystemdataInfo(String flag, String id, String projectid) {
      DataSystemConfig tCoreDatasystem = this.dataSystemService.queryByFlagById(flag, id);
      DataSystemInfoVO vo = new DataSystemInfoVO();
      BeanUtils.copyProperties(tCoreDatasystem, vo);
      TCoreDataProject tCoreDataProject = this.tdataProjectService.selectOneDataProject(projectid);
      vo.setProjectname(tCoreDataProject.getProject());
      vo.setEdition_id(tCoreDataProject.getEdition_id());
      EditionProjectVO editpeproject = this.dataScopeService.editpeproject(tCoreDataProject.getEdition_id());
      vo.setEdition_name(editpeproject.getEdition_name());
      return RespHelper.successResp(vo);
   }

   @ResponseBody
   @RequestMapping({"/gettableinfo"})
   public Response getTableInfo(String flag, String id, String projectid, String schemaname, String tablename) {
      Map<String, Object> map = new HashMap();
      Connection conn = this.dataSystemService.getConnectionByDataSystemId(id);
      String tableComment = JdbcTool.getTableComment(conn, schemaname, tablename);
      DutyPersonVO vo = new DutyPersonVO();
      vo.setDuty_scope("1");
      vo.setDatasystemid(id);
      List<DutyPersonVO> dutyPersonVOS = this.userService.selectDutyPerson(vo);
      String businessLead = "";
      String techLead = "";
      Date lasttime = null;
      String lastuser = null;

      for(DutyPersonVO dutyPersonVO : dutyPersonVOS) {
         businessLead = businessLead + dutyPersonVO.getRealname() + ",";
      }

      if (businessLead.length() > 0) {
         businessLead = businessLead.substring(0, businessLead.length() - 1);
      }

      vo.setDuty_scope("2");

      for(DutyPersonVO dutyPersonVO : this.userService.selectDutyPerson(vo)) {
         techLead = techLead + dutyPersonVO.getRealname() + ",";
      }

      if (techLead.length() > 0) {
         techLead = techLead.substring(0, techLead.length() - 1);
      }

      List<TCoreScopeField> tCoreScopeFieldInfo = this.dataScopeService.getTCoreScopeFieldInfo(id, projectid, schemaname, tablename);
      Date updatetime1 = null;
      String updateuser1 = null;
      Date createtime1 = null;
      String createuser1 = null;
      if (tCoreScopeFieldInfo.size() > 0) {
         updatetime1 = ((TCoreScopeField)tCoreScopeFieldInfo.get(0)).getUpdatetime();
         updateuser1 = ((TCoreScopeField)tCoreScopeFieldInfo.get(0)).getUpdateuser();
         createtime1 = ((TCoreScopeField)tCoreScopeFieldInfo.get(0)).getCreatetime();
         createuser1 = ((TCoreScopeField)tCoreScopeFieldInfo.get(0)).getCreateuser();
      }

      List<TCoreFieldSensitive> tCoreFieldSensitiveInfo = this.dataScopeService.getTCoreFieldSensitiveInfo(id, projectid, schemaname, tablename);
      boolean isScopeLen = true;
      Date updatetime2 = null;
      String updateuser2 = null;
      Date createtime2 = null;
      String createuser2 = null;
      if (tCoreFieldSensitiveInfo.size() > 0) {
         updatetime2 = ((TCoreFieldSensitive)tCoreFieldSensitiveInfo.get(0)).getUpdatetime();
         updateuser2 = ((TCoreFieldSensitive)tCoreFieldSensitiveInfo.get(0)).getUpdateuser();
         createtime2 = ((TCoreFieldSensitive)tCoreFieldSensitiveInfo.get(0)).getCreatetime();
         createuser2 = ((TCoreFieldSensitive)tCoreFieldSensitiveInfo.get(0)).getCreateuser();
      }

      Date lasttime1 = updatetime1;
      String lastuser1 = updateuser1;
      if (updatetime1 == null) {
         lasttime1 = createtime1;
         lastuser1 = createuser1;
      }

      Date lasttime2 = updatetime2;
      String lastuser2 = updateuser2;
      if (updatetime2 == null) {
         lasttime2 = createtime2;
         lastuser2 = createuser2;
      }

      if (lasttime1 != null && lasttime2 != null) {
         int i = lasttime1.compareTo(lasttime2);
         if (i < 0) {
            lasttime = lasttime2;
            lastuser = lastuser2;
         } else {
            lasttime = lasttime1;
            lastuser = lastuser1;
         }
      } else if (lasttime1 == null && lasttime2 != null) {
         lasttime = lasttime2;
         lastuser = lastuser2;
      } else if (lasttime1 != null && lasttime2 == null) {
         lasttime = lasttime1;
         lastuser = lastuser1;
      } else if (lasttime1 == null && lasttime2 == null) {
         isScopeLen = false;
      }

      List<Map<String, Object>> list = new ArrayList();

      for(TCoreFieldSensitive tCoreFieldSensitive : tCoreFieldSensitiveInfo) {
         Map<String, Object> map1 = this.sensitiveLevelService.getSensitiveInfo(tCoreFieldSensitive.getScope_id());
         list.add(map1);
      }

      String maxLevel = "";
      Map<String, String> map2 = new HashMap();
      List<Character> list1 = new ArrayList();

      for(Map<String, Object> objectMap : list) {
         if (objectMap.size() != 0) {
            String open_level = objectMap.get("open_level").toString();
            String sensitive_name = objectMap.get("sensitive_name").toString();
            map2.put(open_level, sensitive_name);
            list1.add((Character)objectMap.get("open_level"));
         }
      }

      if (list1.size() > 0) {
         String s = ((Character)Collections.min(list1)).toString();
         maxLevel = (String)map2.get(s);
      }

      map.put("tableComment", tableComment);
      map.put("businessLead", businessLead);
      map.put("techLead", techLead);
      map.put("lasttime", lasttime);
      map.put("lastuser", lastuser);
      map.put("isScopeLen", isScopeLen);
      map.put("maxlevel", maxLevel);
      return RespHelper.successResp(map);
   }
}
