package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreGeneratedata;
import com.chenyang.nse.bussiness.service.core.GeneratedataService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/generatedata"})
public class GeneratedatatController {
   private static final String Link_character = "_";
   @Autowired
   private GeneratedataService generatedataService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private HttpServletRequest request;

   @RequestMapping
   public String index(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datamap/generatedata/generatedatalist";
   }

   @ResponseBody
   @RequestMapping({"/getgeneratedatatlist"})
   public List<TCoreGeneratedata> queryByPageInfo(String index, PageInfo pageInfo, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreGeneratedata> list = this.generatedataService.queryByPageInfo(pageInfo);
      return list;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("id", (String)this.request.getSession().getAttribute("id"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "generatedata_one":
            this.generatedata_one(map, model);
            break;
         case "generatedata_two":
            this.generatedata_two(map, model);
            break;
         case "generatedata_three":
            this.generatedata_three(map, model);
      }

      return "core/datamap/generatedata/" + step;
   }

   public void generatedata_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String id = (String)map.get("id");
      if (newtask == null) {
         TCoreGeneratedata tCoreGeneratedata = new TCoreGeneratedata();
         tCoreGeneratedata = (TCoreGeneratedata)this.redisService.get(id + "_" + tCoreGeneratedata.getClass().getSimpleName());
         if (tCoreGeneratedata != null) {
            model.addAttribute("generatedataname", tCoreGeneratedata.getGeneratedataname());
            model.addAttribute("note", tCoreGeneratedata.getNote());
         }
      }

   }

   public void generatedata_two(Map<String, String> map, Model model) {
      new TCoreGeneratedata();
      if (((String)map.get("way")).equals("prev")) {
         String var4 = (String)map.get("id");
      } else if (((String)map.get("way")).equals("next")) {
      }

   }

   public void generatedata_three(Map<String, String> map, Model model) {
      new TCoreGeneratedata();
      if (((String)map.get("way")).equals("next")) {
         String var4 = (String)map.get("id");
      }

   }

   public void savegeneratedata(Map<String, String> map, Model model) {
   }
}
