package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngineServerInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreServerInfoStatus;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreServerInfoVO;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreServiceStatus;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.EngineServerInfoService;
import com.chenyang.nse.bussiness.service.core.ServerInfoStatusService;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@EnableAsync
@Controller
@RequestMapping({"/core/haserverinfo"})
public class HaServerInfoController {
   private static Logger logger = LoggerFactory.getLogger(HaServerInfoController.class);
   @Autowired
   private EngineServerInfoService tCoreEngineServerInfoService;
   @Autowired
   private ServerInfoStatusService serverInfoStatusService;
   @Autowired
   private HttpServletRequest request;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      return "core/haserverinfo/haserverinfolist";
   }

   @RequestMapping({"/serverinfolist"})
   public String serverinfolist(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      return "core/haserverinfo/serverinfolist";
   }

   @RequestMapping({"/serverinfo"})
   public String serverinfo(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      return "core/haserverinfo/serverinfo";
   }

   @RequestMapping({"/queryserver"})
   @ResponseBody
   public DataGridVO<TCoreServerInfoStatus> queryserver(String servername, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreServerInfoStatus> list = this.serverInfoStatusService.queryTask(servername, pageInfo);
      DataGridVO<TCoreServerInfoStatus> vo = new DataGridVO<TCoreServerInfoStatus>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/queryserverinfo"})
   @ResponseBody
   public DataGridVO<TCoreServerInfoVO> queryserverinfo(String servername, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreServerInfoVO> list = this.serverInfoStatusService.queryAllServer();
      DataGridVO<TCoreServerInfoVO> vo = new DataGridVO<TCoreServerInfoVO>(0L, list);
      return vo;
   }

   @RequestMapping({"/createServer"})
   public String createServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      return "core/haserverinfo/createserver";
   }

   @RequestMapping({"/saveServerInfo"})
   @ResponseBody
   public String saveServerInfo(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
      this.serverInfoStatusService.updateServerInfo(map, loginUser.getTsysUser().getUsername());
      this.serverInfoStatusService.saveHaServer(map);
      this.tCoreEngineServerInfoService.saveEngineServer(map);
      if ("1".equals(map.get("iprimaryserver"))) {
         this.serverInfoStatusService.setPrimaryServerById((String)map.get("haid"));
      }

      return "SUCCESS";
   }

   @RequestMapping({"/saveServer"})
   public String saveServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      this.serverInfoStatusService.saveHaServer(map);
      model.addAttribute("toPageCurr", 1);
      return "core/haserverinfo/haserverinfolist";
   }

   @RequestMapping({"/editServer"})
   public String editServer(HttpServletRequest request, Model model, String serverid, Integer pageCurr) {
      model.addAttribute("serverid", serverid);
      model.addAttribute("pageCurr", pageCurr);
      TCoreServerInfoStatus tCoreServerInfoStatus = this.serverInfoStatusService.queryServerById(serverid);
      model.addAttribute("info", tCoreServerInfoStatus);
      return "core/haserverinfo/editserver";
   }

   @RequestMapping({"/updateServer"})
   public String updateServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      this.serverInfoStatusService.updateHaServer(map);
      model.addAttribute("toPageCurr", 1);
      return "core/haserverinfo/haserverinfolist";
   }

   @RequestMapping({"/setPrimaryServer"})
   public String setPrimaryServer(HttpServletRequest request, HttpServletResponse response, Model model, String serverid, Integer pageCurr) {
      this.serverInfoStatusService.setPrimaryServerById(serverid);
      model.addAttribute("toPageCurr", pageCurr);
      return "core/haserverinfo/haserverinfolist";
   }

   @RequestMapping({"/detail"})
   public String detail(HttpServletRequest request, HttpServletResponse response, Model model, String serverid, Integer pageCurr) throws SQLException {
      model.addAttribute("serverid", serverid);
      model.addAttribute("pageCurr", pageCurr);
      TCoreServerInfoStatus tCoreServerInfoStatus = this.serverInfoStatusService.queryServerById(serverid);
      model.addAttribute("info", tCoreServerInfoStatus);
      return "core/haserverinfo/detailserver";
   }

   @RequestMapping(
      value = {"/removeServer"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public String removeServer(String serverid, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (null == pageCurr || 0 == pageCurr) {
         pageCurr = 1;
      }

      TCoreServerInfoStatus reInfo = this.serverInfoStatusService.queryServerById(serverid);
      reInfo.setDelflg("1");
      reInfo.setUpdatetime(new Date());
      this.serverInfoStatusService.updateHaServer(reInfo);
      model.addAttribute("toPageCurr", pageCurr);
      return "core/haserverinfo/haserverinfolist";
   }

   @RequestMapping({"/isRepeatName"})
   @ResponseBody
   public boolean isRepeatName(String servername) {
      Boolean reFlg = false;
      if (StringUtils.isNotBlank(servername)) {
         TCoreServerInfoStatus tCoreServerInfoStatus = this.serverInfoStatusService.queryServerByName(servername);
         if (null != tCoreServerInfoStatus) {
            reFlg = true;
         }
      }

      return reFlg;
   }

   @RequestMapping({"/createCase"})
   @ResponseBody
   public String createCase(HttpServletRequest request, HttpServletResponse response, TCoreServiceStatus tcoreServiceStatus) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      String flag = this.serverInfoStatusService.createCase(tcoreServiceStatus, username);
      return flag;
   }

   @RequestMapping({"/delServer"})
   @ResponseBody
   public void delServer(String id) {
      TCoreEngineServerInfo tCoreEngineServerInfo = this.serverInfoStatusService.findServerEngineByServerid(id);
      TCoreServerInfoStatus tCoreServerInfoStatus = this.serverInfoStatusService.findServerStatusByServerid(id);
      TCoreServiceStatus tCoreServiceStatus = this.serverInfoStatusService.findBytid(id);
      Map map = new HashMap();
      if (tCoreEngineServerInfo != null) {
         tCoreEngineServerInfo.setDelflg("1");
         tCoreEngineServerInfo.setUpdatetime(new Date());
         map.put("tCoreEngineServerInfo", tCoreEngineServerInfo);
      }

      if (tCoreServerInfoStatus != null) {
         tCoreServerInfoStatus.setDelflg("1");
         tCoreServerInfoStatus.setUpdatetime(new Date());
         map.put("tCoreServerInfoStatus", tCoreServerInfoStatus);
      }

      if (tCoreServiceStatus != null) {
         System.out.println(tCoreServiceStatus);
         tCoreServiceStatus.setDelflg("1");
         tCoreServiceStatus.setUpdatetime(new Date());
         map.put("tCoreServiceStatus", tCoreServiceStatus);
      }

      this.serverInfoStatusService.del(map);
   }

   @RequestMapping({"/pingIp"})
   @ResponseBody
   public void pingIp() {
      this.serverInfoStatusService.pingIp();
   }
}
