package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.vo.TmaskingRuleCustMapping;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/importmaskingrule"})
public class ImportMaskingRuleController {
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private DictionaryService dictionaryService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/importmaskingrule";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/querymaskingrule"})
   public List<TmaskingRuleCustMapping> querymaskingrule(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (StringTool.emptyOrNull(engineid)) {
         return null;
      } else {
         List<TmaskingRuleCustMapping> list = this.importMaskingRuleService.queryRuleCustByEngineId(engineid);
         return list;
      }
   }

   @ResponseBody
   @RequestMapping({"/importrule"})
   public void importmaskingrule(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      InfoProperty info = this.importMaskingRuleService.queryEngineById(engineid);
      Connection conn = this.dataSystemService.getConnectionByDataSystemId(info.getDatasystemid());
      String sql = " select subject_area,mapplet_name from rep_all_mapplets order by 1,2  ";
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      List<TCoreMaskingRule> list = new ArrayList();

      try {
         pstmt = conn.prepareStatement(sql);
         rs = pstmt.executeQuery();
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
            pstmt.close();
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      this.importMaskingRuleService.importMaskingRule(engineid, list);
   }

   @ResponseBody
   @RequestMapping({"/saverule"})
   public void saverule(@RequestBody List<TCoreMaskingRule> list, HttpServletResponse response, Model model) {
      this.importMaskingRuleService.saveRule(list);
   }

   @ResponseBody
   @RequestMapping({"/queryruletype"})
   public List<TConsoleDictionary> queryruletype() {
      List<TConsoleDictionary> list = this.dictionaryService.queryRuleType();
      return list;
   }
}
