package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.differentdb.DesensitizationTargerTypeConversion;
import com.chenyang.nse.bussiness.entity.orm.table.core.differentdb.DidderentdbJavaMappingType;
import com.chenyang.nse.bussiness.entity.orm.table.core.differentdb.DifferetdbFieldMapping;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingFlag;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.core.DidderentdbJavaMappingTypeService;
import com.chenyang.nse.bussiness.service.core.DifferetdbFieldMappingService;
import com.chenyang.nse.bussiness.service.core.JavaConversionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/javaconversion"})
public class JavaConversionController {
   @Autowired
   private JavaConversionService javaConversionService;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private DifferetdbFieldMappingService differetdbFieldMappingService;
   @Autowired
   private DidderentdbJavaMappingTypeService didderentdbJavaMappingTypeService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      return "core/javaconversion/javaconversionlist";
   }

   @RequestMapping({"/getdatatype"})
   @ResponseBody
   public List<ComboboxVO> getdatatype() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingType em : EdataMappingType.values()) {
         String dbtypeName = em.getName();
         if (!"FILESYSTEM".equalsIgnoreCase(dbtypeName) && !"HIVE".equalsIgnoreCase(dbtypeName)) {
            ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
            list.add(vo);
         }
      }

      return list;
   }

   @RequestMapping({"/getdataconversioninfo"})
   @ResponseBody
   public DataGridVO<DesensitizationTargerTypeConversion> getdataconversioninfo(String dbtype, Integer page, Integer rows, PageInfo pageInfo) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      DataGridVO<DesensitizationTargerTypeConversion> vo = this.javaConversionService.getdataconversioninfo(dbtype, pageInfo);
      return vo;
   }

   @RequestMapping({"/getfiledIsExits"})
   @ResponseBody
   public String getfiledIsExits(String dbtype, String filedtype, HttpServletRequest request, HttpServletResponse response) {
      String flag = "0";
      flag = this.javaConversionService.queryFiledTypeCount(dbtype, filedtype);
      return flag;
   }

   @RequestMapping({"/getdataflag"})
   @ResponseBody
   public List<ComboboxVO> getdataflag() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingFlag em : EdataMappingFlag.values()) {
         ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/insertdatainfo"})
   @ResponseBody
   public void insertdatainfo(@RequestParam Map<String, String> map) {
      LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
      DesensitizationTargerTypeConversion dbttypeConversion = new DesensitizationTargerTypeConversion();
      dbttypeConversion.setDatasystemtype((String)map.get("dbtypeid"));
      dbttypeConversion.setTargertype((String)map.get("filedtype"));
      dbttypeConversion.setJavatype((String)map.get("javatype"));
      dbttypeConversion.setNote((String)map.get("note"));
      dbttypeConversion.setCreateuserid(loginUser.getTsysUser().getUsername());
      dbttypeConversion.setCreatetime(new Date());
      this.javaConversionService.saveinfo(dbttypeConversion);
   }

   @RequestMapping({"/updatedatainfo"})
   @ResponseBody
   public void updatedatainfo(@RequestParam Map<String, String> map) {
      LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
      DesensitizationTargerTypeConversion dbttypeConversion = this.javaConversionService.queryDateById((String)map.get("id"));
      dbttypeConversion.setDatasystemtype((String)map.get("udbtypeid"));
      dbttypeConversion.setTargertype((String)map.get("ufiledtype"));
      dbttypeConversion.setJavatype((String)map.get("ujavatype"));
      dbttypeConversion.setNote((String)map.get("unote"));
      dbttypeConversion.setUpdateuserid(loginUser.getTsysUser().getUsername());
      dbttypeConversion.setUpdatetime(new Date());
      this.javaConversionService.updateinfo(dbttypeConversion);
   }

   @RequestMapping({"/deldatainfo"})
   @ResponseBody
   public void deldatainfo(String id) {
      this.javaConversionService.deldatainfo(id);
   }

   @RequestMapping({"/selectfieldMapping"})
   @ResponseBody
   public List<DifferetdbFieldMapping> selectfieldMapping(String dbid) {
      List<DifferetdbFieldMapping> selectDifferetdbFieldMappingService = this.differetdbFieldMappingService.selectDifferetdbFieldMapping(dbid);
      return selectDifferetdbFieldMappingService;
   }

   @RequestMapping({"/selectAlljavaMapping"})
   @ResponseBody
   public List<DidderentdbJavaMappingType> selectAlljavaMapping() {
      return this.didderentdbJavaMappingTypeService.selectAllJavaMapping();
   }
}
