package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleMappletInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.mappletxml.MappletxmlDetailsService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/customdesensitizationrulesdetails"})
public class MappletxmlDetailsController {
   @Autowired
   private MappletxmlDetailsService mappletxmlDetailsService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/customdesensitizationrules/customdesensitizationrulesdetails";
   }

   @ResponseBody
   @RequestMapping({"/selectMappletxmlDetails"})
   public DataGridVO<TCoreRuleMappletInfo> selectMappletxmlDetails(PageInfo pageinfo, String filterRules, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageinfo.setPageno(page);
      pageinfo.setPagesize(rows);
      DataGridVO<TCoreRuleMappletInfo> vo = this.mappletxmlDetailsService.selectMappletxmlDetails(pageinfo);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/selectMappletxmlList"})
   public List<TCoreRuleMappletInfo> selectMappletxmlList(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreRuleMappletInfo> list = this.mappletxmlDetailsService.selectMappletxmlList();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/selectMapplet"})
   public List<TCoreRuleMappletInfo> selectMapplet(String mappletname, String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
      format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
      format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
      format.setVCharType(HanyuPinyinVCharType.WITH_V);
      char[] charArray = mappletname.trim().toCharArray();
      String output = "";

      try {
         for(int i = 0; i < charArray.length; ++i) {
            if (Character.toString(charArray[i]).matches("[\\u4E00-\\u9FA5]+")) {
               String[] temp = PinyinHelper.toHanyuPinyinStringArray(charArray[i], format);
               output = output + temp[0];
            } else {
               output = output + Character.toString(charArray[i]);
            }
         }
      } catch (BadHanyuPinyinOutputFormatCombination e) {
         e.printStackTrace();
      }

      List<TCoreRuleMappletInfo> list = this.mappletxmlDetailsService.selectMapplet(output, id);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/deleteMappletxmlDetails"})
   public String deleteMappletxmlDetails(String mappletxmldetailsid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String string = this.mappletxmlDetailsService.deleteMappletxmlDetails(mappletxmldetailsid);
      return string;
   }

   @RequestMapping({"/updataMappletxmlDetails"})
   public String updataMappletxmlDetails(String mappletxmldetailsid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("mappletxmldetailsid", mappletxmldetailsid);
      return "core/customdesensitizationrules/customdesensitizationrules";
   }

   @RequestMapping({"/addMappletxml"})
   public String addMappletxml(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/customdesensitizationrules/customdesensitizationrules";
   }
}
