package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TXmlProperties;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.PropertiesEditService;
import com.chenyang.nse.bussiness.tools.xml.PropertiesTool;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/propertiesedit"})
public class PropertiesEditController {
   @Autowired
   private PropertiesEditService propertiesEditService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/propertiesedit/propertiesedit";
   }

   @RequestMapping({"/getpropertieselist"})
   @ResponseBody
   public DataGridVO<TXmlProperties> getPropertieseList(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TXmlProperties> list = PropertiesTool.getAllProperty();
      List<TXmlProperties> list1 = this.propertiesEditService.getPropertieseList(list, pageInfo);
      DataGridVO<TXmlProperties> vo = new DataGridVO<TXmlProperties>(pageInfo.getCount(), list1);
      return vo;
   }

   @RequestMapping({"/querypvalue"})
   @ResponseBody
   public DataGridVO<TXmlProperties> queryPvalue(String Pvalue, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TXmlProperties> list = PropertiesTool.getAllProperty();
      List<TXmlProperties> list1 = this.propertiesEditService.queryPvalue(Pvalue, list, pageInfo);
      DataGridVO<TXmlProperties> vo = new DataGridVO<TXmlProperties>(pageInfo.getCount(), list1);
      return vo;
   }

   @RequestMapping({"/editpropertieselist"})
   @ResponseBody
   public TXmlProperties editPropertieseList(String key, HttpServletRequest request, HttpServletResponse response, Model model) {
      TXmlProperties tx = this.propertiesEditService.getPropertiese(key);
      return tx;
   }

   @RequestMapping({"/addpropertieselist"})
   @ResponseBody
   public String addPropertieseList(TXmlProperties tproperties, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.propertiesEditService.remove(tproperties.getPkey());
      String value = tproperties.getPvalue();
      value = value.replace("\\\\", "\\");
      tproperties.setPvalue(value);
      tproperties.setCreatetime(new Date());
      PropertiesTool.addProperty(tproperties.getPkey(), value);
      this.propertiesEditService.save(tproperties);
      return null;
   }

   @RequestMapping({"/delpropertieselist"})
   @ResponseBody
   public String delPropertieseList(String key, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean success = PropertiesTool.delProperty(key);
      this.propertiesEditService.remove(key);
      return null;
   }

   @RequestMapping({"/hasKey"})
   @ResponseBody
   public void hasKey(String key, HttpServletRequest request, HttpServletResponse response, Model model) {
      request.getSession().setAttribute("hasKey", PropertiesTool.hasKey(key));
      PropertiesTool.addProperty(key, "");
   }

   @RequestMapping({"/isrepeat"})
   @ResponseBody
   public boolean isrepeatpkey(String Pkey) {
      TXmlProperties queryTaskByPkey = this.propertiesEditService.queryTaskByPkey(Pkey);
      return queryTaskByPkey == null;
   }
}
