package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryCondition;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DiscoveryConditionService;
import com.chenyang.nse.bussiness.service.core.DiscoverySensitivecolumnService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.MaskingRuleService;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/sensitivecolumn"})
public class SensitiveColumnController {
   @Autowired
   private SensitiveColumnService sensitiveColumnService;
   @Autowired
   private MaskingRuleService ruleService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private DiscoveryConditionService discoveryConditionService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private DiscoverySensitivecolumnService discoverySensitivecolumnService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private RedisService redisService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/sensitivecolumn/sensitivecolumn";
   }

   @RequestMapping({"/remove"})
   public void remove(String sensitivecolumnid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.sensitiveColumnService.remove(sensitivecolumnid);
   }

   @RequestMapping({"/queryAllSensitiveColumns"})
   @ResponseBody
   public DataGridVO<TCoreSensitivecolumn> queryAllSensitiveColumns(Boolean sensitive, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreSensitivecolumn> list;
      if (sensitive) {
         list = this.sensitiveColumnService.queryValidSensitiveColumns(pageInfo);
      } else {
         list = this.sensitiveColumnService.queryAllSensitiveColumns(pageInfo);
      }

      DataGridVO<TCoreSensitivecolumn> vo = new DataGridVO<TCoreSensitivecolumn>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/queryAllSensitiveGroupPage"})
   @ResponseBody
   public DataGridVO<TCoreSensitivegroup> queryAllSensitiveGroup(Boolean sensitive, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreSensitivegroup> list = this.sensitiveColumnService.queryAllSensitiveGroupPage(pageInfo);
      DataGridVO<TCoreSensitivegroup> vo = new DataGridVO<TCoreSensitivegroup>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/queryAllSensitiveColumnsNoPage"})
   @ResponseBody
   public List<TCoreSensitivecolumn> queryAllSensitiveColumnsNoPage(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveColumns();
      return listt;
   }

   @RequestMapping({"/queryAllSensitiveColumnsNoPageByGroupidByTime"})
   @ResponseBody
   public List<TCoreSensitivecolumn> queryAllSensitiveColumnsNoPage(String groupid, String time, HttpServletRequest request, HttpServletResponse response, Model model) {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String sd = sdf.format(new Date(Long.parseLong(time)));
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveColumns(groupid, sd);
      return listt;
   }

   @RequestMapping({"/queryAllSensitiveTimeByGroupid"})
   @ResponseBody
   public void queryAllSensitiveTimeByGroupid(String groupid, HttpServletRequest request, HttpServletResponse response, Model model) {
      PrintWriter writer = null;
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveTimeByGroupid(groupid);
      List<HashMap> listh = new ArrayList();

      for(int i = 1; i < listt.size(); ++i) {
         HashMap map = new HashMap();
         map.put("id", ((TCoreSensitivecolumn)listt.get(i)).getId());
         map.put("timestamp", ((TCoreSensitivecolumn)listt.get(i)).getCreatetime());
         map.put("time", DateTimeTool.getDateString(((TCoreSensitivecolumn)listt.get(i)).getCreatetime()));
         listh.add(map);
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(listh));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @RequestMapping({"/removeSensitiveByGroupid"})
   @ResponseBody
   public int removeSensitiveByGroupid(String groupid, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.removeSensitivecolumn(groupid);
   }

   @RequestMapping({"/removeSensitiveByGroupidByTime"})
   @ResponseBody
   public int removeSensitiveByGroupidByTime(String groupid, String time, HttpServletRequest request, HttpServletResponse response, Model model) {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String sd = sdf.format(new Date(Long.parseLong(time)));
      return this.sensitiveColumnService.removeSensitivecolumn(groupid, sd);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/getSensitiveByIdBySchema"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByIdBySchema(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String datasystemid = (String)parameter.get("datasystemid");
      String schema = (String)parameter.get("schema");
      String table = (String)parameter.get("table");
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      new ArrayList();
      if (table != null) {
         Object obj = this.redisService.get(table + "+" + schema);
         if (obj != null) {
            new ArrayList();
            List<TCoreFieldSensitiveMemory> e = (List)obj;

            for(int i = 0; i < e.size(); ++i) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(((TCoreFieldSensitiveMemory)e.get(i)).getColumnname());
               tcoreDiscoverySensitivecolumn.setRegextype(((TCoreFieldSensitiveMemory)e.get(i)).getRegextype());
               tcoreDiscoverySensitivecolumn.setRuleid(((TCoreFieldSensitiveMemory)e.get(i)).getRuleid());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }

         try {
            request.setCharacterEncoding("utf8");
            response.setCharacterEncoding("utf8");
            response.setContentType("text/json; charset=utf-8");
            writer = response.getWriter();
            writer.print(JSON.toJSON(list));
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @ResponseBody
   @RequestMapping(
      value = {"/getSensitiveByStructureId"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByDatasystemid(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String note = (String)parameter.get("structureid");
      new ArrayList();
      new ArrayList();
      List<TCoreSensitivecolumn> list = this.sensitiveColumnService.getSensitiveByStructureId(note);

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryAllTableByGroup"},
      method = {RequestMethod.GET}
   )
   public void queryAllTableByGroup(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      long a = System.currentTimeMillis();
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveColumns();
      long b = System.currentTimeMillis();
      List<TCoreSensitivegroup> listname = this.sensitiveColumnService.queryAllSensitiveGroup();
      List<HashMap> grouplist = new ArrayList();

      for(int j = 0; j < listname.size(); ++j) {
         TCoreSensitivegroup tg = (TCoreSensitivegroup)listname.get(j);
         HashMap grouph = new HashMap();
         grouph.put("id", tg.getId());
         grouph.put("text", tg.getTname());
         grouph.put("state", "closed");
         grouph.put("flag", "1");
         int tj = 0;
         List<HashMap> childrenlist = new ArrayList();

         for(int i = 0; i < listt.size(); ++i) {
            new TCoreSensitivecolumn();
            TCoreSensitivecolumn listTemp = (TCoreSensitivecolumn)listt.get(i);
            if (listTemp.getGroupid().equals(tg.getId())) {
               HashMap childrenm = new HashMap();
               childrenm.put("id", listTemp.getId());
               childrenm.put("groupid", listTemp.getGroupid());
               childrenm.put("text", listTemp.getTablename());
               childrenlist.add(childrenm);
               ++tj;
            }
         }

         if (tj == 0) {
            HashMap childrenm = new HashMap();
            childrenm.put("id", "");
            childrenm.put("groupid", "");
            childrenm.put("text", "没有表");
            childrenlist.add(childrenm);
            ++tj;
         }

         Iterator<HashMap> it = childrenlist.iterator();
         List<String> listTemp = new ArrayList();

         while(it.hasNext()) {
            String aa = (String)((HashMap)it.next()).get("text");
            if (listTemp.contains(aa)) {
               it.remove();
            } else {
               listTemp.add(aa);
            }
         }

         grouph.put("children", childrenlist);
         grouplist.add(grouph);
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(grouplist));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/queryAllInfor"})
   public void queryAllInfor(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String groupid = (String)parameter.get("groupid");
      long a = System.currentTimeMillis();
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.querySensitiveColumnsByGroupId(groupid);
      long b = System.currentTimeMillis();
      String data = "";
      int table = 0;
      String schema = "";
      new Date();
      String admin = "";
      String timestring = "";
      if (listt != null) {
         table = listt.size();
      }

      HashSet set = new HashSet();

      for(int i = 0; i < listt.size(); ++i) {
         set.add(((TCoreSensitivecolumn)listt.get(i)).getTschema());
         Date time = ((TCoreSensitivecolumn)listt.get(0)).getCreatetime();
         timestring = DateTimeTool.getDateString(time);
         admin = ((TCoreSensitivecolumn)listt.get(0)).getAdminname();
         data = ((TCoreSensitivecolumn)listt.get(0)).getDatasourcename();
      }

      Iterator iter = set.iterator();

      String temp;
      for(temp = ""; iter.hasNext(); temp = (String)iter.next() + ",") {
      }

      if (temp.length() > 0) {
         temp = temp.substring(0, temp.length() - 1);
      }

      long c = System.currentTimeMillis();
      HashMap hp = new HashMap();
      hp.put("total", table);
      List<HashMap> grouplist = new ArrayList();
      HashMap ph = new HashMap();
      ph.put("data", data);
      ph.put("schema", temp);
      ph.put("time", timestring);
      ph.put("admin", admin);
      ph.put("table", table);
      grouplist.add(ph);
      hp.put("rows", grouplist);
      System.out.println(b - a);
      System.out.println(c - b);

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(hp));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/queryAllTableInfor"})
   public void queryAllTableInfor(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String groupid = (String)parameter.get("groupid");
      String table = (String)parameter.get("table");
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.querySensitiveColumnsByGroupIdByTable(groupid, table);
      List<TCoreMaskingRule> tcoreMaskingRule = this.ruleService.queryRuleByFlag();
      HashMap<String, String> hname = new HashMap();

      for(int i = 0; i < tcoreMaskingRule.size(); ++i) {
         hname.put(((TCoreMaskingRule)tcoreMaskingRule.get(i)).getId(), ((TCoreMaskingRule)tcoreMaskingRule.get(i)).getRulename());
      }

      for(TCoreSensitivecolumn tc : listt) {
         tc.setRulename((String)hname.get(tc.getRuleid()));
      }

      int total = 0;
      if (listt != null) {
         total = listt.size();
      }

      HashMap hp = new HashMap();
      hp.put("total", listt.size());
      hp.put("rows", listt);

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(listt));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/setsession"})
   public void setsession(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String groupid = (String)parameter.get("groupid");
      String issmart = (String)parameter.get("smart");
      request.getSession().setAttribute("groupid", groupid);
      request.getSession().setAttribute("issmart", issmart);
      TConsoleLog record = new TConsoleLog();
      LoginUser user = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = user.getTsysUser().getUsername();
      record.setLogmessage("敏感数据重新发现");
      record.setModule("敏感数据发现");
      record.setOperationtime(new Date());
      record.setUser(username);
      this.operationService.add(record);
   }

   @ResponseBody
   @RequestMapping({"/getsession"})
   public void getsession(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String groupid = (String)request.getSession().getAttribute("groupid");
      String issmart = (String)request.getSession().getAttribute("issmart");
      request.getSession().removeAttribute("groupid");
      request.getSession().removeAttribute("issmart");
      HashMap<String, Object> hash = new HashMap();
      String groupName = "";
      if (groupid == null) {
         groupid = "";
      }

      if (StringUtils.isNotBlank(groupid)) {
         groupName = this.discoverytaskService.get(groupid).getTname();
         List<TcoreDiscoveryCondition> list = this.discoveryConditionService.queryDiscoveryConditionByTaskId(groupid);
         String datasystemid = "";
         String type = "";
         long maxRowCount = 0L;
         double rate = (double)0.0F;
         String jiegou = "";
         List<String> schemas = new ArrayList();
         List<String> typelist = new ArrayList();
         List<String> namelist = new ArrayList();
         List<String> regexlist = new ArrayList();
         TCoreFileStructure tfs = new TCoreFileStructure();

         for(TcoreDiscoveryCondition log : list) {
            switch (log.getParameterid()) {
               case 1:
                  datasystemid = log.getParametercontent();
                  break;
               case 2:
                  schemas.add(log.getParametercontent());
                  break;
               case 3:
                  try {
                     maxRowCount = Long.parseLong(log.getParametercontent());
                  } catch (Exception var33) {
                     maxRowCount = 1000L;
                  }
                  break;
               case 4:
                  try {
                     rate = Double.parseDouble(log.getParametercontent());
                  } catch (Exception var32) {
                     rate = 0.8;
                  }
                  break;
               case 5:
                  typelist.add(log.getParametercontent());
                  break;
               case 6:
                  namelist.add(log.getParametercontent());
                  break;
               case 7:
                  regexlist.add(log.getParametercontent());
                  break;
               case 8:
                  type = log.getParametercontent();
                  break;
               case 9:
                  jiegou = log.getParametercontent();
                  if (StringUtils.isNotBlank(jiegou)) {
                     tfs = this.fileSystemService.getInfoByPk(jiegou);
                  }
            }
         }

         HashMap<String, List<HashMap<String, String>>> scMap = new HashMap();
         if ("1".equals(this.discoverytaskService.get(groupid).getIsdmpflag())) {
            for(String schema : schemas) {
               HashMap<String, String> tMap = new HashMap();
               List<HashMap<String, String>> schemaslist = new ArrayList();
               String[] scArr = schema.split("~");
               String sc = scArr[0];
               String tableName = scArr[1];
               tMap.put("tablename", tableName);
               if (null != scMap.get(sc)) {
                  schemaslist = (List)scMap.get(sc);
               }

               schemaslist.add(tMap);
               scMap.put(sc, schemaslist);
            }
         } else {
            TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
            hash.put("modetype", datasystem.getFlag());
            hash.put("datasourceimg", datasystem.getDbtype().toLowerCase());
            hash.put("datasourcename", datasystem.getSysname());
            if (!"2".equals(datasystem.getFlag())) {
               for(String schema : schemas) {
                  HashMap<String, String> tMap = new HashMap();
                  List<HashMap<String, String>> schemaslist = new ArrayList();
                  String[] scArr = schema.split("~");
                  String sc = scArr[0];
                  String tableName = scArr[1];
                  tMap.put("tablename", tableName);
                  if (null != scMap.get(sc)) {
                     schemaslist = (List)scMap.get(sc);
                  }

                  schemaslist.add(tMap);
                  scMap.put(sc, schemaslist);
               }
            }
         }

         hash.put("maxRowCount", maxRowCount);
         hash.put("rate", rate);
         hash.put("datasystemid", datasystemid);
         hash.put("schemas", scMap);
         hash.put("namelist", namelist);
         hash.put("typelist", typelist);
         hash.put("regexlist", regexlist);
         hash.put("type", type);
         hash.put("jiegou", jiegou);
         hash.put("selectedfilestructure", tfs);
         hash.put("groupName", groupName);
         hash.put("groupid", groupid);
         hash.put("issmart", issmart);
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(hash));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/queryAllTableInforZuoYou"})
   public void queryAllTableInforZuoYou(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String groupid = (String)parameter.get("groupid");
      String time = (String)parameter.get("time");
      String state = (String)parameter.get("state");
      if (state.equals("2")) {
         List<TCoreSensitivecolumn> listyou = (List)request.getSession().getAttribute("list");

         try {
            request.setCharacterEncoding("utf8");
            response.setCharacterEncoding("utf8");
            response.setContentType("text/json; charset=utf-8");
            writer = response.getWriter();
            writer.print(JSON.toJSON(listyou));
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if (state.equals("1")) {
         Date date = new Date();
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         Long ltime = new Long(time);
         String d = format.format(ltime);

         try {
            date = format.parse(d);
         } catch (ParseException e1) {
            e1.printStackTrace();
         }

         List<TCoreSensitivecolumn> listlishi = this.sensitiveColumnService.querySensitiveColumnsByGroupIdByTime(groupid, date);
         List<TCoreSensitivecolumn> listnew = this.sensitiveColumnService.querySensitiveColumnsByGroupIdNew(groupid);
         List<TCoreMaskingRule> tcoreMaskingRule = this.ruleService.queryRuleByFlag();
         HashMap<String, String> hname = new HashMap();

         for(int i = 0; i < tcoreMaskingRule.size(); ++i) {
            hname.put(((TCoreMaskingRule)tcoreMaskingRule.get(i)).getId(), ((TCoreMaskingRule)tcoreMaskingRule.get(i)).getRulename());
         }

         List<TCoreSensitivecolumn> listzuo = new ArrayList();
         List<TCoreSensitivecolumn> listyou = new ArrayList();
         new ArrayList();
         listzuo.addAll(listnew);
         boolean flag = false;
         int zuixincout = listnew.size();
         int lishicout = listlishi.size();

         for(int i = 0; i < listnew.size(); ++i) {
            ((TCoreSensitivecolumn)listnew.get(i)).setRulename((String)hname.get(((TCoreSensitivecolumn)listnew.get(i)).getRuleid()));

            for(int j = 0; j < listlishi.size(); ++j) {
               flag = false;
               String tablenew = ((TCoreSensitivecolumn)listnew.get(i)).getTschema() + ((TCoreSensitivecolumn)listnew.get(i)).getTablename() + ((TCoreSensitivecolumn)listnew.get(i)).getColumnname();
               String tablelishi = ((TCoreSensitivecolumn)listlishi.get(j)).getTschema() + ((TCoreSensitivecolumn)listlishi.get(j)).getTablename() + ((TCoreSensitivecolumn)listlishi.get(j)).getColumnname();
               if (tablenew.equals(tablelishi)) {
                  flag = true;
                  ((TCoreSensitivecolumn)listlishi.get(j)).setRulename((String)hname.get(((TCoreSensitivecolumn)listlishi.get(j)).getRuleid()));
                  listyou.add(listlishi.get(j));
                  listlishi.remove(j);
                  break;
               }
            }

            if (!flag) {
               TCoreSensitivecolumn k = new TCoreSensitivecolumn();
               listyou.add(k);
            }
         }

         for(int i = 0; i < listlishi.size(); ++i) {
            TCoreSensitivecolumn k = new TCoreSensitivecolumn();
            listzuo.add(k);
            listyou.add(listlishi.get(i));
         }

         request.getSession().setAttribute("list", listyou);

         try {
            request.setCharacterEncoding("utf8");
            response.setCharacterEncoding("utf8");
            response.setContentType("text/json; charset=utf-8");
            writer = response.getWriter();
            if (state.equals("1")) {
               writer.print(JSON.toJSON(listzuo));
            } else {
               writer.print(JSON.toJSON(listyou));
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @ResponseBody
   @RequestMapping({"/queryAllCountInfor"})
   public void queryAllCountInfor(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveColumns();
      HashSet<String> hast = new HashSet();

      for(int i = 0; i < listt.size(); ++i) {
         hast.add(((TCoreSensitivecolumn)listt.get(i)).getGroupname());
      }

      List<Integer> listi = new ArrayList();
      List<String> lists = new ArrayList();
      Iterator it = hast.iterator();

      while(it.hasNext()) {
         lists.add((String)it.next());
      }

      for(int l = 0; l < lists.size(); ++l) {
         int num = 0;

         for(int j = 0; j < listt.size(); ++j) {
            if (((String)lists.get(l)).equals(((TCoreSensitivecolumn)listt.get(j)).getGroupname())) {
               ++num;
            }
         }

         listi.add(num);
      }

      HashMap hamp = new HashMap();
      hamp.put("name", hast);
      List<HashMap> map = new ArrayList();

      for(int i = 0; i < listi.size(); ++i) {
         HashMap n = new HashMap();
         n.put("value", listi.get(i));
         n.put("name", lists.get(i));
         map.add(n);
      }

      hamp.put("count", map);

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(hamp));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
