package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.vo.subset.SubsetInfoVo;
import com.chenyang.nse.bussiness.service.core.subsetmanagement.TCoreSubsetManagementService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/subsetmanagement"})
public class SubsetManagementController {
   @Autowired
   private TCoreSubsetManagementService tCoreSubsetManagementService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/subsetmanagement/subsetmanagement";
   }

   @RequestMapping({"/querysubset"})
   @ResponseBody
   public List<SubsetInfoVo> querysubset(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<SubsetInfoVo> list = this.tCoreSubsetManagementService.querysubset();
      return list;
   }

   @RequestMapping({"/deletesubset"})
   @ResponseBody
   public String deletesubset(String subid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String deletesubset = this.tCoreSubsetManagementService.deletesubset(subid);
      return deletesubset;
   }

   @RequestMapping({"/savesubset"})
   @ResponseBody
   public String savesubset(@RequestBody List<SubsetInfoVo> subsetlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      String succuss = this.tCoreSubsetManagementService.savesubset(subsetlist);
      return succuss;
   }

   @RequestMapping({"/searchsubset"})
   @ResponseBody
   public List<SubsetInfoVo> searchsubset(String subname, String schemaName, String systemName, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<SubsetInfoVo> list = this.tCoreSubsetManagementService.searchsubset(subname, schemaName, systemName, tablename);
      return list;
   }
}
